/*
 * Decompiled with CFR 0.152.
 */
package network.aika.debugger;

import java.awt.Component;
import java.awt.event.MouseWheelListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import network.aika.Model;
import network.aika.debugger.AbstractConsoleManager;
import network.aika.debugger.AbstractGraphManager;
import network.aika.debugger.CoordinateListener;
import network.aika.debugger.MouseManager;
import network.aika.neuron.Neuron;
import network.aika.neuron.Synapse;
import network.aika.neuron.Templates;
import network.aika.neuron.conjunctive.BindingNeuron;
import network.aika.neuron.conjunctive.PatternNeuron;
import network.aika.neuron.disjunctive.CategoryNeuron;
import network.aika.neuron.disjunctive.InhibitoryNeuron;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Element;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.graph.implementations.SingleGraph;
import org.graphstream.stream.ProxyPipe;
import org.graphstream.stream.Sink;
import org.graphstream.stream.Source;
import org.graphstream.stream.thread.ThreadProxyPipe;
import org.graphstream.ui.graphicGraph.GraphicElement;
import org.graphstream.ui.layout.Layout;
import org.graphstream.ui.swing.SwingGraphRenderer;
import org.graphstream.ui.swing_viewer.DefaultView;
import org.graphstream.ui.swing_viewer.SwingViewer;
import org.graphstream.ui.swing_viewer.ViewPanel;
import org.graphstream.ui.view.GraphRenderer;
import org.graphstream.ui.view.Viewer;
import org.graphstream.ui.view.ViewerPipe;
import org.graphstream.ui.view.camera.Camera;

public abstract class AbstractViewManager<N, C extends AbstractConsoleManager, G extends AbstractGraphManager> {
    protected Map<Class<? extends Neuron>, Consumer<Node>> neuronTypeModifiers = new HashMap<Class<? extends Neuron>, Consumer<Node>>();
    protected Map<Byte, String> synapseTypeModifiers = new HashMap<Byte, String>();
    protected boolean highlightEnabled = true;
    protected Graph graph;
    protected G graphManager;
    protected C consoleManager;
    protected Layout layout;
    protected SwingViewer viewer;
    protected ViewerPipe fromViewer;
    protected ViewPanel graphView;
    protected JComponent view;
    protected Element lastHighlighted;
    private Model model;
    private CoordinateListener<N> coordinateListener;
    private Set<String> movedManually = new HashSet<String>();
    private boolean debugMode = false;
    private boolean scopeMode = false;

    public AbstractViewManager(Model model, C consoleManager) {
        this.model = model;
        this.consoleManager = consoleManager;
        this.initModifiers();
        this.graph = this.initGraph();
        this.viewer = new SwingViewer((ProxyPipe)new ThreadProxyPipe((Source)this.graph));
        this.graphView = (DefaultView)this.viewer.addDefaultView(false, (GraphRenderer)new SwingGraphRenderer());
        this.graphView.enableMouseOptions();
        MouseManager mouseManager = new MouseManager(this);
        this.graphView.setMouseManager((org.graphstream.ui.view.util.MouseManager)mouseManager);
        this.graphView.addMouseWheelListener((MouseWheelListener)mouseManager);
        Camera camera = this.graphView.getCamera();
        camera.setAutoFitView(false);
        this.viewer.setCloseFramePolicy(Viewer.CloseFramePolicy.HIDE_ONLY);
        this.fromViewer = this.viewer.newViewerPipe();
        this.fromViewer.addSink((Sink)this.graph);
    }

    protected void addTemplateAttributes(Element e) {
        String oldStyle = (String)e.getAttribute("ui.style");
        e.setAttribute("ui.style", new Object[]{oldStyle + " stroke-mode:dots;"});
    }

    public CoordinateListener<N> getCoordinateListener() {
        return this.coordinateListener;
    }

    public void setCoordinateListener(CoordinateListener<N> coordinateListener) {
        this.coordinateListener = coordinateListener;
    }

    public boolean hasBeenMovedManually(String key) {
        return this.movedManually.contains(key);
    }

    public void setMovedManually(String key, boolean v) {
        if (v) {
            this.movedManually.add(key);
        } else {
            this.movedManually.remove(key);
        }
    }

    public C getConsoleManager() {
        return this.consoleManager;
    }

    public void setConsoleManager(C consoleManager) {
        this.consoleManager = consoleManager;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean debugMode) {
        this.dumpViewPortInfo();
        this.debugMode = debugMode;
    }

    protected void dumpViewPortInfo() {
        Camera cam = this.viewer.getDefaultView().getCamera();
        System.out.print("Viewport: ");
        for (double s : cam.getMetrics().viewport) {
            System.out.print(s + ", ");
        }
        System.out.println();
        System.out.println("ViewPercent: " + cam.getViewPercent());
        System.out.println("ratioPx2Gu: " + cam.getMetrics().ratioPx2Gu);
    }

    public boolean isScopeMode() {
        return this.scopeMode;
    }

    public void setScopeMode(boolean scopeMode) {
        this.scopeMode = scopeMode;
    }

    public boolean isHighlightEnabled() {
        return this.highlightEnabled;
    }

    public void setHighlightEnabled(boolean highlightEnabled) {
        this.highlightEnabled = highlightEnabled;
    }

    public void enableAutoLayout() {
        this.viewer.enableAutoLayout(this.layout);
    }

    public void disableAutoLayout() {
        this.viewer.disableAutoLayout();
    }

    public Model getModel() {
        return this.model;
    }

    public G getGraphManager() {
        return this.graphManager;
    }

    public abstract void showElementContext(GraphicElement var1);

    public Graph getGraph() {
        return this.graph;
    }

    public Camera getCamera() {
        return this.graphView.getCamera();
    }

    public JComponent getView() {
        return this.view;
    }

    protected JComponent initView() {
        C consoleManager = this.getConsoleManager();
        if (consoleManager != null) {
            JSplitPane splitPane = new JSplitPane(1, (Component)this.graphView, ((AbstractConsoleManager)consoleManager).getConsolePane());
            splitPane.setOneTouchExpandable(true);
            splitPane.setResizeWeight(0.7);
            return splitPane;
        }
        return this.graphView;
    }

    private Graph initGraph() {
        SingleGraph graph = new SingleGraph("0");
        graph.setAttribute("ui.stylesheet", new Object[]{"node {size: 20px;z-index: 1;stroke-mode: plain; stroke-width: 2px;text-size: 20px;text-alignment: under;text-color: black;text-style: bold;text-background-mode: rounded-box;text-background-color: rgba(100, 100, 100, 100); text-padding: 2px;text-offset: 0px, 8px;} node:selected {stroke-color: red; stroke-width: 4px;} edge {size: 2px;shape: cubic-curve;z-index: 0;arrow-size: 9px, 6px;text-size: 20px;text-alignment: under;text-color: black;text-style: bold;text-background-mode: rounded-box;text-background-color: rgba(100, 100, 100, 100); text-padding: 2px;text-offset: 0px, 2px;} edge:selected {stroke-mode: plain; fill-color: red;stroke-width: 3px;}"});
        graph.setAttribute("ui.antialias", new Object[0]);
        graph.setAutoCreate(true);
        return graph;
    }

    protected void initModifiers() {
        Templates t = this.model.getTemplates();
        this.neuronTypeModifiers.put(BindingNeuron.class, n -> n.setAttribute("ui.style", new Object[]{"fill-color: rgb(0,205,0);"}));
        this.synapseTypeModifiers.put(t.PRIMARY_INPUT_SYNAPSE_FROM_PATTERN_TEMPLATE.getTemplateSynapseId(), "fill-color: rgb(0,150,00);");
        this.synapseTypeModifiers.put(t.PRIMARY_INPUT_SYNAPSE_FROM_CATEGORY_TEMPLATE.getTemplateSynapseId(), "fill-color: rgb(0,150,00);");
        this.synapseTypeModifiers.put(t.RELATED_INPUT_SYNAPSE_TEMPLATE.getTemplateSynapseId(), "fill-color: rgb(50,230,50);");
        this.synapseTypeModifiers.put(t.NEGATIVE_FEEDBACK_SYNAPSE_TEMPLATE.getTemplateSynapseId(), "fill-color: rgb(185,0,0);");
        this.synapseTypeModifiers.put(t.SAME_PATTERN_SYNAPSE_TEMPLATE.getTemplateSynapseId(), "fill-color: rgb(50,200,120);");
        this.synapseTypeModifiers.put(t.POSITIVE_FEEDBACK_SYNAPSE_TEMPLATE.getTemplateSynapseId(), "fill-color: rgb(120,200,50); ");
        this.neuronTypeModifiers.put(InhibitoryNeuron.class, n -> n.setAttribute("ui.style", new Object[]{"fill-color: rgb(100,100,255);"}));
        this.synapseTypeModifiers.put(t.INHIBITORY_SYNAPSE_TEMPLATE.getTemplateSynapseId(), "fill-color: rgb(100,100,255);");
        this.neuronTypeModifiers.put(CategoryNeuron.class, n -> n.setAttribute("ui.style", new Object[]{"fill-color: rgb(100,0,200);"}));
        this.synapseTypeModifiers.put(t.CATEGORY_SYNAPSE_TEMPLATE.getTemplateSynapseId(), "fill-color: rgb(100,0,200);");
        this.neuronTypeModifiers.put(PatternNeuron.class, n -> n.setAttribute("ui.style", new Object[]{"fill-color: rgb(224, 34, 245);"}));
        this.synapseTypeModifiers.put(t.PATTERN_SYNAPSE_TEMPLATE.getTemplateSynapseId(), "fill-color: rgb(224, 34, 245);");
    }

    public void applyEdgeStyle(Synapse s, Edge edge) {
        Object synapseTypeModifier = this.synapseTypeModifiers.get(s.getTemplateSynapseId());
        if (synapseTypeModifier == null) {
            synapseTypeModifier = "";
        }
        if (s.isRecurrent()) {
            synapseTypeModifier = (String)synapseTypeModifier + " arrow-shape: diamond;";
        }
        edge.setAttribute("ui.style", new Object[]{synapseTypeModifier});
        if (s.isTemplate()) {
            this.addTemplateAttributes((Element)edge);
        }
    }

    public void pump() {
        this.fromViewer.pump();
    }

    public void unhighlightElement(Element ge) {
        if (!this.highlightEnabled) {
            return;
        }
        ge.removeAttribute("ui.selected");
        this.fromViewer.pump();
    }

    public void highlightElement(Element ge) {
        if (!this.highlightEnabled) {
            return;
        }
        ge.setAttribute("ui.selected", new Object[0]);
        this.fromViewer.pump();
    }

    public void viewClosed(String id) {
    }

    public abstract void dumpNetworkCoordinates();
}

