/*
 * Decompiled with CFR 0.152.
 */
package network.aika.debugger;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import network.aika.debugger.AIKADebugManager;
import network.aika.debugger.activations.ActivationConsoleManager;
import network.aika.debugger.stepmanager.StepManager;
import network.aika.debugger.stepmanager.StepMode;

public class KeyManager
implements KeyListener {
    AIKADebugManager debugManager;

    public KeyManager(AIKADebugManager debugManager) {
        this.debugManager = debugManager;
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        StepManager sm = this.debugManager.getActivationViewManager().getStepManager();
        char c = e.getKeyChar();
        if (c == 'm') {
            System.out.println("Metric: " + this.debugManager.getActivationViewManager().getCamera().getMetrics());
            return;
        }
        if (c == 'e') {
            sm.setStopAfterProcessed(true);
        } else if (c == 'r') {
            sm.setMode(null);
            sm.resetTimestamp();
        } else if (c == 'a') {
            sm.setMode(StepMode.ACT);
        } else if (c == 'l') {
            sm.setMode(StepMode.LINK);
        } else if (c == 'v') {
            ActivationConsoleManager consoleManager = (ActivationConsoleManager)this.debugManager.getActivationViewManager().getConsoleManager();
            if (consoleManager != null) {
                consoleManager.getActivationViewTabbedPane().setSelectedIndex(2);
            }
            sm.setMode(StepMode.VISITOR);
        } else {
            if (c == 'd') {
                this.debugManager.getActivationViewManager().setDebugMode(true);
                return;
            }
            if (c == 's') {
                this.debugManager.getActivationViewManager().setScopeMode(true);
                return;
            }
        }
        sm.click();
    }

    @Override
    public void keyReleased(KeyEvent e) {
        char c = e.getKeyChar();
        if (c == 'd') {
            this.debugManager.getActivationViewManager().setDebugMode(false);
            return;
        }
        if (c == 's') {
            this.debugManager.getActivationViewManager().setScopeMode(false);
            return;
        }
        if (c == 'o') {
            this.debugManager.getActivationViewManager().dumpNetworkCoordinates();
            this.debugManager.getNeuronViewManager().dumpNetworkCoordinates();
        }
    }
}

