/*
 * Decompiled with CFR 0.152.
 */
package network.aika.debugger.activations;

import java.awt.Component;
import java.util.stream.Collectors;
import javax.swing.JSplitPane;
import javax.swing.text.StyledDocument;
import network.aika.debugger.AbstractConsole;
import network.aika.debugger.activations.ActivationConsoleManager;
import network.aika.debugger.activations.ElementQueueConsole;
import network.aika.debugger.neurons.NeuronConsole;
import network.aika.neuron.activation.Activation;
import network.aika.neuron.activation.BindingActivation;
import network.aika.neuron.activation.Element;
import network.aika.neuron.activation.Link;
import network.aika.sign.Sign;
import network.aika.steps.Step;

public class ActivationConsole
extends AbstractConsole {
    private NeuronConsole neuronConsole;
    private ElementQueueConsole elementQueueConsole;
    private JSplitPane horizontalSplitPane;
    private JSplitPane verticalSplitPane;

    public Component getSplitPane() {
        this.neuronConsole = new NeuronConsole();
        this.horizontalSplitPane = new JSplitPane(1, this, this.neuronConsole);
        this.horizontalSplitPane.setResizeWeight(0.5);
        this.horizontalSplitPane.setDividerLocation(0.5);
        this.elementQueueConsole = new ElementQueueConsole();
        this.verticalSplitPane = new JSplitPane(0, ActivationConsoleManager.getScrollPane(this.elementQueueConsole), ActivationConsoleManager.getScrollPane(this.horizontalSplitPane));
        this.verticalSplitPane.setResizeWeight(0.3);
        this.verticalSplitPane.setDividerLocation(0.3);
        return this.verticalSplitPane;
    }

    public void renderElementConsoleOutput(StyledDocument sDoc, Element e, Step s, String event) {
        if (e instanceof Activation) {
            this.renderActivationConsoleOutput(sDoc, (Activation)e, s, event);
        } else if (e instanceof Link) {
            this.renderLinkConsoleOutput(sDoc, (Link)e, s, event);
        }
    }

    public void renderActivationConsoleOutput(StyledDocument sDoc, Activation act, Step s, String event) {
        BindingActivation bAct;
        ActivationConsole.appendText(sDoc, (act.isTemplate() ? "Template " : "") + act.getClass().getSimpleName() + " \n", "headline");
        this.appendEntry(sDoc, "Id: ", "" + act.getId());
        this.appendEntry(sDoc, "Label: ", act.getLabel());
        if (act.isInput()) {
            this.appendEntry(sDoc, "IsInput: ", "" + act.isInput());
        }
        this.appendEntry(sDoc, act.getValue().getLabel() + ": ", "" + act.getValue());
        this.appendEntry(sDoc, act.getNet().getLabel() + ": ", "" + act.getNet());
        this.appendEntry(sDoc, "f(net)': ", "" + act.getNetOuterGradient());
        if (act.getEntropy() != null) {
            this.appendEntry(sDoc, act.getEntropy().getLabel() + ": ", "" + act.getEntropy());
        }
        if (act.getInputGradient() != null) {
            this.appendEntry(sDoc, act.getInputGradient().getLabel() + ": ", "" + act.getInputGradient());
        }
        if (act instanceof BindingActivation && (bAct = (BindingActivation)act).getOwnInputGradient() != null) {
            this.appendEntry(sDoc, bAct.getOwnInputGradient().getLabel() + ": ", "" + bAct.getOwnInputGradient());
        }
        if (act.getOutputGradient() != null) {
            this.appendEntry(sDoc, act.getOutputGradient().getLabel() + ": ", "" + act.getOutputGradient());
        }
        if (act instanceof BindingActivation && (bAct = (BindingActivation)act).getOwnOutputGradient() != null) {
            this.appendEntry(sDoc, bAct.getOwnOutputGradient().getLabel() + ": ", "" + bAct.getOwnOutputGradient());
        }
        this.appendEntry(sDoc, "CreationTS: ", "" + act.getCreationTimestamp());
        this.appendEntry(sDoc, "FiredTS: ", "" + act.getFired());
        if (act instanceof BindingActivation) {
            bAct = (BindingActivation)act;
            this.appendEntry(sDoc, "FinalTS: ", "" + bAct.getFinalTimestamp());
            this.appendEntry(sDoc, "Bound: ", (String)(bAct.isBound() ? "" + bAct.getBoundPatternBindingSignal() : "--"));
            this.renderBranches(sDoc, bAct);
        }
        this.renderBindingSignals(sDoc, act);
        this.neuronConsole.render(nsDoc -> this.neuronConsole.renderNeuronConsoleOutput((StyledDocument)nsDoc, act.getNeuron(), act));
        this.elementQueueConsole.render(eqsDoc -> this.elementQueueConsole.renderElementQueueOutput((StyledDocument)eqsDoc, (Element)act, s, event));
    }

    private void renderBindingSignals(StyledDocument sDoc, Activation<?> act) {
        this.appendEntry(sDoc, "Binding-Signals: ", "\n" + act.getBindingSignals().map(bs -> "  " + bs.getClass().getSimpleName() + " " + bs).collect(Collectors.joining("\n")));
    }

    private void renderBranches(StyledDocument sDoc, BindingActivation bAct) {
        this.appendEntry(sDoc, bAct.getBranchProbability().getLabel() + ": ", "" + bAct.getBranchProbability());
        this.appendEntry(sDoc, bAct.getBpNorm().getLabel() + ": ", "" + bAct.getBpNorm());
        this.appendEntry(sDoc, "Main-Branch: ", this.getShortString((Activation)bAct.getMainBranch()));
        bAct.getBranches().forEach(branchAct -> this.appendEntry(sDoc, "Branch: ", "" + branchAct));
    }

    public void renderLinkConsoleOutput(StyledDocument sDoc, Link l, Step s, String event) {
        ActivationConsole.appendText(sDoc, (l.getSynapse().isTemplate() ? "Template " : "") + l.getClass().getSimpleName() + "\n", "headline");
        Activation oAct = l.getOutput();
        this.appendEntry(sDoc, "Input: ", this.getShortString(l.getInput()));
        this.appendEntry(sDoc, "Input-Value: ", "" + l.getInputValue((Sign)Sign.POS));
        this.appendEntry(sDoc, "Output: ", this.getShortString(l.getOutput()));
        this.appendEntry(sDoc, "Output-" + oAct.getValue().getLabel() + ": ", "" + oAct.getValue());
        this.appendEntry(sDoc, "Output-" + oAct.getNet().getLabel() + ": ", "" + oAct.getNet());
        this.appendEntry(sDoc, "Weighted-Input: ", "" + l.getWeightedInput());
        this.appendEntry(sDoc, "Is-Self-Referencing: ", "" + l.isSelfRef());
        this.appendEntry(sDoc, "f(net)': ", "" + oAct.getNetOuterGradient());
        if (l.getInformationGainGradient() != null) {
            this.appendEntry(sDoc, l.getInformationGainGradient().getLabel() + ": ", "" + l.getInformationGainGradient());
        }
        this.appendEntry(sDoc, "Back-Prop-Gradient: ", "" + l.getBackPropGradient());
        ActivationConsole.appendText(sDoc, "\n", "regular");
        this.neuronConsole.render(nsDoc -> this.neuronConsole.renderSynapseConsoleOutput((StyledDocument)nsDoc, l.getSynapse(), l));
        this.elementQueueConsole.render(eqsDoc -> this.elementQueueConsole.renderElementQueueOutput((StyledDocument)eqsDoc, (Element)l, s, event));
    }

    private String getShortString(Activation act) {
        return act != null ? act.toString() : NOT_SET_STR;
    }
}

