/*
 * Decompiled with CFR 0.152.
 */
package network.aika.debugger.activations;

import java.util.OptionalDouble;
import network.aika.debugger.AbstractGraphManager;
import network.aika.debugger.AbstractLayout;
import network.aika.debugger.AbstractParticle;
import network.aika.debugger.activations.ActivationViewManager;
import network.aika.direction.Direction;
import network.aika.neuron.Synapse;
import network.aika.neuron.activation.Activation;
import network.aika.neuron.activation.Link;
import network.aika.neuron.activation.Timestamp;
import network.aika.neuron.conjunctive.SamePatternSynapse;
import network.aika.neuron.disjunctive.InhibitoryNeuron;
import network.aika.text.TextModel;
import org.graphstream.graph.Node;
import org.graphstream.ui.geom.Vector2;
import org.graphstream.ui.geom.Vector3;
import org.graphstream.ui.layout.springbox.EdgeSpring;
import org.graphstream.ui.layout.springbox.Energies;
import org.graphstream.ui.layout.springbox.NodeParticle;
import org.graphstream.ui.layout.springbox.implementations.SpringBox;
import org.miv.pherd.geom.Point3;

public class ActivationParticle
extends AbstractParticle {
    public static double K1 = 0.12f;
    public static double K2 = 0.03f;
    Activation<?> act;
    Node node;
    private Double targetX;
    private Double targetY;

    public ActivationParticle(AbstractLayout layout, Node node, Activation act, String id, double x, double y, double z) {
        super(layout, id, x, y, z);
        this.act = act;
        this.node = node;
    }

    public void setTargetOnActivationCreation(Activation act, Synapse originSynapse, Activation originAct) {
    }

    public OptionalDouble computePatternActivationTargetXPosition() {
        return this.act.getInputLinks().map(l -> l.getInput()).map(iAct -> ((AbstractGraphManager)this.layout.getGraphManager()).getParticle((Activation)iAct)).mapToDouble(p -> p.getPosition().x).average();
    }

    public static Point3 computeInitialActivationPosition(Activation act, String originSynapseType, Activation originAct, Point3 originPos) {
        boolean isBranchActivation = ActivationViewManager.isBranchActivation(act, originAct);
        double x = originPos.x;
        double y = originPos.y + ActivationParticle.getInitialYOffset(originSynapseType, isBranchActivation);
        if (act.getNeuron().isNetworkInput() && originAct != null && originAct.getFired() != Timestamp.NOT_SET) {
            double offset = AbstractLayout.STANDARD_DISTANCE_X * 0.3;
            if (act.getLabel().endsWith(TextModel.REL_NEXT_TOKEN_LABEL)) {
                x += offset;
            } else if (act.getLabel().endsWith(TextModel.REL_PREVIOUS_TOKEN_LABEL)) {
                x -= offset;
            }
        }
        return new Point3(x, y, 0.0);
    }

    public Double getTargetX() {
        return this.targetX;
    }

    public void setTargetX(Double targetX) {
        this.targetX = targetX;
    }

    public Double getTargetY() {
        return this.targetY;
    }

    public void setTargetY(Double targetY) {
        this.targetY = targetY;
    }

    protected void attraction(Vector3 delta) {
        SpringBox box = (SpringBox)this.box;
        Energies energies = box.getEnergies();
        this.computeTargetAttraction(delta, energies);
        this.computeEdgeAttraction(delta, energies);
    }

    private void computeTargetAttraction(Vector3 delta, Energies energies) {
        if (this.targetX != null || this.targetY != null) {
            delta.set(this.targetX != null ? this.targetX - this.pos.x : 0.0, this.targetY != null ? this.targetY - this.pos.y : 0.0, 0.0);
            this.disp.add(delta);
            this.attE += K1;
            energies.accumulateEnergy(K1);
        }
    }

    private void computeEdgeAttraction(Vector3 delta, Energies energies) {
        for (EdgeSpring edge : this.neighbours) {
            Direction dir;
            if (edge.ignored) continue;
            ActivationParticle other = (ActivationParticle)edge.getOpposite((NodeParticle)this);
            Link link = this.getLink(other.act, this.act);
            if (link == null) continue;
            Direction direction = dir = this.act == link.getOutput() ? Direction.INPUT : Direction.OUTPUT;
            if (dir == Direction.OUTPUT) {
                return;
            }
            this.processSynapseType(delta, link.getSynapse(), dir, other);
            delta.mult(new Vector2(0.0, K1));
            this.disp.add(delta);
            this.attE += K1;
            energies.accumulateEnergy(K1);
        }
    }

    private void processSynapseType(Vector3 delta, Synapse s, Direction dir, ActivationParticle other) {
        if (s.isRecurrent() && !s.getOutput().isNetworkInput()) {
            return;
        }
        if (s instanceof SamePatternSynapse) {
            return;
        }
        if (s.getOutput().isNetworkInput() && s.getInput() instanceof InhibitoryNeuron) {
            return;
        }
        this.calculateForce(delta, dir, ActivationParticle.getInitialYOffset(s.getClass().getSimpleName(), false), other);
    }

    private void calculateForce(Vector3 delta, Direction dir, double targetDistance, ActivationParticle other) {
        Point3 opos = other.getPosition();
        double dy = 0.0;
        if (dir == Direction.INPUT) {
            dy = opos.y + targetDistance - this.pos.y;
            dy = Math.max(0.0, dy);
        } else if (dir == Direction.OUTPUT) {
            dy = opos.y - (this.pos.y + targetDistance);
            dy = Math.min(0.0, dy);
        }
        delta.set(0.0, dy, 0.0);
    }

    public static double getInitialYOffset(String originSynapseType, boolean isBranchActivation) {
        if (isBranchActivation) {
            return 0.0;
        }
        if ("PrimaryBNSynapse".equalsIgnoreCase(originSynapseType)) {
            return AbstractLayout.STANDARD_DISTANCE_Y * 2.0;
        }
        if ("InhibitorySynapse".equalsIgnoreCase(originSynapseType)) {
            return AbstractLayout.STANDARD_DISTANCE_Y / 2.0;
        }
        return AbstractLayout.STANDARD_DISTANCE_Y;
    }

    private Link getLink(Activation actA, Activation actB) {
        Link l = this.getDirectedLink(actA, actB);
        if (l != null) {
            return l;
        }
        return this.getDirectedLink(actB, actA);
    }

    private Link getDirectedLink(Activation iAct, Activation<?> oAct) {
        return oAct.getInputLinks().filter(l -> l.getInput() == iAct).findFirst().orElse(null);
    }
}

