/*
 * Decompiled with CFR 0.152.
 */
package network.aika.debugger.activations;

import java.util.function.Consumer;
import network.aika.Thought;
import network.aika.callbacks.EventListener;
import network.aika.debugger.AbstractLayout;
import network.aika.debugger.AbstractViewManager;
import network.aika.debugger.activations.ActivationConsoleManager;
import network.aika.debugger.activations.ActivationGraphManager;
import network.aika.debugger.activations.ActivationLayout;
import network.aika.debugger.activations.ActivationParticle;
import network.aika.debugger.stepmanager.StepManager;
import network.aika.debugger.stepmanager.StepMode;
import network.aika.neuron.Synapse;
import network.aika.neuron.activation.Activation;
import network.aika.neuron.activation.BindingActivation;
import network.aika.neuron.activation.DummyActivation;
import network.aika.neuron.activation.Link;
import network.aika.steps.Step;
import network.aika.text.Document;
import network.aika.text.TokenActivation;
import network.aika.utils.Utils;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Element;
import org.graphstream.graph.Node;
import org.graphstream.ui.graphicGraph.GraphicElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivationViewManager
extends AbstractViewManager<Activation, ActivationConsoleManager, ActivationGraphManager>
implements EventListener {
    private static final Logger log = LoggerFactory.getLogger(ActivationViewManager.class);
    private Document doc;
    protected StepManager stepManager;
    private Double lastInputActXPos = null;
    private Activation lastInputAct = null;

    public ActivationViewManager(Document doc, ActivationConsoleManager consoleManager) {
        super(doc.getModel(), consoleManager);
        double width = 5.0 * AbstractLayout.STANDARD_DISTANCE_X;
        double height = 3.0 * AbstractLayout.STANDARD_DISTANCE_Y;
        this.getCamera().setGraphViewport(-(width / 2.0), -(height / 2.0), width / 2.0, height / 2.0);
        this.getCamera().setViewCenter(0.2, 0.2, 0.0);
        this.graphManager = new ActivationGraphManager(this.graph, (Thought)doc);
        this.doc = doc;
        doc.addEventListener((EventListener)this);
        this.layout = new ActivationLayout(this, (ActivationGraphManager)this.graphManager);
        this.view = this.initView();
    }

    public StepManager getStepManager() {
        return this.stepManager;
    }

    public void setStepManager(StepManager stepManager) {
        this.stepManager = stepManager;
    }

    public void pumpAndWaitForUserAction() {
        this.pump();
        this.stepManager.waitForClick();
    }

    @Override
    public void showElementContext(GraphicElement ge) {
        if (ge instanceof Node) {
            Node n = (Node)ge;
            Activation act = (Activation)((ActivationGraphManager)this.graphManager).getAikaNode(n);
            if (act == null) {
                return;
            }
            ((ActivationConsoleManager)this.getConsoleManager()).showSelectedElementContext(act);
        } else if (ge instanceof Edge) {
            Edge e = (Edge)ge;
            Link l = ((ActivationGraphManager)this.graphManager).getLink(e);
            if (l == null) {
                return;
            }
            ((ActivationConsoleManager)this.getConsoleManager()).showSelectedElementContext(l);
        }
    }

    public void onActivationCreationEvent(Activation act, Synapse originSynapse, Activation originAct) {
        if (act instanceof DummyActivation) {
            this.handleDummyActivation();
            return;
        }
        Node node = ((ActivationGraphManager)this.graphManager).lookupNode(act, n -> this.initActivationNode(act, originSynapse, originAct, (Node)n));
        this.onActivationEvent(node, act);
        ActivationParticle ap = (ActivationParticle)((Object)((ActivationGraphManager)this.graphManager).getParticle(act));
        if (ap != null) {
            ap.setTargetOnActivationCreation(act, originSynapse, originAct);
        }
        if (!this.stepManager.stopHere(StepManager.When.NEW, StepMode.ACT)) {
            return;
        }
        node.setAttribute("aika.init-node", new Object[]{true});
        this.pumpAndWaitForUserAction();
    }

    public void beforeProcessedEvent(Step s) {
        if (s.getElement() instanceof Activation) {
            this.beforeActivationProcessedEvent(s, (Activation)s.getElement());
        } else if (s.getElement() instanceof Link) {
            this.beforeLinkProcessedEvent(s, (Link)s.getElement());
        }
    }

    public void afterProcessedEvent(Step s) {
        if (s.getElement() instanceof Activation) {
            this.afterActivationProcessedEvent(s, (Activation)s.getElement());
        } else if (s.getElement() instanceof Link) {
            this.afterLinkProcessedEvent(s, (Link)s.getElement());
        }
        Thought t = s.getElement().getThought();
        if (t.getQueue().isEmpty()) {
            this.afterDocumentProcessedEvent(t);
        }
    }

    private void beforeActivationProcessedEvent(Step s, Activation act) {
        if (act instanceof DummyActivation) {
            this.handleDummyActivation();
            return;
        }
        Node node = ((ActivationGraphManager)this.graphManager).getNode(act);
        if (node == null) {
            return;
        }
        this.onActivationEvent(node, act);
        node.setAttribute("aika.init-node", new Object[]{false});
        if (!this.stepManager.stopHere(StepManager.When.BEFORE, StepMode.ACT)) {
            return;
        }
        this.pumpAndWaitForUserAction();
    }

    private void handleDummyActivation() {
        if (!this.stepManager.stopHere(StepManager.When.NEW, StepMode.ACT)) {
            return;
        }
        this.pumpAndWaitForUserAction();
    }

    private void afterDocumentProcessedEvent(Thought t) {
        if (!this.stepManager.stopHere(StepManager.When.AFTER, StepMode.DOCUMENT)) {
            return;
        }
        this.pumpAndWaitForUserAction();
    }

    private void afterActivationProcessedEvent(Step s, Activation act) {
        if (act instanceof DummyActivation) {
            this.handleDummyActivation();
            return;
        }
        Node node = ((ActivationGraphManager)this.graphManager).getNode(act);
        if (node == null) {
            return;
        }
        this.onActivationEvent(node, act);
        if (!this.stepManager.stopHere(StepManager.When.AFTER, StepMode.ACT)) {
            return;
        }
        this.pumpAndWaitForUserAction();
    }

    private void onActivationEvent(Node node, Activation act) {
        node.setAttribute("ui.label", new Object[]{act.getLabel()});
        node.setAttribute("ui.style", new Object[]{this.getActivationStrokeColor(act)});
        if (act.isTemplate()) {
            this.addTemplateAttributes((Element)node);
        }
        this.highlightCurrentOnly((Element)node);
        Consumer neuronTypeModifier = (Consumer)this.neuronTypeModifiers.get(act.getNeuron().getClass());
        if (neuronTypeModifier != null) {
            neuronTypeModifier.accept(node);
        }
    }

    private String getActivationStrokeColor(Activation act) {
        if (act.isFired()) {
            BindingActivation bAct;
            if (act instanceof BindingActivation && !(bAct = (BindingActivation)act).isBound()) {
                return "stroke-color: rgb(100, 100, 100);";
            }
            return "stroke-color: black;";
        }
        return "stroke-color: rgb(200, 200, 200);";
    }

    public static boolean isBranchActivation(Activation act, Activation originAct) {
        if (act instanceof BindingActivation) {
            BindingActivation bAct = (BindingActivation)act;
            return bAct.getMainBranch() == originAct;
        }
        return false;
    }

    private void initActivationNode(Activation act, Synapse originSynapse, Activation originAct, Node n) {
        double[] coords;
        n.setAttribute("aika.id", new Object[]{act.getId()});
        if (originSynapse != null) {
            n.setAttribute("aika.originSynapseType", new Object[]{originSynapse.getClass().getSimpleName()});
        }
        if (originAct != null) {
            n.setAttribute("aika.originActId", new Object[]{originAct.getId()});
        }
        if (originAct != null) {
            Edge initialEdge = ((ActivationGraphManager)this.graphManager).lookupEdge(originAct, act);
            if (ActivationViewManager.isBranchActivation(act, originAct)) {
                initialEdge.setAttribute("ui.style", new Object[]{"fill-color: rgb(255,126,0); stroke-mode:dashes;"});
            } else {
                initialEdge.setAttribute("ui.style", new Object[]{"fill-color: rgb(200,200,200);"});
            }
        }
        this.freezeInputActivations(act, n);
        if (this.getCoordinateListener() != null && (coords = this.getCoordinateListener().getCoordinate(act)) != null) {
            n.setAttribute("x", new Object[]{coords[0]});
            n.setAttribute("y", new Object[]{coords[1]});
            return;
        }
        if (act.getNeuron().isNetworkInput() && originAct == null) {
            Double x = this.getActivationXCoordinate(this.lastInputAct);
            if (x == null) {
                x = this.lastInputActXPos;
            }
            x = x != null ? Double.valueOf(x + AbstractLayout.STANDARD_DISTANCE_X) : Double.valueOf(0.0);
            n.setAttribute("x", new Object[]{x});
            this.lastInputActXPos = x;
            this.lastInputAct = act;
        }
    }

    private void freezeInputActivations(Activation act, Node n) {
        if (act instanceof TokenActivation) {
            n.setAttribute("layout.frozen", new Object[0]);
        }
    }

    private Double getActivationXCoordinate(Activation act) {
        if (act == null) {
            return null;
        }
        ActivationParticle originParticle = (ActivationParticle)((Object)((ActivationGraphManager)this.graphManager).getParticle(act.getId()));
        if (originParticle == null) {
            return null;
        }
        return originParticle.getPosition().x;
    }

    private void highlightCurrentOnly(Element e) {
        if (this.lastHighlighted != e && this.lastHighlighted != null) {
            this.unhighlightElement(this.lastHighlighted);
        }
    }

    public void onLinkCreationEvent(Link l) {
        Edge e = this.onLinkEvent(l);
        if (e == null) {
            return;
        }
        e.setAttribute("aika.init-node", new Object[]{true});
        ActivationParticle ap = (ActivationParticle)((Object)((ActivationGraphManager)this.graphManager).getParticle(l.getOutput()));
        if (ap != null) {
            ap.setTargetOnActivationCreation(l.getOutput(), l.getSynapse(), l.getInput());
        }
        if (!this.stepManager.stopHere(StepManager.When.NEW, StepMode.LINK)) {
            return;
        }
        this.pumpAndWaitForUserAction();
    }

    private void beforeLinkProcessedEvent(Step s, Link l) {
        Edge e = this.onLinkEvent(l);
        if (e == null) {
            return;
        }
        e.setAttribute("aika.init-node", new Object[]{false});
        if (!this.stepManager.stopHere(StepManager.When.BEFORE, StepMode.LINK)) {
            return;
        }
        this.pumpAndWaitForUserAction();
    }

    private void afterLinkProcessedEvent(Step s, Link l) {
        if (!this.stepManager.stopHere(StepManager.When.AFTER, StepMode.LINK)) {
            return;
        }
        this.pumpAndWaitForUserAction();
    }

    private Edge onLinkEvent(Link l) {
        if (l.getInput() == null || l.getOutput() == null) {
            return null;
        }
        Edge edge = ((ActivationGraphManager)this.graphManager).lookupEdge(l);
        this.highlightCurrentOnly((Element)edge);
        this.applyEdgeStyle(l.getSynapse(), edge);
        return edge;
    }

    @Override
    public void viewClosed(String id) {
    }

    public Document getDocument() {
        return this.doc;
    }

    @Override
    public void dumpNetworkCoordinates() {
        System.out.println("Activations: ");
        System.out.println("camera.setViewPercent(" + Utils.round((double)this.getCamera().getViewPercent()) + ");");
        System.out.println("camera.setViewCenter(" + Utils.round((double)this.getCamera().getViewCenter().x) + ", " + Utils.round((double)this.getCamera().getViewCenter().y) + ", 0);");
        this.doc.getActivations().forEach(act -> {
            ActivationParticle p = (ActivationParticle)((Object)((Object)((ActivationGraphManager)this.graphManager).getParticle(act)));
            System.out.println("coords.put(" + act.getId() + ", new double[]{" + Utils.round((double)p.getPosition().x) + ", " + Utils.round((double)p.getPosition().y) + "});");
        });
    }
}

