/*
 * Decompiled with CFR 0.152.
 */
package network.aika.debugger.activations;

import javax.swing.text.StyledDocument;
import network.aika.Thought;
import network.aika.debugger.AbstractConsole;
import network.aika.neuron.activation.Timestamp;
import network.aika.steps.Step;

public class QueueConsole
extends AbstractConsole {
    public void renderQueue(StyledDocument sDoc, Thought<?> t, Step currentQE) {
        if (currentQE != null) {
            QueueConsole.renderQueueEntry(sDoc, t, currentQE);
        }
        QueueConsole.appendText(sDoc, "---------------------------------------------------------------------------------------------------------------------------------------------------------------------\n", "regular");
        for (Step s : t.getQueue()) {
            QueueConsole.renderQueueEntry(sDoc, t, s);
        }
        QueueConsole.appendText(sDoc, "\n\n\n", "regular");
    }

    public static void renderQueueEntry(StyledDocument sDoc, Thought<?> t, Step s) {
        Timestamp currentTimestamp = t.getTimestampOnProcess();
        String regularColor = "regular";
        String boldColor = "bold";
        if (currentTimestamp.compareTo(s.getTimestamp()) <= 0) {
            regularColor = "regularGreen";
            boldColor = "boldGreen";
        }
        QueueConsole.appendEntry(sDoc, QueueConsole.getQueueEntrySortKeyDescription(s), s.toString(), boldColor, regularColor);
    }

    public static String getQueueEntrySortKeyDescription(Step s) {
        return s.getPhase().name() + " " + (String)(s.getFired() != Timestamp.NOT_SET ? "Fired:" + s.getFired() : "Pre-Fired") + " TS:" + s.getTimestamp() + " " + s.getStepName() + " ";
    }
}

