/*
 * Decompiled with CFR 0.152.
 */
package network.aika.debugger.neurons;

import javax.swing.text.StyledDocument;
import network.aika.debugger.AbstractConsole;
import network.aika.neuron.Neuron;
import network.aika.neuron.Range;
import network.aika.neuron.Synapse;
import network.aika.neuron.activation.Activation;
import network.aika.neuron.activation.Link;
import network.aika.neuron.conjunctive.PositiveFeedbackSynapse;
import network.aika.neuron.conjunctive.SamePatternSynapse;
import network.aika.sign.Sign;
import network.aika.utils.Utils;

public class NeuronConsole
extends AbstractConsole {
    public void renderNeuronConsoleOutput(StyledDocument sDoc, Neuron n, Activation ref) {
        NeuronConsole.appendText(sDoc, (n.isTemplate() ? "Template " : "") + n.getClass().getSimpleName() + "\n", "headline");
        this.appendEntry(sDoc, "Id: ", "" + n.getId());
        this.appendEntry(sDoc, "Label: ", n.getLabel());
        if (n.isNetworkInput()) {
            this.appendEntry(sDoc, "Is Network Input Neuron: ", "" + n.isNetworkInput());
        }
        this.appendEntry(sDoc, "Bias: ", "" + n.getBias());
        Range range = !n.isTemplate() && ref != null ? ref.getAbsoluteRange() : null;
        this.appendEntry(sDoc, "Range: ", (String)(range != null ? "" + range : NOT_SET_STR));
        this.appendEntry(sDoc, "Frequency: ", "" + Utils.round((double)n.getFrequency()));
        try {
            this.appendEntry(sDoc, "N: ", "" + Utils.round((double)n.getSampleSpace().getN(range)));
        }
        catch (IllegalStateException e) {
            this.appendEntry(sDoc, "N: ", NOT_SET_STR);
        }
        this.appendEntry(sDoc, "SampleSpace: ", "" + n.getSampleSpace());
        this.appendEntry(sDoc, "P(POS): ", this.probabilityToString((Sign)Sign.POS, n, range));
        this.appendEntry(sDoc, "P(NEG): ", this.probabilityToString((Sign)Sign.NEG, n, range));
        this.appendEntry(sDoc, "Surprisal(POS): ", this.surprisalToString((Sign)Sign.POS, n, range));
        this.appendEntry(sDoc, "Surprisal(NEG): ", this.surprisalToString((Sign)Sign.NEG, n, range));
        this.appendEntry(sDoc, "Template Neuron: ", this.templatesToString(n));
    }

    private String templatesToString(Neuron<?, ?> n) {
        StringBuilder sb = new StringBuilder();
        n.getTemplateGroup().forEach(tn -> sb.append(tn.getId() + ":" + tn.getLabel() + ", "));
        return sb.toString();
    }

    public void renderSynapseConsoleOutput(StyledDocument sDoc, Synapse s, Link ref) {
        NeuronConsole.appendText(sDoc, (s.isTemplate() ? "Template " : "") + s.getClass().getSimpleName() + "\n", "headline");
        this.appendEntry(sDoc, "Weight: ", "" + s.getWeight());
        this.appendEntry(sDoc, "Propagate: ", "" + s.allowPropagate(null));
        this.appendEntry(sDoc, "Input: ", s.getInput().toString() + (s.isInputLinked() ? " (linked)" : ""));
        this.appendEntry(sDoc, "Output: ", s.getOutput().toString() + (s.isOutputLinked() ? " (linked)" : ""));
        if (s instanceof SamePatternSynapse) {
            this.appendEntry(sDoc, "Loose Binding:", "" + s.allowLooseLinking());
        }
        if (s instanceof PositiveFeedbackSynapse) {
            PositiveFeedbackSynapse pfs = (PositiveFeedbackSynapse)s;
            this.appendEntry(sDoc, "Feedback Bias:", "" + pfs.getFeedbackBias());
            this.appendEntry(sDoc, "Feedback Weight:", "" + pfs.getFeedbackWeight());
        }
        Range range = !s.isTemplate() && ref != null && ref.getInput() != null ? ref.getInput().getAbsoluteRange() : null;
        this.appendEntry(sDoc, "Range: ", (String)(range != null ? "" + range : NOT_SET_STR));
        this.appendEntry(sDoc, "Frequency(POS, POS): ", this.frequencyToString((Sign)Sign.POS, (Sign)Sign.POS, s, range));
        this.appendEntry(sDoc, "Frequency(POS, NEG): ", this.frequencyToString((Sign)Sign.POS, (Sign)Sign.NEG, s, range));
        this.appendEntry(sDoc, "Frequency(NEG, POS): ", this.frequencyToString((Sign)Sign.NEG, (Sign)Sign.POS, s, range));
        this.appendEntry(sDoc, "Frequency(NEG, NEG): ", this.frequencyToString((Sign)Sign.NEG, (Sign)Sign.NEG, s, range));
        try {
            this.appendEntry(sDoc, "N: ", "" + Utils.round((double)s.getSampleSpace().getN(range)));
        }
        catch (IllegalStateException e) {
            this.appendEntry(sDoc, "N: ", NOT_SET_STR);
        }
        this.appendEntry(sDoc, "SampleSpace: ", "" + s.getSampleSpace());
        this.appendEntry(sDoc, "P(POS, POS) :", this.probabilityToString((Sign)Sign.POS, (Sign)Sign.POS, s, range));
        this.appendEntry(sDoc, "P(POS, NEG) :", this.probabilityToString((Sign)Sign.POS, (Sign)Sign.NEG, s, range));
        this.appendEntry(sDoc, "P(NEG, POS) :", this.probabilityToString((Sign)Sign.NEG, (Sign)Sign.POS, s, range));
        this.appendEntry(sDoc, "P(NEG, NEG) :", this.probabilityToString((Sign)Sign.NEG, (Sign)Sign.NEG, s, range));
        this.appendEntry(sDoc, "Surprisal(POS, POS): ", this.surprisalToString((Sign)Sign.POS, (Sign)Sign.POS, s, range));
        this.appendEntry(sDoc, "Surprisal(POS, NEG): ", this.surprisalToString((Sign)Sign.POS, (Sign)Sign.NEG, s, range));
        this.appendEntry(sDoc, "Surprisal(NEG, POS): ", this.surprisalToString((Sign)Sign.NEG, (Sign)Sign.POS, s, range));
        this.appendEntry(sDoc, "Surprisal(NEG, NEG): ", this.surprisalToString((Sign)Sign.NEG, (Sign)Sign.NEG, s, range));
        this.appendEntry(sDoc, "Template: ", s.getTemplate().toString());
    }

    private String frequencyToString(Sign is, Sign os, Synapse s, Range range) {
        double N = s.getSampleSpace().getN(range);
        if (N == 0.0) {
            return NOT_SET_STR;
        }
        try {
            return "" + Utils.round((double)s.getFrequency(is, os, s.getSampleSpace().getN(range)));
        }
        catch (IllegalStateException e) {
            return NOT_SET_STR;
        }
    }

    private String probabilityToString(Sign s, Neuron n, Range range) {
        double N = n.getSampleSpace().getN(range);
        if (N == 0.0) {
            return NOT_SET_STR;
        }
        try {
            return "" + Utils.round((double)n.getProbability(s, N, false), (double)1.0E8);
        }
        catch (IllegalStateException e) {
            return NOT_SET_STR;
        }
    }

    private String probabilityToString(Sign is, Sign os, Synapse s, Range range) {
        double N = s.getSampleSpace().getN(range);
        if (N == 0.0) {
            return NOT_SET_STR;
        }
        try {
            return "" + Utils.round((double)s.getProbability(is, os, N, false), (double)1.0E8);
        }
        catch (IllegalStateException e) {
            return NOT_SET_STR;
        }
    }

    private String surprisalToString(Sign s, Neuron n, Range range) {
        double N = n.getSampleSpace().getN(range);
        if (N == 0.0) {
            return NOT_SET_STR;
        }
        try {
            return "" + Utils.round((double)n.getSurprisal(s, range, false));
        }
        catch (IllegalStateException e) {
            return NOT_SET_STR;
        }
    }

    private String surprisalToString(Sign is, Sign os, Synapse s, Range range) {
        double N = s.getSampleSpace().getN(range);
        if (N == 0.0) {
            return NOT_SET_STR;
        }
        try {
            return "" + Utils.round((double)s.getSurprisal(is, os, range, false));
        }
        catch (IllegalStateException e) {
            return NOT_SET_STR;
        }
    }
}

