/*
 * Decompiled with CFR 0.152.
 */
package network.aika.debugger.neurons;

import java.util.Collection;
import java.util.stream.Collectors;
import network.aika.Model;
import network.aika.debugger.AbstractLayout;
import network.aika.debugger.activations.ActivationGraphManager;
import network.aika.debugger.activations.ActivationParticle;
import network.aika.debugger.neurons.AbstractNeuronViewManager;
import network.aika.debugger.neurons.NeuronConsoleManager;
import network.aika.debugger.neurons.NeuronGraphManager;
import network.aika.debugger.neurons.NeuronLayout;
import network.aika.debugger.neurons.NeuronParticle;
import network.aika.neuron.Neuron;
import network.aika.neuron.Synapse;
import network.aika.utils.Utils;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Node;
import org.graphstream.ui.graphicGraph.GraphicElement;
import org.graphstream.ui.layout.Layout;

public class NeuronViewManager
extends AbstractNeuronViewManager {
    ActivationGraphManager actGraphManager;

    public NeuronViewManager(Model m, NeuronConsoleManager consoleManager, ActivationGraphManager actGraphManager) {
        super(m, consoleManager);
        this.graphManager = new NeuronGraphManager(this.graph);
        this.actGraphManager = actGraphManager;
        this.viewer.enableAutoLayout((Layout)new NeuronLayout(this, (NeuronGraphManager)this.graphManager));
        this.view = this.initView();
    }

    @Override
    public void showElementContext(GraphicElement ge) {
        if (ge instanceof Node) {
            Node n = (Node)ge;
            Neuron neuron = (Neuron)((NeuronGraphManager)this.graphManager).getAikaNode(n);
            if (neuron == null) {
                return;
            }
            NeuronConsoleManager consoleManager = (NeuronConsoleManager)this.getConsoleManager();
            if (consoleManager != null) {
                consoleManager.showSelectedElementContext(neuron);
            }
        } else if (ge instanceof Edge) {
            Edge e = (Edge)ge;
            Synapse s = ((NeuronGraphManager)this.graphManager).getLink(e);
            if (s == null) {
                return;
            }
            ((NeuronConsoleManager)this.getConsoleManager()).showSelectedElementContext(s);
        }
    }

    @Override
    public void viewClosed(String id) {
    }

    @Override
    public void updateGraphNeurons() {
        Collection neurons = this.getModel().getActiveNeurons().stream().map(p -> p.getNeuron()).collect(Collectors.toList());
        double[] x = new double[]{0.0};
        neurons.forEach(n -> {
            this.drawNeuron((Neuron<?, ?>)n, x[0], 0.0);
            x[0] = x[0] + AbstractLayout.STANDARD_DISTANCE_X;
        });
        neurons.forEach(n -> {
            this.drawInputSynapses((Neuron<?, ?>)n);
            this.drawOutputSynapsesLinkedOnlyOnTheInputSide((Neuron<?, ?>)n);
        });
    }

    public double getAverageCoordinates(Neuron<?, ?> n, boolean isX) {
        return n.getActivations(this.actGraphManager.getThought()).stream().map(act -> (ActivationParticle)((Object)((Object)this.actGraphManager.getParticle(act)))).mapToDouble(p -> isX ? p.getPosition().x : p.getPosition().y).average().getAsDouble();
    }

    @Override
    public void dumpNetworkCoordinates() {
        System.out.println("Neurons: ");
        System.out.println("camera.setViewPercent(" + Utils.round((double)this.getCamera().getViewPercent()) + ");");
        System.out.println("camera.setViewCenter(" + Utils.round((double)this.getCamera().getViewCenter().x) + ", " + Utils.round((double)this.getCamera().getViewCenter().y) + ", 0);");
        this.getModel().getActiveNeurons().forEach(n -> {
            NeuronParticle p = (NeuronParticle)((Object)((Object)((NeuronGraphManager)this.graphManager).getParticle(n.getNeuron())));
            if (p != null) {
                System.out.println("coords.put(" + n.getId() + "l, new double[]{" + Utils.round((double)p.getPosition().x) + ", " + Utils.round((double)p.getPosition().y) + "});");
            }
        });
    }
}

