/*
 * Decompiled with CFR 0.152.
 */
package network.aika.debugger.neurons.templates;

import network.aika.Model;
import network.aika.debugger.neurons.AbstractNeuronViewManager;
import network.aika.debugger.neurons.NeuronConsoleManager;
import network.aika.debugger.neurons.NeuronGraphManager;
import network.aika.debugger.neurons.NeuronLayout;
import network.aika.neuron.Neuron;
import network.aika.neuron.Synapse;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Node;
import org.graphstream.ui.graphicGraph.GraphicElement;
import org.graphstream.ui.layout.Layout;

public class TemplateViewManager
extends AbstractNeuronViewManager {
    private double[][] coordinates = new double[][]{{0.0, 0.0}, {-1.0, -1.0}, {0.0, 0.0}, {1.0, -1.0}, {-1.0, 1.0}, {1.0, 1.0}, {0.0, 1.0}};

    public TemplateViewManager(Model m, NeuronConsoleManager consoleManager) {
        super(m, consoleManager);
        this.graphManager = new NeuronGraphManager(this.graph);
        this.viewer.enableAutoLayout((Layout)new NeuronLayout(this, (NeuronGraphManager)this.graphManager));
        this.view = this.initView();
    }

    @Override
    protected void drawNeuron(Neuron<?, ?> n, double x, double y, Node node) {
        super.drawNeuron(n, x, y, node);
        node.setAttribute("ui.label", new Object[]{n.getTemplateInfo().getLabel()});
        String oldStyle = (String)node.getAttribute("ui.style");
        if (n == n.getModel().getTemplates().PATTERN_TEMPLATE || n == n.getModel().getTemplates().INHIBITORY_TEMPLATE) {
            node.setAttribute("ui.style", new Object[]{oldStyle + "text-alignment: above;"});
            node.setAttribute("ui.style", new Object[]{oldStyle + "text-offset: 0, -10;"});
        }
    }

    @Override
    protected Edge drawSynapse(Synapse s) {
        Edge tse = super.drawSynapse(s);
        tse.setAttribute("ui.label", new Object[]{s.getClass().getSimpleName()});
        String oldStyle = (String)tse.getAttribute("ui.style");
        if (s == s.getModel().getTemplates().NEGATIVE_FEEDBACK_SYNAPSE_TEMPLATE) {
            tse.setAttribute("ui.style", new Object[]{oldStyle + "text-offset: -30, -30;"});
        }
        if (s == s.getModel().getTemplates().INHIBITORY_SYNAPSE_TEMPLATE) {
            tse.setAttribute("ui.style", new Object[]{oldStyle + "text-offset: 30, 30;"});
        }
        if (s == s.getModel().getTemplates().POSITIVE_FEEDBACK_SYNAPSE_TEMPLATE) {
            tse.setAttribute("ui.style", new Object[]{oldStyle + "text-offset: -30, 30;"});
        }
        if (s == s.getModel().getTemplates().PATTERN_SYNAPSE_TEMPLATE) {
            tse.setAttribute("ui.style", new Object[]{oldStyle + "text-offset: 30, -50;"});
        }
        if (s == s.getModel().getTemplates().SAME_PATTERN_SYNAPSE_TEMPLATE) {
            tse.setAttribute("ui.style", new Object[]{oldStyle + "text-alignment: above;"});
            tse.setAttribute("ui.style", new Object[]{oldStyle + "text-offset: 50, -100;"});
        }
        return tse;
    }

    @Override
    public void showElementContext(GraphicElement ge) {
        if (ge instanceof Node) {
            Node n = (Node)ge;
            Neuron neuron = (Neuron)((NeuronGraphManager)this.graphManager).getAikaNode(n);
            if (neuron == null) {
                return;
            }
            NeuronConsoleManager consoleManager = (NeuronConsoleManager)this.getConsoleManager();
            if (consoleManager != null) {
                consoleManager.showSelectedElementContext(neuron);
            }
        }
    }

    @Override
    public void viewClosed(String id) {
    }

    @Override
    public void dumpNetworkCoordinates() {
    }

    @Override
    public void updateGraphNeurons() {
        this.getModel().getTemplates().getAllTemplates().forEach(tn -> this.drawNeuron((Neuron<?, ?>)tn, this.coordinates[-tn.getId().intValue()][0], this.coordinates[-tn.getId().intValue()][1]));
        this.getModel().getTemplates().getAllTemplates().forEach(tn -> {
            this.drawInputSynapses((Neuron<?, ?>)tn);
            this.drawOutputSynapsesLinkedOnlyOnTheInputSide((Neuron<?, ?>)tn);
        });
    }
}

