/*
 * Decompiled with CFR 0.152.
 */
package network.aika.debugger.stepmanager;

import network.aika.debugger.stepmanager.StepManager;
import network.aika.debugger.stepmanager.StepMode;

public class DebugStepManager
implements StepManager {
    boolean stopAfterProcessed;
    boolean switchToDebugModeOnDelay = true;
    StepMode mode = StepMode.ACT;
    Long lastTimestamp = null;
    protected boolean clicked;

    @Override
    public void setSwitchToDebugModeOnDelay(boolean switchToDebugModeOnDelay) {
        this.switchToDebugModeOnDelay = switchToDebugModeOnDelay;
    }

    @Override
    public void setStopAfterProcessed(boolean b) {
        this.stopAfterProcessed = b;
    }

    @Override
    public void setMode(StepMode mode) {
        this.mode = mode;
    }

    @Override
    public synchronized void click() {
        this.clicked = true;
        this.notifyAll();
    }

    @Override
    public void resetTimestamp() {
        this.lastTimestamp = null;
    }

    @Override
    public boolean stopHere(StepManager.When w, StepMode et) {
        if (this.mode == null) {
            long diff = this.lastTimestamp != null ? System.currentTimeMillis() - this.lastTimestamp : 0L;
            this.lastTimestamp = System.currentTimeMillis();
            if (diff > 1000L && this.switchToDebugModeOnDelay) {
                this.setMode(StepMode.VISITOR);
            } else {
                return false;
            }
        }
        if (w == StepManager.When.AFTER && this.stopAfterProcessed) {
            this.stopAfterProcessed = false;
            return true;
        }
        if (this.mode == et) {
            return true;
        }
        if (this.mode == StepMode.LINK && et == StepMode.ACT) {
            return true;
        }
        return this.mode == StepMode.VISITOR && (et == StepMode.ACT || et == StepMode.LINK);
    }

    @Override
    public synchronized void waitForClick() {
        try {
            while (!this.clicked) {
                this.wait();
            }
            this.clicked = false;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

