/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package network.aika.debugger.activations.renderer;


import network.aika.debugger.ConsoleRenderer;
import network.aika.neuron.activation.Activation;

import javax.swing.text.StyledDocument;

/**
 * @author Lukas Molzberger
 */
public class ActivationConsoleRenderer<E extends Activation> implements ConsoleRenderer<E> {

    @Override
    public void render(StyledDocument sDoc, E act) {
        appendText(sDoc, (act.isTemplate() ? "Template " : "") + act.getClass().getSimpleName() + " " + "\n", "headline");
        appendEntry(sDoc, "Id: ", "" + act.getId());
        appendEntry(sDoc, "Label: ", act.getLabel());
        if(act.isInput())
            appendEntry(sDoc, "IsInput: ", "" + act.isInput());
        appendField(sDoc, act.getValue());
        appendField(sDoc, act.getFinalValue());
        appendField(sDoc, act.getNet());
        if(act.getNetOuterGradient() != null)
            appendField(sDoc, act.getNetOuterGradient());
        appendField(sDoc, act.getIsFired());
        appendField(sDoc, act.getIsFiredForWeight());
        appendField(sDoc, act.getIsFiredForBias());
        appendField(sDoc, act.getIsFinal());
        appendField(sDoc, act.getEntropy());
        appendField(sDoc, act.getOwnInputGradient());
        appendField(sDoc, act.getOwnOutputGradient());
        appendField(sDoc, act.getBackpropInputGradient());
        appendField(sDoc, act.getBackpropOutputGradient());
        appendField(sDoc, act.getOutputGradient());
        appendField(sDoc, act.getUpdateValue());
        appendField(sDoc, act.getInductionThreshold());

        appendEntry(sDoc, "CreatedTS: ", "" + act.getCreated());
        appendEntry(sDoc, "FiredTS: ", "" + act.getFired());
    }
}
