/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package network.aika.debugger;


import network.aika.debugger.stepmanager.StepManager;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

import static network.aika.debugger.stepmanager.StepMode.*;

/**
 * @author Lukas Molzberger
 */
public class KeyManager implements KeyListener {

    AIKADebugger debugger;


    public KeyManager(AIKADebugger debugger) {
        this.debugger = debugger;
    }

    @Override
    public void keyTyped(KeyEvent e) {

    }

    @Override
    public void keyPressed(KeyEvent e) {
        StepManager sm = debugger.getActivationViewManager().getStepManager();

        char c = e.getKeyChar();
        if(c == 'm') {
            System.out.println("Metric: " + debugger.getActivationViewManager().getCamera().getMetrics());
            return;
        }

        if(c == 'e') {
            sm.setStopAfterProcessed(true);
        } else if(c == 'r') {
            sm.setMode(null);
            sm.setBreakpoint(null);
            sm.resetTimestamp();
        } else if(c == 'a') {
            sm.setMode(ACT);
        } else if(c == 'l') {
            sm.setMode(LINK);
        } else if(c == 'd') {
            debugger.getActivationViewManager().setDebugMode(true);
            return;
        } else if(c == 's') {
            debugger.getActivationViewManager().setScopeMode(true);
            return;
        } else if(c == 'b') {
            // Run till next breakpoint
//            if(debugManager.getCurrentTestCase() != null)
//                sm.setRestartTestcaseSignal(true);

            sm.setMode(null);
            sm.resetTimestamp();

            sm.setBreakpoint(debugger.getNextBreakpoint());
        } else if(Character.isDigit(c)) {
            int testCaseId = Integer.parseInt("" + c);
            Runnable testCase = debugger.getTestCaseListeners().get(testCaseId);

            if(testCase != debugger.getCurrentTestCase()) {
                sm.setRestartTestcaseSignal(true);
                debugger.setCurrentTestCase(testCase);
            }
        }

        sm.click();
    }

    @Override
    public void keyReleased(KeyEvent e) {
        char c = e.getKeyChar();
        if(c == 'd') {
            debugger.getActivationViewManager().setDebugMode(false);
            return;
        } else if(c == 's') {
            debugger.getActivationViewManager().setScopeMode(false);
            return;
        } else if(c == 'o') {
            debugger.getActivationViewManager().dumpNetworkCoordinates();
            debugger.getNeuronViewManager().dumpNetworkCoordinates();
        }
    }
}
