/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package network.aika.debugger.activations;

import network.aika.neuron.activation.Activation;
import network.aika.text.Document;
import network.aika.debugger.AbstractLayout;
import org.graphstream.graph.Node;
import org.graphstream.ui.layout.springbox.NodeParticle;
import org.miv.pherd.geom.Point3;

import static network.aika.debugger.activations.ActivationParticle.computeInitialActivationPosition;

/**
 * @author Lukas Molzberger
 */
public class ActivationLayout extends AbstractLayout<ActivationGraphManager> {
    ActivationViewManager avm;

    public ActivationLayout(ActivationViewManager avm, ActivationGraphManager gm) {
        super(gm);
        this.avm = avm;

        k = STANDARD_DISTANCE_X;
        K1Init = 0.06f;
        K1Final = 0.01f;
        K2 = 0.005f;
    }

    @Override
    public NodeParticle newNodeParticle(String id) {
        Document doc = avm.getDocument();
        Node n = graphManager.getNode(id);
        Integer aikaId = n.getAttribute("aika.id", Integer.class);
        Activation act = doc.getActivation(aikaId);

        Integer originActId = n.getAttribute("aika.originActId", Integer.class);
        String originSynapseType = n.getAttribute("aika.originSynapseType", String.class);

        Double x;
        Double y;

        ActivationParticle particle;
        if(originActId != null) {
            ActivationParticle originParticle = graphManager.getParticle(originActId);
            Activation originAct = doc.getActivation(originActId);
            Point3 originPos = originParticle.getPosition();

            Point3 initialPos = computeInitialActivationPosition(act, originSynapseType, originAct, originPos);
            x = initialPos.x;
            y = initialPos.y;
        } else {
            x = (Double) n.getAttribute("x");
            y = (Double) n.getAttribute("y");

            if(x == null)
                x = 0.0;

            if(y == null)
                y = 0.0;
        }

        particle = new ActivationParticle(this, n, act, id, x, y, 0);

        graphManager.setParticle(act, particle);

        return particle;
    }
}
