/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package network.aika.debugger.activations.renderer;

import network.aika.debugger.ConsoleRenderer;
import network.aika.neuron.bindingsignal.BindingSignal;

import javax.swing.text.StyledDocument;

/**
 * @author Lukas Molzberger
 */
public class BindingSignalConsoleRenderer implements ConsoleRenderer<BindingSignal> {

    @Override
    public void render(StyledDocument sDoc, BindingSignal bs) {
        appendEntry(sDoc, "Origin-Id: ", "" + bs.getOriginActivation().getId());
        appendEntry(sDoc, "Origin-Label: ", "" + bs.getOriginActivation().getLabel());
        appendEntry(sDoc, "State: ", "" + bs.getState());

        if(bs.getTransition() != null)
            appendEntry(sDoc, "Transition: ", "" + bs.getTransition());

        if(bs.getLink() != null)
            appendEntry(sDoc, "Link: ", "" + bs.getLink());

        appendEntry(sDoc, "Depth: ", "" + bs.getDepth());

        appendField(sDoc, bs.getEvent(false, false));
        appendField(sDoc, bs.getEvent(true, false));
        appendField(sDoc, bs.getEvent(false, true));
        appendField(sDoc, bs.getEvent(true, true));

        appendEntry(sDoc, "", "");
    }
}
