/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package network.aika.debugger.activations.renderer;

import network.aika.Thought;
import network.aika.debugger.ConsoleRenderer;
import network.aika.neuron.activation.Element;
import network.aika.steps.Step;

import javax.swing.text.StyledDocument;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author Lukas Molzberger
 */
public class ElementQueueRenderer implements ConsoleRenderer<Element> {

    private Step step;
    private String event;

    public ElementQueueRenderer(Step step, String event) {
        this.step = step;
        this.event = event;
    }

    @Override
    public void render(StyledDocument sDoc, Element e) {
        if(step != null)
            appendText(sDoc, event + " " + step.getSecondaryTimestamp() + ":" + step.getClass().getSimpleName() + "\n", "headline");
        else
            appendText(sDoc, event + "\n", "headline");

        Thought t = e.getThought();
        if(t == null)
            return;

        Stream<Step> elementQueue = t.getQueue().stream();
        elementQueue
                .filter(s -> s.getElement() == e)
                .forEach(s ->
                new StepConsoleRenderer(e.getThought()).render(sDoc, s)
        );
    }
}
