/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package network.aika.debugger.activations.renderer;

import network.aika.Thought;
import network.aika.debugger.ConsoleRenderer;
import network.aika.neuron.activation.Timestamp;
import network.aika.steps.Step;

import javax.swing.text.StyledDocument;

import static network.aika.neuron.activation.Timestamp.NOT_SET;

/**
 * @author Lukas Molzberger
 */
public class StepConsoleRenderer implements ConsoleRenderer<Step> {

    private Thought t;

    public StepConsoleRenderer(Thought t) {
        this.t = t;
    }

    @Override
    public void render(StyledDocument sDoc, Step s) {
        Timestamp currentTimestamp = t.getTimestampOnProcess();
        String regularColor = "regular";
        String boldColor = "bold";
        if(currentTimestamp.compareTo(s.getSecondaryTimestamp()) <= 0) {
            regularColor = "regularGreen";
            boldColor = "boldGreen";
        }

        appendEntry(
                sDoc,
                getQueueEntrySortKeyDescription(s),
                s.toString(),
                boldColor,
                regularColor
        );
    }

    public static String getQueueEntrySortKeyDescription(Step s) {
        return s.getPhase().name() + " " + s.timestampToString() + " " + s.getStepName() + " ";
    }
}
