/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package network.aika.debugger.neurons;


import network.aika.debugger.AbstractConsole;
import network.aika.debugger.neurons.renderer.NeuronConsoleRenderer;
import network.aika.debugger.neurons.renderer.PositiveFeedbackSynapseConsoleRenderer;
import network.aika.debugger.neurons.renderer.SamePatternSynapseConsoleRenderer;
import network.aika.debugger.neurons.renderer.SynapseConsoleRenderer;
import network.aika.neuron.Neuron;
import network.aika.neuron.Synapse;
import network.aika.neuron.activation.Activation;
import network.aika.neuron.activation.Link;
import network.aika.neuron.conjunctive.*;

import javax.swing.text.StyledDocument;

/**
 * @author Lukas Molzberger
 */
public class NeuronConsole extends AbstractConsole {

    public void renderNeuronConsoleOutput(StyledDocument sDoc, Neuron n, Activation ref) {
        NeuronConsoleRenderer neuronRenderer = new NeuronConsoleRenderer(ref);
        neuronRenderer.render(sDoc, n);
    }

    public void renderSynapseConsoleOutput(StyledDocument sDoc, Synapse s, Link ref) {
        SynapseConsoleRenderer synRenderer;

        if(s instanceof PositiveFeedbackSynapse<?,?>) {
            synRenderer = new PositiveFeedbackSynapseConsoleRenderer(ref);
        } else if(s instanceof SamePatternSynapse) {
            synRenderer = new SamePatternSynapseConsoleRenderer(ref);
        } else {
            synRenderer = new SynapseConsoleRenderer(ref);
        }
        synRenderer.render(sDoc, s);
    }

}
