/*
 * Decompiled with CFR 0.152.
 */
package network.aika.debugger;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import network.aika.debugger.AIKADebugger;
import network.aika.debugger.stepmanager.StepManager;
import network.aika.debugger.stepmanager.StepMode;

public class KeyManager
implements KeyListener {
    AIKADebugger debugger;

    public KeyManager(AIKADebugger debugger) {
        this.debugger = debugger;
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        StepManager sm = this.debugger.getActivationViewManager().getStepManager();
        char c = e.getKeyChar();
        if (c == 'm') {
            System.out.println("Metric: " + this.debugger.getActivationViewManager().getCamera().getMetrics());
            return;
        }
        if (c == 'e') {
            sm.setStopAfterProcessed(true);
        } else if (c == 'r') {
            sm.setMode(null);
            sm.setBreakpoint(null);
            sm.resetTimestamp();
        } else if (c == 'a') {
            sm.setMode(StepMode.ACT);
        } else if (c == 'l') {
            sm.setMode(StepMode.LINK);
        } else {
            if (c == 'd') {
                this.debugger.getActivationViewManager().setDebugMode(true);
                return;
            }
            if (c == 's') {
                this.debugger.getActivationViewManager().setScopeMode(true);
                return;
            }
            if (c == 'b') {
                sm.setMode(null);
                sm.resetTimestamp();
                sm.setBreakpoint(this.debugger.getNextBreakpoint());
            } else if (Character.isDigit(c)) {
                int testCaseId = Integer.parseInt("" + c);
                Runnable testCase = this.debugger.getTestCaseListeners().get(testCaseId);
                if (testCase != this.debugger.getCurrentTestCase()) {
                    sm.setRestartTestcaseSignal(true);
                    this.debugger.setCurrentTestCase(testCase);
                }
            }
        }
        sm.click();
    }

    @Override
    public void keyReleased(KeyEvent e) {
        char c = e.getKeyChar();
        if (c == 'd') {
            this.debugger.getActivationViewManager().setDebugMode(false);
            return;
        }
        if (c == 's') {
            this.debugger.getActivationViewManager().setScopeMode(false);
            return;
        }
        if (c == 'o') {
            this.debugger.getActivationViewManager().dumpNetworkCoordinates();
            this.debugger.getNeuronViewManager().dumpNetworkCoordinates();
        }
    }
}

