/*
 * Decompiled with CFR 0.152.
 */
package network.aika.debugger.activations;

import java.awt.Component;
import javax.swing.JSplitPane;
import javax.swing.text.StyledDocument;
import network.aika.debugger.AbstractConsole;
import network.aika.debugger.activations.ActivationConsoleManager;
import network.aika.debugger.activations.BindingSignalConsole;
import network.aika.debugger.activations.ElementQueueConsole;
import network.aika.debugger.activations.renderer.ActivationConsoleRenderer;
import network.aika.debugger.activations.renderer.BindingActivationConsoleRenderer;
import network.aika.debugger.activations.renderer.LinkConsoleRenderer;
import network.aika.debugger.activations.renderer.NegativeFeedBackLinkConsoleRenderer;
import network.aika.debugger.activations.renderer.PositiveFeedBackLinkConsoleRenderer;
import network.aika.debugger.neurons.NeuronConsole;
import network.aika.neuron.activation.Activation;
import network.aika.neuron.activation.BindingActivation;
import network.aika.neuron.activation.DummyActivation;
import network.aika.neuron.activation.Element;
import network.aika.neuron.activation.Link;
import network.aika.neuron.activation.NegativeFeedbackLink;
import network.aika.neuron.activation.PositiveFeedbackLink;
import network.aika.steps.Step;

public class ActivationConsole
extends AbstractConsole {
    private NeuronConsole neuronConsole;
    private ElementQueueConsole elementQueueConsole;
    private BindingSignalConsole bindingSignalConsole;
    private JSplitPane innerHorizontalSplitPane;
    private JSplitPane outerHorizontalSplitPane;
    private JSplitPane verticalSplitPane;

    public Component getSplitPane() {
        this.neuronConsole = new NeuronConsole();
        this.bindingSignalConsole = new BindingSignalConsole();
        this.innerHorizontalSplitPane = new JSplitPane(1, this.bindingSignalConsole, this.neuronConsole);
        this.innerHorizontalSplitPane.setResizeWeight(0.5);
        this.innerHorizontalSplitPane.setDividerLocation(0.5);
        this.outerHorizontalSplitPane = new JSplitPane(1, this, this.innerHorizontalSplitPane);
        this.outerHorizontalSplitPane.setResizeWeight(0.33);
        this.outerHorizontalSplitPane.setDividerLocation(0.33);
        this.elementQueueConsole = new ElementQueueConsole();
        this.verticalSplitPane = new JSplitPane(0, ActivationConsoleManager.getScrollPane(this.elementQueueConsole), ActivationConsoleManager.getScrollPane(this.outerHorizontalSplitPane));
        this.verticalSplitPane.setResizeWeight(0.3);
        this.verticalSplitPane.setDividerLocation(0.3);
        return this.verticalSplitPane;
    }

    public void renderElementConsoleOutput(StyledDocument sDoc, Element e, Step s, String event) {
        if (e instanceof DummyActivation) {
            this.bindingSignalConsole.render(bsDoc -> {});
            return;
        }
        if (e instanceof Activation) {
            this.renderActivationConsoleOutput(sDoc, (Activation)e, s, event);
        } else if (e instanceof Link) {
            this.renderLinkConsoleOutput(sDoc, (Link)e, s, event);
        }
    }

    public void renderActivationConsoleOutput(StyledDocument sDoc, Activation act, Step s, String event) {
        ActivationConsoleRenderer actRenderer = act instanceof BindingActivation ? new BindingActivationConsoleRenderer() : new ActivationConsoleRenderer();
        actRenderer.render(sDoc, act);
        this.bindingSignalConsole.render(bsDoc -> this.bindingSignalConsole.renderBindingSignals((StyledDocument)bsDoc, (Activation<?>)act));
        this.neuronConsole.render(nsDoc -> this.neuronConsole.renderNeuronConsoleOutput((StyledDocument)nsDoc, act.getNeuron(), act));
        this.elementQueueConsole.render(eqsDoc -> this.elementQueueConsole.renderElementQueueOutput((StyledDocument)eqsDoc, (Element)act, s, event));
    }

    public void renderLinkConsoleOutput(StyledDocument sDoc, Link l, Step s, String event) {
        LinkConsoleRenderer linkRenderer = l instanceof PositiveFeedbackLink ? new PositiveFeedBackLinkConsoleRenderer() : (l instanceof NegativeFeedbackLink ? new NegativeFeedBackLinkConsoleRenderer() : new LinkConsoleRenderer());
        ((LinkConsoleRenderer)linkRenderer).render(sDoc, l);
        this.bindingSignalConsole.render(bsDoc -> this.bindingSignalConsole.renderBindingSignals((StyledDocument)bsDoc, l));
        this.neuronConsole.render(nsDoc -> this.neuronConsole.renderSynapseConsoleOutput((StyledDocument)nsDoc, l.getSynapse(), l));
        this.elementQueueConsole.render(eqsDoc -> this.elementQueueConsole.renderElementQueueOutput((StyledDocument)eqsDoc, (Element)l, s, event));
    }
}

