/*
 * Decompiled with CFR 0.152.
 */
package network.aika.debugger.activations;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.text.StyledDocument;
import network.aika.Thought;
import network.aika.callbacks.EventListener;
import network.aika.debugger.AbstractConsoleManager;
import network.aika.debugger.activations.ActivationConsole;
import network.aika.debugger.activations.QueueConsole;
import network.aika.neuron.Synapse;
import network.aika.neuron.activation.Activation;
import network.aika.neuron.activation.Element;
import network.aika.neuron.activation.Link;
import network.aika.steps.Step;
import network.aika.text.Document;

public class ActivationConsoleManager
extends AbstractConsoleManager<ActivationConsole>
implements EventListener {
    private QueueConsole queueConsole = new QueueConsole();
    private JTabbedPane activationViewTabbedPane;
    private Element selectedElement;

    public ActivationConsoleManager(Document doc) {
        super(new ActivationConsole(), new ActivationConsole());
        doc.addEventListener((EventListener)this);
    }

    public QueueConsole getQueueConsole() {
        return this.queueConsole;
    }

    public void showSelectedElementContext(Activation act) {
        this.selectedElement = act;
        this.activationViewTabbedPane.setSelectedIndex(1);
        ((ActivationConsole)this.selectedConsole).render(sDoc -> ((ActivationConsole)this.selectedConsole).renderActivationConsoleOutput((StyledDocument)sDoc, act, null, "Selected"));
    }

    public void showSelectedElementContext(Link l) {
        this.selectedElement = l;
        this.activationViewTabbedPane.setSelectedIndex(1);
        ((ActivationConsole)this.selectedConsole).render(sDoc -> ((ActivationConsole)this.selectedConsole).renderLinkConsoleOutput((StyledDocument)sDoc, l, null, "Selected"));
    }

    @Override
    public JComponent getConsolePane() {
        this.initActivationViewTabbedPane();
        JSplitPane sp = new JSplitPane(0, this.activationViewTabbedPane, ActivationConsoleManager.getScrollPane(this.queueConsole));
        sp.setResizeWeight(0.65);
        return sp;
    }

    public JTabbedPane getActivationViewTabbedPane() {
        return this.activationViewTabbedPane;
    }

    private JComponent initActivationViewTabbedPane() {
        this.activationViewTabbedPane = new JTabbedPane();
        this.activationViewTabbedPane.setTabLayoutPolicy(1);
        this.activationViewTabbedPane.setFocusCycleRoot(true);
        this.activationViewTabbedPane.addTab("Main", null, ((ActivationConsole)this.mainConsole).getSplitPane(), "Shows the currently processed graph element");
        this.activationViewTabbedPane.addTab("Selected", null, ((ActivationConsole)this.selectedConsole).getSplitPane(), "Shows the selected graph element");
        return this.activationViewTabbedPane;
    }

    public static JScrollPane getScrollPane(Component c) {
        JScrollPane scrollPane = new JScrollPane(c);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setPreferredSize(new Dimension(250, 155));
        scrollPane.setMinimumSize(new Dimension(10, 10));
        return scrollPane;
    }

    public void queueEntryAddedEvent(Step s) {
        this.queueConsole.render(sDoc -> this.queueConsole.renderQueue((StyledDocument)sDoc, (Thought<?>)s.getElement().getThought(), null));
        ((ActivationConsole)this.mainConsole).render(sDoc -> ((ActivationConsole)this.mainConsole).renderElementConsoleOutput((StyledDocument)sDoc, s.getElement(), s, "Added Entry"));
        this.updateSelectedElement();
    }

    public void beforeProcessedEvent(Step s) {
        this.queueConsole.render(sDoc -> this.queueConsole.renderQueue((StyledDocument)sDoc, (Thought<?>)s.getElement().getThought(), s));
        ((ActivationConsole)this.mainConsole).render(sDoc -> ((ActivationConsole)this.mainConsole).renderElementConsoleOutput((StyledDocument)sDoc, s.getElement(), s, "Before"));
        this.updateSelectedElement();
    }

    public void afterProcessedEvent(Step s) {
        this.queueConsole.render(sDoc -> this.queueConsole.renderQueue((StyledDocument)sDoc, (Thought<?>)s.getElement().getThought(), s));
        ((ActivationConsole)this.mainConsole).render(sDoc -> ((ActivationConsole)this.mainConsole).renderElementConsoleOutput((StyledDocument)sDoc, s.getElement(), s, "After"));
        this.updateSelectedElement();
    }

    public void onActivationCreationEvent(Activation act, Synapse originSynapse, Activation originAct) {
        ((ActivationConsole)this.mainConsole).render(sDoc -> ((ActivationConsole)this.mainConsole).renderActivationConsoleOutput((StyledDocument)sDoc, act, null, "New"));
        this.updateSelectedElement();
    }

    public void onLinkCreationEvent(Link l) {
        ((ActivationConsole)this.mainConsole).render(sDoc -> ((ActivationConsole)this.mainConsole).renderLinkConsoleOutput((StyledDocument)sDoc, l, null, "New"));
        this.updateSelectedElement();
    }

    private void updateSelectedElement() {
        if (this.selectedElement instanceof Activation) {
            ((ActivationConsole)this.selectedConsole).render(sDoc -> ((ActivationConsole)this.selectedConsole).renderActivationConsoleOutput((StyledDocument)sDoc, (Activation)this.selectedElement, null, "Selected"));
        } else if (this.selectedElement instanceof Link) {
            ((ActivationConsole)this.selectedConsole).render(sDoc -> ((ActivationConsole)this.selectedConsole).renderLinkConsoleOutput((StyledDocument)sDoc, (Link)this.selectedElement, null, "Selected"));
        }
    }
}

