/*
 * Decompiled with CFR 0.152.
 */
package network.aika.debugger.neurons.renderer;

import javax.swing.text.StyledDocument;
import network.aika.debugger.AbstractConsole;
import network.aika.debugger.ConsoleRenderer;
import network.aika.neuron.Range;
import network.aika.neuron.Synapse;
import network.aika.neuron.activation.Link;
import network.aika.sign.Sign;
import network.aika.utils.Utils;

public class SynapseConsoleRenderer<E extends Synapse>
implements ConsoleRenderer<E> {
    protected Link ref;

    public SynapseConsoleRenderer(Link ref) {
        this.ref = ref;
    }

    @Override
    public void render(StyledDocument sDoc, E s) {
        this.appendText(sDoc, (s.isTemplate() ? "Template " : "") + s.getClass().getSimpleName() + "\n", "headline");
        this.appendEntry(sDoc, "Weight: ", "" + s.getWeight());
        this.appendEntry(sDoc, "Input: ", s.getInput().toString() + (s.isInputLinked() ? " (linked)" : ""));
        this.appendEntry(sDoc, "Output: ", s.getOutput().toString() + (s.isOutputLinked() ? " (linked)" : ""));
        Range range = !s.isTemplate() && this.ref != null && this.ref.getInput() != null ? this.ref.getInput().getAbsoluteRange() : null;
        this.appendEntry(sDoc, "Range: ", (String)(range != null ? "" + range : AbstractConsole.NOT_SET_STR));
        this.appendEntry(sDoc, "Frequency(POS, POS): ", this.frequencyToString((Sign)Sign.POS, (Sign)Sign.POS, (Synapse)s, range));
        this.appendEntry(sDoc, "Frequency(POS, NEG): ", this.frequencyToString((Sign)Sign.POS, (Sign)Sign.NEG, (Synapse)s, range));
        this.appendEntry(sDoc, "Frequency(NEG, POS): ", this.frequencyToString((Sign)Sign.NEG, (Sign)Sign.POS, (Synapse)s, range));
        this.appendEntry(sDoc, "Frequency(NEG, NEG): ", this.frequencyToString((Sign)Sign.NEG, (Sign)Sign.NEG, (Synapse)s, range));
        this.appendEntry(sDoc, "SampleSpace: ", "" + s.getSampleSpace());
        this.appendEntry(sDoc, "P(POS, POS) :", this.probabilityToString((Sign)Sign.POS, (Sign)Sign.POS, (Synapse)s, range));
        this.appendEntry(sDoc, "P(POS, NEG) :", this.probabilityToString((Sign)Sign.POS, (Sign)Sign.NEG, (Synapse)s, range));
        this.appendEntry(sDoc, "P(NEG, POS) :", this.probabilityToString((Sign)Sign.NEG, (Sign)Sign.POS, (Synapse)s, range));
        this.appendEntry(sDoc, "P(NEG, NEG) :", this.probabilityToString((Sign)Sign.NEG, (Sign)Sign.NEG, (Synapse)s, range));
        this.appendEntry(sDoc, "Surprisal(POS, POS): ", this.surprisalToString((Sign)Sign.POS, (Sign)Sign.POS, (Synapse)s, range));
        this.appendEntry(sDoc, "Surprisal(POS, NEG): ", this.surprisalToString((Sign)Sign.POS, (Sign)Sign.NEG, (Synapse)s, range));
        this.appendEntry(sDoc, "Surprisal(NEG, POS): ", this.surprisalToString((Sign)Sign.NEG, (Sign)Sign.POS, (Synapse)s, range));
        this.appendEntry(sDoc, "Surprisal(NEG, NEG): ", this.surprisalToString((Sign)Sign.NEG, (Sign)Sign.NEG, (Synapse)s, range));
        this.appendEntry(sDoc, "Template: ", s.getTemplate().toString());
    }

    private String frequencyToString(Sign is, Sign os, Synapse s, Range range) {
        double N = s.getSampleSpace().getN(range);
        if (N == 0.0) {
            return AbstractConsole.NOT_SET_STR;
        }
        try {
            return "" + Utils.round((double)s.getFrequency(is, os, s.getSampleSpace().getN(range)));
        }
        catch (IllegalStateException e) {
            return AbstractConsole.NOT_SET_STR;
        }
    }

    private String probabilityToString(Sign is, Sign os, Synapse s, Range range) {
        double N = s.getSampleSpace().getN(range);
        if (N == 0.0) {
            return AbstractConsole.NOT_SET_STR;
        }
        try {
            return "" + Utils.round((double)s.getProbability(is, os, N, false), (double)1.0E8);
        }
        catch (IllegalStateException e) {
            return AbstractConsole.NOT_SET_STR;
        }
    }

    private String surprisalToString(Sign is, Sign os, Synapse s, Range range) {
        double N = s.getSampleSpace().getN(range);
        if (N == 0.0) {
            return AbstractConsole.NOT_SET_STR;
        }
        try {
            return "" + Utils.round((double)s.getSurprisal(is, os, range, false));
        }
        catch (IllegalStateException e) {
            return AbstractConsole.NOT_SET_STR;
        }
    }
}

