/*
 * Decompiled with CFR 0.152.
 */
package network.aika.debugger.stepmanager;

import network.aika.debugger.stepmanager.StepManager;
import network.aika.debugger.stepmanager.StepMode;
import network.aika.debugger.stepmanager.TestCaseRestartException;
import network.aika.text.Document;

public class DebugStepManager
implements StepManager {
    boolean stopAfterProcessed;
    boolean switchToDebugModeOnDelay = true;
    boolean restartTestcaseSignal = false;
    Long nextBreakpoint = null;
    Document doc;
    StepMode mode = StepMode.ACT;
    Long lastTimestamp = null;
    protected boolean clicked;

    public DebugStepManager(Document doc) {
        this.doc = doc;
    }

    @Override
    public void setSwitchToDebugModeOnDelay(boolean switchToDebugModeOnDelay) {
        this.switchToDebugModeOnDelay = switchToDebugModeOnDelay;
    }

    @Override
    public void setStopAfterProcessed(boolean b) {
        this.stopAfterProcessed = b;
    }

    @Override
    public void setMode(StepMode mode) {
        this.mode = mode;
    }

    @Override
    public synchronized void click() {
        this.clicked = true;
        this.notifyAll();
    }

    @Override
    public void resetTimestamp() {
        this.lastTimestamp = null;
    }

    @Override
    public boolean stopHere(StepManager.When w, StepMode et) {
        if (this.restartTestcaseSignal) {
            throw new TestCaseRestartException();
        }
        if (this.nextBreakpoint != null && this.doc.getCurrentTimestamp().getTimestamp() > this.nextBreakpoint) {
            this.setMode(StepMode.LINK);
            return true;
        }
        if (this.mode == null) {
            long diff = this.lastTimestamp != null ? System.currentTimeMillis() - this.lastTimestamp : 0L;
            this.lastTimestamp = System.currentTimeMillis();
            if (diff > 1000L && this.switchToDebugModeOnDelay) {
                this.setMode(StepMode.LINK);
            } else {
                return false;
            }
        }
        if (w == StepManager.When.AFTER && this.stopAfterProcessed) {
            this.stopAfterProcessed = false;
            return true;
        }
        if (this.mode == et) {
            return true;
        }
        return this.mode == StepMode.LINK && et == StepMode.ACT;
    }

    @Override
    public void setBreakpoint(Long bp) {
        this.nextBreakpoint = bp;
    }

    @Override
    public synchronized void waitForClick() {
        try {
            while (!this.clicked) {
                this.wait();
            }
            this.clicked = false;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public boolean isRestartTestcaseSignal() {
        return this.restartTestcaseSignal;
    }

    @Override
    public void setRestartTestcaseSignal(boolean restartTestcaseSignal) {
        this.restartTestcaseSignal = restartTestcaseSignal;
    }
}

