/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.graph.implementations;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.graphstream.graph.Element;

public abstract class OneAttributeElement
implements Element {
    protected String id;
    Object attribute = null;

    public OneAttributeElement(String id) {
        assert (id != null) : "Graph elements cannot have a null identifier";
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Object getAttribute(String key) {
        return this.attribute;
    }

    @Override
    public Object getFirstAttributeOf(String ... keys) {
        return this.attribute;
    }

    @Override
    public <T> T getAttribute(String key, Class<T> clazz) {
        return (T)this.attribute;
    }

    @Override
    public <T> T getFirstAttributeOf(Class<T> clazz, String ... keys) {
        return (T)this.attribute;
    }

    @Override
    public CharSequence getLabel(String key) {
        if (this.attribute != null && this.attribute instanceof CharSequence) {
            return (CharSequence)this.attribute;
        }
        return null;
    }

    @Override
    public double getNumber(String key) {
        if (this.attribute != null && this.attribute instanceof Number) {
            return ((Number)this.attribute).doubleValue();
        }
        return Double.NaN;
    }

    public ArrayList<? extends Number> getVector(String key) {
        if (this.attribute != null && this.attribute instanceof ArrayList) {
            return (ArrayList)this.attribute;
        }
        return null;
    }

    @Override
    public boolean hasAttribute(String key) {
        return true;
    }

    @Override
    public boolean hasAttribute(String key, Class<?> clazz) {
        if (this.attribute != null) {
            return clazz.isInstance(this.attribute);
        }
        return false;
    }

    @Override
    public boolean hasLabel(String key) {
        if (this.attribute != null) {
            return this.attribute instanceof CharSequence;
        }
        return false;
    }

    @Override
    public boolean hasNumber(String key) {
        if (this.attribute != null) {
            return this.attribute instanceof Number;
        }
        return false;
    }

    @Override
    public boolean hasVector(String key) {
        return this.attribute != null && this.attribute instanceof ArrayList;
    }

    public Iterator<String> getAttributeKeyIterator() {
        return null;
    }

    public Map<String, Object> getAttributeMap() {
        return null;
    }

    public String toString() {
        return this.id;
    }

    @Override
    public void clearAttributes() {
        this.attribute = null;
    }

    public void addAttribute(String attribute, Object value) {
        this.attribute = value;
    }

    public void changeAttribute(String attribute, Object value) {
        this.addAttribute(attribute, value);
    }

    @Override
    public void setAttributes(Map<String, Object> attributes) {
        if (attributes.size() >= 1) {
            this.addAttribute("", attributes.get(attributes.keySet().toArray()[0]));
        }
    }

    @Override
    public void removeAttribute(String attribute) {
        this.attribute = null;
    }

    protected abstract void attributeChanged(String var1, long var2, String var4, AttributeChangeEvent var5, Object var6, Object var7);

    public static enum AttributeChangeEvent {
        ADD,
        CHANGE,
        REMOVE;

    }
}

