/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.rmi;

import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.graphstream.stream.AttributeSink;
import org.graphstream.stream.ElementSink;
import org.graphstream.stream.Sink;
import org.graphstream.stream.Source;
import org.graphstream.stream.rmi.RMIAdapterIn;

public class RMISource
extends UnicastRemoteObject
implements RMIAdapterIn,
Source {
    private static final long serialVersionUID = 6635146473737922832L;
    ConcurrentLinkedQueue<AttributeSink> attributesListeners = new ConcurrentLinkedQueue();
    ConcurrentLinkedQueue<ElementSink> elementsListeners = new ConcurrentLinkedQueue();

    public RMISource() throws RemoteException {
    }

    public RMISource(String name) throws RemoteException {
        this();
        this.bind(name);
    }

    public void bind(String name) {
        try {
            Naming.rebind(String.format("//localhost/%s", name), this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void edgeAdded(String graphId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) throws RemoteException {
        for (ElementSink gel : this.elementsListeners) {
            gel.edgeAdded(graphId, timeId, edgeId, fromNodeId, toNodeId, directed);
        }
    }

    @Override
    public void edgeAttributeAdded(String graphId, long timeId, String edgeId, String attribute, Object value) throws RemoteException {
        for (AttributeSink gal : this.attributesListeners) {
            gal.edgeAttributeAdded(graphId, timeId, edgeId, attribute, value);
        }
    }

    @Override
    public void edgeAttributeChanged(String graphId, long timeId, String edgeId, String attribute, Object oldValue, Object newValue) throws RemoteException {
        for (AttributeSink gal : this.attributesListeners) {
            gal.edgeAttributeChanged(graphId, timeId, edgeId, attribute, oldValue, newValue);
        }
    }

    @Override
    public void edgeAttributeRemoved(String graphId, long timeId, String edgeId, String attribute) throws RemoteException {
        for (AttributeSink gal : this.attributesListeners) {
            gal.edgeAttributeRemoved(graphId, timeId, edgeId, attribute);
        }
    }

    @Override
    public void edgeRemoved(String graphId, long timeId, String edgeId) throws RemoteException {
        for (ElementSink gel : this.elementsListeners) {
            gel.edgeRemoved(graphId, timeId, edgeId);
        }
    }

    @Override
    public void graphAttributeAdded(String graphId, long timeId, String attribute, Object value) throws RemoteException {
        for (AttributeSink gal : this.attributesListeners) {
            gal.graphAttributeAdded(graphId, timeId, attribute, value);
        }
    }

    @Override
    public void graphAttributeChanged(String graphId, long timeId, String attribute, Object oldValue, Object newValue) throws RemoteException {
        for (AttributeSink gal : this.attributesListeners) {
            gal.graphAttributeChanged(graphId, timeId, attribute, oldValue, newValue);
        }
    }

    @Override
    public void graphAttributeRemoved(String graphId, long timeId, String attribute) throws RemoteException {
        for (AttributeSink gal : this.attributesListeners) {
            gal.graphAttributeRemoved(graphId, timeId, attribute);
        }
    }

    @Override
    public void graphCleared(String graphId, long timeId) throws RemoteException {
        for (ElementSink gel : this.elementsListeners) {
            gel.graphCleared(graphId, timeId);
        }
    }

    @Override
    public void nodeAdded(String graphId, long timeId, String nodeId) throws RemoteException {
        for (ElementSink gel : this.elementsListeners) {
            gel.nodeAdded(graphId, timeId, nodeId);
        }
    }

    @Override
    public void nodeAttributeAdded(String graphId, long timeId, String nodeId, String attribute, Object value) throws RemoteException {
        for (AttributeSink gal : this.attributesListeners) {
            gal.nodeAttributeAdded(graphId, timeId, nodeId, attribute, value);
        }
    }

    @Override
    public void nodeAttributeChanged(String graphId, long timeId, String nodeId, String attribute, Object oldValue, Object newValue) throws RemoteException {
        for (AttributeSink gal : this.attributesListeners) {
            gal.nodeAttributeChanged(graphId, timeId, nodeId, attribute, oldValue, newValue);
        }
    }

    @Override
    public void nodeAttributeRemoved(String graphId, long timeId, String nodeId, String attribute) throws RemoteException {
        for (AttributeSink gal : this.attributesListeners) {
            gal.nodeAttributeRemoved(graphId, timeId, nodeId, attribute);
        }
    }

    @Override
    public void nodeRemoved(String graphId, long timeId, String nodeId) throws RemoteException {
        for (ElementSink gel : this.elementsListeners) {
            gel.nodeRemoved(graphId, timeId, nodeId);
        }
    }

    @Override
    public void stepBegins(String graphId, long timeId, double step) throws RemoteException {
        for (ElementSink gel : this.elementsListeners) {
            gel.stepBegins(graphId, timeId, step);
        }
    }

    @Override
    public void addAttributeSink(AttributeSink listener) {
        this.attributesListeners.add(listener);
    }

    @Override
    public void addElementSink(ElementSink listener) {
        this.elementsListeners.add(listener);
    }

    @Override
    public void addSink(Sink listener) {
        this.attributesListeners.add(listener);
        this.elementsListeners.add(listener);
    }

    @Override
    public void removeAttributeSink(AttributeSink listener) {
        this.attributesListeners.remove(listener);
    }

    @Override
    public void removeElementSink(ElementSink listener) {
        this.elementsListeners.remove(listener);
    }

    @Override
    public void removeSink(Sink listener) {
        this.attributesListeners.remove(listener);
        this.elementsListeners.remove(listener);
    }

    @Override
    public void clearAttributeSinks() {
        this.attributesListeners.clear();
        this.elementsListeners.clear();
    }

    @Override
    public void clearElementSinks() {
        this.elementsListeners.clear();
    }

    @Override
    public void clearSinks() {
        this.attributesListeners.clear();
    }
}

