/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.view.camera;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Node;
import org.graphstream.ui.geom.Point3;
import org.graphstream.ui.graphicGraph.GraphicEdge;
import org.graphstream.ui.graphicGraph.GraphicElement;
import org.graphstream.ui.graphicGraph.GraphicGraph;
import org.graphstream.ui.graphicGraph.GraphicNode;
import org.graphstream.ui.graphicGraph.GraphicSprite;
import org.graphstream.ui.graphicGraph.stylesheet.Selector;
import org.graphstream.ui.graphicGraph.stylesheet.StyleConstants;
import org.graphstream.ui.graphicGraph.stylesheet.Values;
import org.graphstream.ui.view.camera.AreaSkeleton;
import org.graphstream.ui.view.camera.Backend;
import org.graphstream.ui.view.camera.Camera;
import org.graphstream.ui.view.camera.ConnectorSkeleton;
import org.graphstream.ui.view.util.GraphMetrics;
import org.graphstream.ui.view.util.InteractiveElement;

public class DefaultCamera2D
implements Camera {
    protected GraphMetrics metrics = new GraphMetrics();
    protected boolean autoFit = true;
    protected Point3 center = new Point3();
    protected double zoom = 1.0;
    protected double rotation = 0.0;
    protected Values padding = new Values(StyleConstants.Units.GU, 0.0, 0.0, 0.0);
    protected Backend bckSwing = null;
    protected Backend bckUhd = null;
    protected HashSet<String> nodeInvisible = new HashSet();
    protected HashSet<String> spriteInvisible = new HashSet();
    protected double[] gviewport = null;
    protected GraphicGraph graph;

    public DefaultCamera2D(GraphicGraph graph) {
        this.graph = graph;
    }

    @Override
    public Point3 getViewCenter() {
        return this.center;
    }

    @Override
    public void setViewCenter(double x, double y, double z) {
        this.setAutoFitView(false);
        this.center.set(x, y, z);
        this.graph.graphChanged = true;
    }

    public void setViewCenter(Point3 p) {
        this.setViewCenter(p.x, p.y, p.z);
    }

    @Override
    public double getViewPercent() {
        return this.zoom;
    }

    @Override
    public void setViewPercent(double percent) {
        this.setAutoFitView(false);
        this.setZoom(percent);
        this.graph.graphChanged = true;
    }

    public void setZoom(double z) {
        this.zoom = z;
        this.graph.graphChanged = true;
    }

    @Override
    public double getViewRotation() {
        return this.rotation;
    }

    @Override
    public void setViewRotation(double theta) {
        this.rotation = theta;
        this.graph.graphChanged = true;
    }

    public void setViewport(double x, double y, double viewportWidth, double viewportHeight) {
        this.metrics.setViewport(x, y, viewportWidth, viewportHeight);
    }

    @Override
    public double getGraphDimension() {
        return this.metrics.getDiagonal();
    }

    public boolean spriteContains(GraphicElement elt, double x, double y) {
        double w2;
        GraphicSprite sprite = (GraphicSprite)elt;
        Values size = this.getNodeOrSpriteSize(elt);
        double h2 = w2 = this.metrics.lengthToPx(size, 0) / 2.0;
        if (size.size() > 1) {
            h2 = this.metrics.lengthToPx(size, 1) / 2.0;
        }
        Point3 dst = this.spritePositionPx(sprite);
        double x1 = dst.x - w2;
        double x2 = dst.x + w2;
        double y1 = dst.y - h2;
        double y2 = dst.y + h2;
        if (x < x1) {
            return false;
        }
        if (y < y1) {
            return false;
        }
        if (x > x2) {
            return false;
        }
        return !(y > y2);
    }

    public Point3 spritePositionPx(GraphicSprite sprite) {
        return this.getSpritePosition(sprite, new Point3(), StyleConstants.Units.PX);
    }

    public Point3 getSpritePosition(GraphicSprite sprite, Point3 pos, StyleConstants.Units units) {
        if (sprite.isAttachedToNode()) {
            return this.getSpritePositionNode(sprite, pos, units);
        }
        if (sprite.isAttachedToEdge()) {
            return this.getSpritePositionEdge(sprite, pos, units);
        }
        return this.getSpritePositionFree(sprite, pos, units);
    }

    public Point3 getSpritePositionFree(GraphicSprite sprite, Point3 position, StyleConstants.Units units) {
        Point3 pos = position;
        if (pos == null) {
            pos = new Point3();
        }
        if (sprite.getUnits() == units) {
            pos.x = sprite.getX();
            pos.y = sprite.getY();
        } else if (units == StyleConstants.Units.GU && sprite.getUnits() == StyleConstants.Units.PX) {
            pos.x = sprite.getX();
            pos.y = sprite.getY();
            this.bckSwing.inverseTransform(pos);
        } else if (units == StyleConstants.Units.PX && sprite.getUnits() == StyleConstants.Units.GU) {
            pos.x = sprite.getX();
            pos.y = sprite.getY();
            this.bckSwing.transform(pos);
        } else if (units == StyleConstants.Units.GU && sprite.getUnits() == StyleConstants.Units.PERCENTS) {
            pos.x = this.metrics.lo.x + sprite.getX() / 100.0 * this.metrics.graphWidthGU();
            pos.y = this.metrics.lo.y + sprite.getY() / 100.0 * this.metrics.graphHeightGU();
        } else if (units == StyleConstants.Units.PX && sprite.getUnits() == StyleConstants.Units.PERCENTS) {
            pos.x = sprite.getX() / 100.0 * this.metrics.viewport[2];
            pos.y = sprite.getY() / 100.0 * this.metrics.viewport[3];
        } else {
            throw new RuntimeException("Unhandled yet sprite positioning convertion " + (Object)((Object)sprite.getUnits()) + " to " + (Object)((Object)units) + ".");
        }
        return pos;
    }

    public Point3 getSpritePositionEdge(GraphicSprite sprite, Point3 position, StyleConstants.Units units) {
        GraphicEdge edge;
        ConnectorSkeleton info;
        Point3 pos = position;
        if (pos == null) {
            pos = new Point3();
        }
        if ((info = (ConnectorSkeleton)(edge = sprite.getEdgeAttachment()).getAttribute("ui.j2dsk")) != null) {
            double o = this.metrics.lengthToGu(sprite.getY(), sprite.getUnits());
            if (o == 0.0) {
                Point3 p = info.pointOnShape(sprite.getX());
                pos.x = p.x;
                pos.y = p.y;
            } else {
                Point3 p = info.pointOnShapeAndPerpendicular(sprite.getX(), o);
                pos.x = p.x;
                pos.y = p.y;
            }
        } else {
            double x = 0.0;
            double y = 0.0;
            double dx = 0.0;
            double dy = 0.0;
            double d = sprite.getX();
            double o = this.metrics.lengthToGu(sprite.getY(), sprite.getUnits());
            x = edge.from.x;
            y = edge.from.y;
            dx = edge.to.x - x;
            dy = edge.to.y - y;
            if (d > 1.0) {
                d = 1.0;
            }
            if (d < 0.0) {
                d = 0.0;
            }
            x += dx * d;
            x += dy * d;
            if (o != 0.0) {
                d = Math.sqrt(dx * dx + dy * dy);
                x += -(dy /= d) * o;
                y += (dx /= d) * o;
            }
            pos.x = x;
            pos.y = y;
        }
        if (units == StyleConstants.Units.PX) {
            this.bckSwing.transform(pos);
        }
        return pos;
    }

    public Point3 getSpritePositionNode(GraphicSprite sprite, Point3 position, StyleConstants.Units units) {
        Point3 pos = position;
        if (pos == null) {
            pos = new Point3();
        }
        double spriteX = this.metrics.lengthToGu(sprite.getX(), sprite.getUnits());
        double spriteY = this.metrics.lengthToGu(sprite.getY(), sprite.getUnits());
        GraphicNode node = sprite.getNodeAttachment();
        pos.x = node.x + spriteX;
        pos.y = node.y + spriteY;
        if (units == StyleConstants.Units.PX) {
            this.bckSwing.transform(pos);
        }
        return pos;
    }

    public boolean nodeContains(GraphicElement elt, double x, double y) {
        double w2;
        Values size = this.getNodeOrSpriteSize(elt);
        double h2 = w2 = this.metrics.lengthToPx(size, 0) / 2.0;
        if (size.size() > 1) {
            h2 = this.metrics.lengthToPx(size, 1) / 2.0;
        }
        Point3 dst = this.bckSwing.transform(elt.getX(), elt.getY(), 0.0);
        double x1 = dst.x - w2;
        double x2 = dst.x + w2;
        double y1 = dst.y - h2;
        double y2 = dst.y + h2;
        if (x < x1) {
            return false;
        }
        if (y < y1) {
            return false;
        }
        if (x > x2) {
            return false;
        }
        return !(y > y2);
    }

    public boolean edgeContains(GraphicElement elt, double x, double y) {
        double w2;
        Values size = elt.getStyle().getSize();
        double h2 = w2 = this.metrics.lengthToPx(size, 0) / 2.0;
        if (size.size() > 1) {
            h2 = this.metrics.lengthToPx(size, 1) / 2.0;
        }
        Point3 dst = this.bckSwing.transform(elt.getX(), elt.getY(), 0.0);
        double x1 = dst.x - w2;
        double x2 = dst.x + w2;
        double y1 = dst.y - h2;
        double y2 = dst.y + h2;
        if (x < x1) {
            return false;
        }
        if (y < y1) {
            return false;
        }
        if (x > x2) {
            return false;
        }
        return !(y > y2);
    }

    public Values getNodeOrSpriteSize(GraphicElement elt) {
        AreaSkeleton info = (AreaSkeleton)elt.getAttribute("ui.j2dsk");
        if (info != null) {
            return new Values(StyleConstants.Units.GU, info.theSize().x, info.theSize().y);
        }
        return elt.getStyle().getSize();
    }

    public Point3 getNodeOrSpritePositionGU(GraphicElement elt, Point3 pos) {
        Point3 p = pos;
        if (p == null) {
            p = new Point3();
        }
        if (elt instanceof GraphicNode) {
            p.x = ((GraphicNode)elt).getX();
            p.y = ((GraphicNode)elt).getY();
        } else if (elt instanceof GraphicSprite) {
            p = this.getSpritePosition((GraphicSprite)elt, p, StyleConstants.Units.GU);
        }
        return p;
    }

    @Override
    public void removeGraphViewport() {
        this.gviewport = null;
    }

    @Override
    public void setGraphViewport(double minx, double miny, double maxx, double maxy) {
        this.gviewport = new double[4];
        this.gviewport[0] = minx;
        this.gviewport[1] = miny;
        this.gviewport[2] = maxx;
        this.gviewport[3] = maxy;
    }

    @Override
    public void resetView() {
        this.setAutoFitView(true);
        this.setViewRotation(0.0);
    }

    public void pushView(GraphicGraph graph) {
        this.bckSwing.pushTransform();
        this.bckUhd.pushTransform();
        this.setPadding(graph);
        if (this.autoFit) {
            this.autoFitView();
        } else {
            this.userView();
        }
        this.checkVisibility(graph);
    }

    public void popView() {
        this.bckSwing.popTransform();
        this.bckUhd.popTransform();
    }

    public void checkVisibility(GraphicGraph graph) {
        this.nodeInvisible.clear();
        this.spriteInvisible.clear();
        if (!this.autoFit) {
            double X = this.metrics.viewport[0];
            double Y = this.metrics.viewport[1];
            double W = this.metrics.viewport[2];
            double H = this.metrics.viewport[3];
            graph.nodes().forEach(node -> {
                boolean visible;
                GraphicNode n = (GraphicNode)node;
                boolean bl = visible = this.isNodeIn(n, X, Y, X + W, Y + H) && !n.hidden && n.positionned;
                if (!visible) {
                    this.nodeInvisible.add(node.getId());
                }
            });
            graph.sprites().forEach(sprite -> {
                boolean visible;
                boolean bl = visible = this.isSpriteIn((GraphicSprite)sprite, X, Y, X + W, Y + H) && !sprite.hidden;
                if (!visible) {
                    this.spriteInvisible.add(sprite.getId());
                }
            });
        }
    }

    public boolean isNodeIn(GraphicNode node, double X1, double Y1, double X2, double Y2) {
        double w2;
        Values size = this.getNodeOrSpriteSize(node);
        double h2 = w2 = this.metrics.lengthToPx(size, 0) / 2.0;
        if (size.size() > 1) {
            h2 = this.metrics.lengthToPx(size, 1) / 2.0;
        }
        Point3 src = new Point3(node.getX(), node.getY(), 0.0);
        this.bckSwing.transform(src);
        double x1 = src.x - w2;
        double x2 = src.x + w2;
        double y1 = src.y - h2;
        double y2 = src.y + h2;
        if (x2 < X1) {
            return false;
        }
        if (y2 < Y1) {
            return false;
        }
        if (x1 > X2) {
            return false;
        }
        return !(y1 > Y2);
    }

    public boolean isEdgeIn(GraphicEdge edge, double X1, double Y1, double X2, double Y2) {
        double w2;
        Values size = edge.getStyle().getSize();
        double h2 = w2 = this.metrics.lengthToPx(size, 0) / 2.0;
        if (size.size() > 1) {
            h2 = this.metrics.lengthToPx(size, 1) / 2.0;
        }
        Point3 src = new Point3(edge.getX(), edge.getY(), 0.0);
        this.bckSwing.transform(src);
        double x1 = src.x - w2;
        double x2 = src.x + w2;
        double y1 = src.y - h2;
        double y2 = src.y + h2;
        if (x2 < X1) {
            return false;
        }
        if (y2 < Y1) {
            return false;
        }
        if (x1 > X2) {
            return false;
        }
        return !(y1 > Y2);
    }

    public void setPadding(GraphicGraph graph) {
        this.padding.copy(graph.getStyle().getPadding());
    }

    public void autoFitView() {
        double sx = 0.0;
        double sy = 0.0;
        double tx = 0.0;
        double ty = 0.0;
        double padXgu = this.paddingXgu() * 2.0;
        double padYgu = this.paddingYgu() * 2.0;
        double padXpx = this.paddingXpx() * 2.0;
        double padYpx = this.paddingYpx() * 2.0;
        if (padXpx > this.metrics.viewport[2]) {
            padXpx = this.metrics.viewport[2] / 10.0;
        }
        if (padYpx > this.metrics.viewport[3]) {
            padYpx = this.metrics.viewport[3] / 10.0;
        }
        sx = (this.metrics.viewport[2] - padXpx) / (this.metrics.size.data[0] + padXgu);
        sy = (this.metrics.viewport[3] - padYpx) / (this.metrics.size.data[1] + padYgu);
        tx = this.metrics.lo.x + this.metrics.size.data[0] / 2.0;
        ty = this.metrics.lo.y + this.metrics.size.data[1] / 2.0;
        if (sx > sy) {
            sx = sy;
        } else {
            sy = sx;
        }
        this.prepareTransformationMatrix(this.bckSwing, sx, sy, tx, ty);
        this.prepareTransformationMatrix(this.bckUhd, sx, sy, tx, ty);
        this.zoom = 1.0;
        this.center.set(tx, ty, 0.0);
        this.metrics.ratioPx2Gu = sx;
        this.metrics.loVisible.copy(this.metrics.lo);
        this.metrics.hiVisible.copy(this.metrics.hi);
    }

    public void userView() {
        double sx = 0.0;
        double sy = 0.0;
        double tx = 0.0;
        double ty = 0.0;
        double padXgu = this.paddingXgu() * 2.0;
        double padYgu = this.paddingYgu() * 2.0;
        double padXpx = this.paddingXpx() * 2.0;
        double padYpx = this.paddingYpx() * 2.0;
        double gw = this.gviewport != null ? this.gviewport[2] - this.gviewport[0] : this.metrics.size.data[0];
        double gh = this.gviewport != null ? this.gviewport[3] - this.gviewport[1] : this.metrics.size.data[1];
        if (padXpx > this.metrics.viewport[2]) {
            padXpx = this.metrics.viewport[2] / 10.0;
        }
        if (padYpx > this.metrics.viewport[3]) {
            padYpx = this.metrics.viewport[3] / 10.0;
        }
        sx = (this.metrics.viewport[2] - padXpx) / ((gw + padXgu) * this.zoom);
        sy = (this.metrics.viewport[3] - padYpx) / ((gh + padYgu) * this.zoom);
        tx = this.center.x;
        ty = this.center.y;
        if (sx > sy) {
            sx = sy;
        } else {
            sy = sx;
        }
        this.prepareTransformationMatrix(this.bckSwing, sx, sy, tx, ty);
        this.prepareTransformationMatrix(this.bckUhd, sx, sy, tx, ty);
        this.metrics.ratioPx2Gu = sx;
        double w2 = this.metrics.viewport[2] / sx / 2.0;
        double h2 = this.metrics.viewport[3] / sx / 2.0;
        this.metrics.loVisible.set(this.center.x - w2, this.center.y - h2);
        this.metrics.hiVisible.set(this.center.x + w2, this.center.y + h2);
    }

    private void prepareTransformationMatrix(Backend bck, double sx, double sy, double tx, double ty) {
        bck.beginTransform();
        bck.setIdentity();
        bck.translate(this.metrics.viewport[2] / 2.0, this.metrics.viewport[3] / 2.0, 0.0);
        if (this.rotation != 0.0) {
            bck.rotate(this.rotation / 57.29577951308232, 0.0, 0.0, 1.0);
        }
        bck.scale(sx, -sy, 0.0);
        bck.translate(-tx, -ty, 0.0);
        bck.endTransform();
    }

    public double paddingXgu() {
        if (this.padding.units == StyleConstants.Units.GU && this.padding.size() > 0) {
            return this.padding.get(0);
        }
        return 0.0;
    }

    public double paddingYgu() {
        if (this.padding.units == StyleConstants.Units.GU && this.padding.size() > 1) {
            return this.padding.get(1);
        }
        return this.paddingXgu();
    }

    public double paddingXpx() {
        if (this.padding.units == StyleConstants.Units.PX && this.padding.size() > 0) {
            return this.padding.get(0);
        }
        return 0.0;
    }

    public double paddingYpx() {
        if (this.padding.units == StyleConstants.Units.PX && this.padding.size() > 1) {
            return this.padding.get(1);
        }
        return this.paddingXpx();
    }

    @Override
    public void setBounds(double minx, double miny, double minz, double maxx, double maxy, double maxz) {
        this.metrics.setBounds(minx, miny, minz, maxx, maxy, maxz);
    }

    public void setBounds(GraphicGraph graph) {
        this.setBounds(graph.getMinPos().x, graph.getMinPos().y, 0.0, graph.getMaxPos().x, graph.getMaxPos().y, 0.0);
    }

    @Override
    public GraphMetrics getMetrics() {
        return this.metrics;
    }

    @Override
    public void setAutoFitView(boolean on) {
        if (this.autoFit && !on) {
            this.zoom = 1.0;
            this.center.set(this.metrics.lo.x + this.metrics.size.data[0] / 2.0, this.metrics.lo.y + this.metrics.size.data[1] / 2.0, 0.0);
        }
        this.autoFit = on;
    }

    public void setSwingBackend(Backend backend) {
        this.bckSwing = backend;
    }

    public void setUhdBackend(Backend backend) {
        this.bckUhd = backend;
    }

    @Override
    public Point3 transformGuToPx(double x, double y, double z) {
        return this.bckUhd.transform(x, y, 0.0);
    }

    public Point3 transformGuToPxSwing(double x, double y, double z) {
        return this.bckSwing.transform(x, y, 0.0);
    }

    @Override
    public Point3 transformPxToGu(double x, double y) {
        return this.bckUhd.inverseTransform(x, y, 0.0);
    }

    public Point3 transformPxToGuSwing(double x, double y) {
        return this.bckSwing.inverseTransform(x, y, 0.0);
    }

    protected boolean styleVisible(GraphicElement element) {
        Values visibility = element.getStyle().getVisibility();
        switch (element.getStyle().getVisibilityMode()) {
            case HIDDEN: {
                return false;
            }
            case AT_ZOOM: {
                return this.zoom == visibility.get(0);
            }
            case UNDER_ZOOM: {
                return this.zoom <= visibility.get(0);
            }
            case OVER_ZOOM: {
                return this.zoom >= visibility.get(0);
            }
            case ZOOM_RANGE: {
                if (visibility.size() > 1) {
                    return this.zoom >= visibility.get(0) && this.zoom <= visibility.get(1);
                }
                return true;
            }
            case ZOOMS: {
                return Arrays.asList(Selector.Type.values()).contains(visibility.get(0));
            }
        }
        return true;
    }

    public boolean isTextVisible(GraphicElement element) {
        Values visibility = element.getStyle().getTextVisibility();
        switch (element.getStyle().getTextVisibilityMode()) {
            case HIDDEN: {
                return false;
            }
            case AT_ZOOM: {
                return this.zoom == visibility.get(0);
            }
            case UNDER_ZOOM: {
                return this.zoom <= visibility.get(0);
            }
            case OVER_ZOOM: {
                return this.zoom >= visibility.get(0);
            }
            case ZOOM_RANGE: {
                if (visibility.size() > 1) {
                    return this.zoom >= visibility.get(0) && this.zoom <= visibility.get(1);
                }
                return true;
            }
            case ZOOMS: {
                return Arrays.asList(Selector.Type.values()).contains(visibility.get(0));
            }
        }
        return true;
    }

    @Override
    public boolean isVisible(GraphicElement element) {
        if (this.autoFit) {
            return !element.hidden && element.style.getVisibilityMode() != StyleConstants.VisibilityMode.HIDDEN;
        }
        switch (element.getSelectorType()) {
            case NODE: {
                return !this.nodeInvisible.contains(element.getId());
            }
            case EDGE: {
                return this.isEdgeVisible((GraphicEdge)element);
            }
            case SPRITE: {
                return !this.spriteInvisible.contains(element.getId());
            }
        }
        return false;
    }

    public boolean isSpriteVisible(GraphicSprite sprite) {
        return this.isSpriteIn(sprite, 0.0, 0.0, this.metrics.viewport[2], this.metrics.viewport[3]);
    }

    public boolean isSpriteIn(GraphicSprite sprite, double X1, double Y1, double X2, double Y2) {
        double w2;
        Values size = this.getNodeOrSpriteSize(sprite);
        double h2 = w2 = this.metrics.lengthToPx(size, 0) / 2.0;
        if (size.size() > 1) {
            h2 = this.metrics.lengthToPx(size, 1) / 2.0;
        }
        Point3 src = this.spritePositionPx(sprite);
        double x1 = src.x - w2;
        double x2 = src.x + w2;
        double y1 = src.y - h2;
        double y2 = src.y + h2;
        if (x2 < X1) {
            return false;
        }
        if (y2 < Y1) {
            return false;
        }
        if (x1 > X2) {
            return false;
        }
        return !(y1 > Y2);
    }

    public boolean isEdgeVisible(GraphicEdge edge) {
        if (!((GraphicNode)edge.getNode0()).positionned || !((GraphicNode)edge.getNode1()).positionned) {
            return false;
        }
        if (edge.hidden) {
            return false;
        }
        boolean node0Invis = this.nodeInvisible.contains(edge.getNode0().getId());
        boolean node1Invis = this.nodeInvisible.contains(edge.getNode1().getId());
        return !node0Invis || !node1Invis;
    }

    @Override
    public GraphicElement findGraphicElementAt(GraphicGraph graph, EnumSet<InteractiveElement> types, double x, double y) {
        Optional<GraphicSprite> sprite;
        Optional<Edge> edge;
        Optional<Node> node;
        double xT = x + this.metrics.viewport[0];
        double yT = y + this.metrics.viewport[1];
        if (types.contains((Object)InteractiveElement.NODE) && (node = graph.nodes().filter(n -> this.nodeContains((GraphicElement)((Object)n), xT, yT)).findFirst()).isPresent() && this.isVisible((GraphicElement)((Object)node.get()))) {
            return (GraphicElement)((Object)node.get());
        }
        if (types.contains((Object)InteractiveElement.EDGE) && (edge = graph.edges().filter(e -> this.edgeContains((GraphicElement)((Object)e), xT, yT)).findFirst()).isPresent() && this.isVisible((GraphicElement)((Object)edge.get()))) {
            return (GraphicElement)((Object)edge.get());
        }
        if (types.contains((Object)InteractiveElement.SPRITE) && (sprite = graph.sprites().filter(s -> this.spriteContains((GraphicElement)s, xT, yT)).findFirst()).isPresent() && this.isVisible(sprite.get())) {
            return sprite.get();
        }
        return null;
    }

    public double[] graphViewport() {
        return this.gviewport;
    }

    @Override
    public Collection<GraphicElement> allGraphicElementsIn(GraphicGraph graph, EnumSet<InteractiveElement> types, double x1, double y1, double x2, double y2) {
        double x1T = x1 + this.metrics.viewport[0];
        double y1T = y1 + this.metrics.viewport[1];
        double x2T = x2 + this.metrics.viewport[0];
        double y2T = y2 + this.metrics.viewport[1];
        ArrayList elts = new ArrayList();
        Stream<Object> nodeStream = null;
        Stream<Object> edgeStream = null;
        Stream<Object> spriteStream = null;
        nodeStream = types.contains((Object)InteractiveElement.NODE) ? graph.nodes().filter(n -> this.isNodeIn((GraphicNode)n, x1T, y1T, x2T, y2T)) : Stream.empty();
        edgeStream = types.contains((Object)InteractiveElement.EDGE) ? graph.edges().filter(e -> this.isEdgeIn((GraphicEdge)e, x1T, y1T, x2T, y2T)) : Stream.empty();
        spriteStream = types.contains((Object)InteractiveElement.SPRITE) ? graph.sprites().filter(e -> this.isSpriteIn((GraphicSprite)e, x1T, y1T, x2T, y2T)) : Stream.empty();
        Stream s = Stream.concat(nodeStream, Stream.concat(edgeStream, spriteStream));
        return s.collect(Collectors.toList());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(String.format("Camera :%n", new Object[0]));
        builder.append(String.format("    autoFit  = %b%n", this.autoFit));
        builder.append(String.format("    center   = %s%n", this.center));
        builder.append(String.format("    rotation = %f%n", this.rotation));
        builder.append(String.format("    zoom     = %f%n", this.zoom));
        builder.append(String.format("    padding  = %s%n", this.padding));
        builder.append(String.format("    metrics  = %s%n", this.metrics));
        return builder.toString();
    }
}

