/*
 * Decompiled with CFR 0.152.
 */
package org.miv.pherd.ntree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.miv.pherd.Particle;
import org.miv.pherd.geom.Point3;
import org.miv.pherd.ntree.CellData;
import org.miv.pherd.ntree.CellSpace;
import org.miv.pherd.ntree.NTree;
import org.miv.pherd.ntree.NTreeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cell {
    protected String id;
    protected NTree tree;
    protected int depth;
    protected int index;
    protected Cell parent;
    protected Cell[] sub;
    protected CellSpace space;
    protected CellData data;
    protected HashMap<Object, Particle> particles = new HashMap();
    protected int population;

    public Cell(NTree tree, CellSpace space, String id, CellData data) {
        this.id = id;
        this.tree = tree;
        this.depth = 0;
        this.space = space;
        this.data = data;
        if (data != null) {
            data.setCell(this);
        }
        for (NTreeListener listener : tree.listeners) {
            listener.cellAdded(id, "", space.lo, space.hi, this.depth, this.index);
        }
    }

    protected Cell(Cell parent, int index, CellSpace space, CellData data) {
        this.tree = parent.tree;
        this.id = this.tree.generateCellIdentifier(parent, index);
        this.parent = parent;
        this.depth = parent.depth + 1;
        this.index = index;
        this.space = space;
        this.data = data;
        if (data != null) {
            data.setCell(this);
        }
        for (NTreeListener listener : this.tree.listeners) {
            listener.cellAdded(this.id, parent.id, space.lo, space.hi, this.depth, index);
        }
    }

    public NTree getTree() {
        return this.tree;
    }

    public String getId() {
        return this.id;
    }

    public boolean isLeaf() {
        return this.sub == null;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public int getPopulation() {
        return this.population;
    }

    public Cell getParent() {
        return this.parent;
    }

    public Cell getSub(int i) {
        if (this.sub != null) {
            return this.sub[i];
        }
        return null;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getIndex() {
        return this.index;
    }

    public CellSpace getSpace() {
        return this.space;
    }

    public CellData getData() {
        return this.data;
    }

    public Iterator<? extends Particle> getParticles() {
        if (this.isLeaf()) {
            return this.particles.values().iterator();
        }
        return null;
    }

    public boolean contains(Particle particle) {
        return this.space.contains(particle);
    }

    public boolean contains(double x, double y, double z) {
        return this.space.contains(x, y, z);
    }

    public boolean hasParticle(Particle particle) {
        return this.particles.get(particle.getId()) != null;
    }

    public void addParticle(Particle particle) {
        ++this.population;
        if (!this.isLeaf()) {
            int k = 0;
            for (int i = 0; i < this.sub.length; ++i) {
                if (!this.sub[i].contains(particle)) continue;
                if (k == 0) {
                    this.sub[i].addParticle(particle);
                }
                ++k;
            }
            assert (k == 1) : "no subcell or too many subcells (" + k + ") found to add particle " + particle.getId();
        } else {
            Particle old = this.particles.put(particle.getId(), particle);
            particle.setCell(this);
            assert (old == null) : "Particle ID " + particle.getId() + " added in the cell already exists.";
            assert (this.population == this.particles.size()) : "Discepancy in population count of " + this.id + " ? (population=" + this.population + " p.size=" + this.particles.size() + ")";
        }
    }

    public void removeParticle(Object id) {
        --this.population;
        if (this.isLeaf()) {
            Particle p = this.particles.remove(id);
            assert (p != null) : "particle " + id + " wrongly removed?";
            assert (this.population == this.particles.size()) : "discrepancy between the population " + this.population + " and set of particles " + this.particles.size();
            p.setCell(null);
        }
        if (!this.isRoot()) {
            this.parent.removeParticle(this.id);
        }
    }

    public void particleMoved(Particle particle) {
        assert (this.isLeaf()) : "particle moved event in non-leaf cell " + this.id + " ?";
        if (!this.contains(particle)) {
            if (this.tree.laMama.contains(particle)) {
                this.removeParticle(particle.getId());
                this.tree.laMama.addParticle(particle);
            } else {
                this.tree.handleOutParticle(particle);
            }
        }
    }

    public void recompute() {
        if (this.isLeaf()) {
            assert (this.population == this.particles.size()) : "Discepancy in population count of " + this.id + " ? (population=" + this.population + " p.size=" + this.particles.size() + ")";
            if (this.depth < this.tree.depthmax && this.population > this.tree.pmax) {
                this.mitosis();
                for (Cell cell : this.sub) {
                    cell.recompute();
                }
            }
        } else {
            int hasLeafs = 0;
            int divs = this.space.getDivisions();
            for (Cell cell : this.sub) {
                cell.recompute();
                hasLeafs += cell.isLeaf() ? 1 : 0;
            }
            if (hasLeafs == divs && this.population <= this.tree.pmax) {
                this.fusion();
            }
        }
        if (this.data != null) {
            this.data.recompute();
        }
    }

    protected void mitosis() {
        assert (this.sub == null) : "sub should be null here";
        assert (this.particles.size() > this.tree.pmax) : "no subdivision needed ?";
        int div = this.space.getDivisions();
        this.sub = new Cell[div];
        for (int i = 0; i < div; ++i) {
            this.sub[i] = new Cell(this, i, this.space.newSubCellSpace(i), this.data != null ? this.data.newCellData() : null);
            Iterator<Particle> k = this.particles.values().iterator();
            while (k.hasNext()) {
                Particle p = k.next();
                if (!this.sub[i].contains(p)) continue;
                k.remove();
                this.sub[i].addParticle(p);
            }
        }
        assert (this.particles.size() == 0) : "there are " + this.particles.size() + " unclassified particles after mitosis ?";
    }

    protected void fusion() {
        assert (this.particles.size() == 0);
        for (Cell cell : this.sub) {
            assert (cell.isLeaf()) : "Fusion of non leaf-subcells !!";
            this.particles.putAll(cell.particles);
            for (NTreeListener listener : this.tree.listeners) {
                listener.cellRemoved(cell.id);
            }
        }
        this.sub = null;
        for (Particle particle : this.particles.values()) {
            particle.setCell(this);
        }
    }

    protected void describe(NTreeListener listener) {
        String parentId = "";
        if (this.parent != null) {
            parentId = this.parent.id;
        }
        listener.cellAdded(this.id, parentId, this.space.lo, this.space.hi, this.depth, this.index);
        if (this.sub != null) {
            for (Cell cell : this.sub) {
                cell.describe(listener);
            }
        }
    }

    protected void resize(Point3 min, Point3 max) {
        if (this.parent != null) {
            throw new RuntimeException("can only resize the root cell");
        }
        ArrayList<Particle> particles = new ArrayList<Particle>();
        Iterator<Object> k = this.tree.pbox.getParticleIdIterator();
        int oldPop = this.population;
        while (k.hasNext()) {
            Object id = k.next();
            particles.add(this.tree.pbox.getParticle(id));
        }
        this.tree.pbox.removeAllParticles();
        assert (this.population == 0) : "after removal of all particles the root cell still contains " + this.population + " particles...";
        assert (this.particles.size() == 0) : "after removal of all particles the root cell still contains " + this.particles.size() + " particles...";
        this.recompute();
        for (NTreeListener listener : this.tree.listeners) {
            listener.cellRemoved(this.id);
        }
        assert (this.isLeaf()) : "after particles removal the mama cell should be root and leaf";
        this.space.resize(min, max);
        for (NTreeListener listener : this.tree.listeners) {
            listener.cellAdded(this.id, "", this.space.lo, this.space.hi, this.depth, this.index);
        }
        for (Particle particle : particles) {
            this.tree.pbox.addParticle(particle);
        }
        this.recompute();
        assert (this.population == this.tree.pbox.getParticleCount()) : "discrepancy when resinserting particles during mama resize";
        assert (this.population == oldPop) : "after resize new population size != old (" + this.population + " != " + oldPop + ")";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[Cell ");
        sb.append(this.id);
        sb.append(" depth=");
        sb.append(this.depth);
        sb.append(" pop=");
        sb.append(this.population);
        if (this.isLeaf()) {
            sb.append(" L");
        }
        if (this.isRoot()) {
            sb.append(" R");
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean isValid() {
        int div = this.space.getDivisions();
        int pop = 0;
        if (!this.isLeaf()) {
            if (div != this.sub.length) {
                return false;
            }
            for (int i = 0; i < div; ++i) {
                if (!this.sub[i].isValid()) {
                    return false;
                }
                pop += this.sub[i].getPopulation();
                if (this.sub[i].depth == this.depth + 1) continue;
                return false;
            }
            if (pop != this.getPopulation()) {
                return false;
            }
        }
        return true;
    }
}

