/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.graph.implementations;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graphstream.graph.Edge;
import org.graphstream.graph.EdgeFactory;
import org.graphstream.graph.EdgeRejectedException;
import org.graphstream.graph.Element;
import org.graphstream.graph.ElementNotFoundException;
import org.graphstream.graph.Graph;
import org.graphstream.graph.IdAlreadyInUseException;
import org.graphstream.graph.Node;
import org.graphstream.graph.NodeFactory;
import org.graphstream.graph.implementations.AdjacencyListGraph;
import org.graphstream.graph.implementations.DefaultGraph;
import org.graphstream.graph.implementations.MultiGraph;
import org.graphstream.stream.AttributeSink;
import org.graphstream.stream.ElementSink;
import org.graphstream.stream.GraphParseException;
import org.graphstream.stream.GraphReplay;
import org.graphstream.stream.Sink;
import org.graphstream.stream.file.FileSink;
import org.graphstream.stream.file.FileSource;
import org.graphstream.ui.view.Viewer;

public class Graphs {
    private static final Logger logger = Logger.getLogger(Graphs.class.getSimpleName());

    public static Graph unmutableGraph(Graph g) {
        return null;
    }

    public static Graph synchronizedGraph(Graph g) {
        return new SynchronizedGraph(g);
    }

    public static Graph merge(Graph ... graphs) {
        Graph result;
        if (graphs == null) {
            return new DefaultGraph("void-merge");
        }
        String id = "merge";
        for (Graph g : graphs) {
            id = id + "-" + g.getId();
        }
        try {
            Class<?> cls = graphs[0].getClass();
            result = (Graph)cls.getConstructor(String.class).newInstance(id);
        }
        catch (Exception e) {
            logger.warning(String.format("Cannot create a graph of %s.", graphs[0].getClass().getName()));
            result = new MultiGraph(id);
        }
        Graphs.mergeIn(result, graphs);
        return result;
    }

    public static void mergeIn(Graph result, Graph ... graphs) {
        boolean strict = result.isStrict();
        GraphReplay replay = new GraphReplay(String.format("replay-%x", System.nanoTime()));
        replay.addSink(result);
        result.setStrict(false);
        if (graphs != null) {
            for (Graph g : graphs) {
                replay.replay(g);
            }
        }
        replay.removeSink(result);
        result.setStrict(strict);
    }

    public static Graph clone(Graph g) {
        Element target;
        Element source;
        int i;
        Graph copy;
        try {
            Class<?> cls = g.getClass();
            copy = (Graph)cls.getConstructor(String.class).newInstance(g.getId());
        }
        catch (Exception e) {
            logger.warning(String.format("Cannot create a graph of %s.", g.getClass().getName()));
            copy = new AdjacencyListGraph(g.getId());
        }
        Graphs.copyAttributes(g, copy);
        for (i = 0; i < g.getNodeCount(); ++i) {
            source = g.getNode(i);
            target = copy.addNode(source.getId());
            Graphs.copyAttributes(source, target);
        }
        for (i = 0; i < g.getEdgeCount(); ++i) {
            source = g.getEdge(i);
            target = copy.addEdge(source.getId(), source.getSourceNode().getId(), source.getTargetNode().getId(), source.isDirected());
            Graphs.copyAttributes(source, target);
        }
        return copy;
    }

    public static void copyAttributes(Element source, Element target) {
        source.attributeKeys().forEach(key -> {
            Object value = source.getAttribute((String)key);
            value = Graphs.checkedArrayOrCollectionCopy(value);
            target.setAttribute((String)key, value);
        });
    }

    private static Object checkedArrayOrCollectionCopy(Object o) {
        if (o == null) {
            return null;
        }
        if (o.getClass().isArray()) {
            Object c = Array.newInstance(o.getClass().getComponentType(), Array.getLength(o));
            for (int i = 0; i < Array.getLength(o); ++i) {
                Object t = Graphs.checkedArrayOrCollectionCopy(Array.get(o, i));
                Array.set(c, i, t);
            }
            return c;
        }
        if (Collection.class.isAssignableFrom(o.getClass())) {
            try {
                Collection t = (Collection)o.getClass().newInstance();
                t.addAll((Collection)o);
                return t;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return o;
    }

    static class SynchronizedGraph
    extends SynchronizedElement<Graph>
    implements Graph {
        final ReentrantLock elementLock = new ReentrantLock();
        final Map<String, Node> synchronizedNodes;
        final Map<String, Edge> synchronizedEdges;

        SynchronizedGraph(Graph g) {
            super(g);
            this.synchronizedNodes = g.nodes().collect(Collectors.toMap(Element::getId, n -> new SynchronizedNode(this, (Node)n)));
            this.synchronizedEdges = g.edges().collect(Collectors.toMap(Element::getId, e -> new SynchronizedEdge(this, (Edge)e)));
        }

        @Override
        public Stream<Node> nodes() {
            Vector<Node> nodes;
            this.elementLock.lock();
            try {
                nodes = new Vector<Node>(this.synchronizedNodes.values());
            }
            finally {
                this.elementLock.unlock();
            }
            return nodes.stream();
        }

        @Override
        public Stream<Edge> edges() {
            Vector<Edge> edges;
            this.elementLock.lock();
            try {
                edges = new Vector<Edge>(this.synchronizedEdges.values());
            }
            finally {
                this.elementLock.unlock();
            }
            return edges.stream();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Edge addEdge(String id, String node1, String node2) throws IdAlreadyInUseException, ElementNotFoundException, EdgeRejectedException {
            SynchronizedEdge se;
            this.elementLock.lock();
            try {
                Edge e = ((Graph)this.wrappedElement).addEdge(id, node1, node2);
                se = new SynchronizedEdge(this, e);
                this.synchronizedEdges.put(id, se);
            }
            finally {
                this.elementLock.unlock();
            }
            return se;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Edge addEdge(String id, String from, String to, boolean directed) throws IdAlreadyInUseException, ElementNotFoundException {
            SynchronizedEdge se;
            this.elementLock.lock();
            try {
                Edge e = ((Graph)this.wrappedElement).addEdge(id, from, to, directed);
                se = new SynchronizedEdge(this, e);
                this.synchronizedEdges.put(id, se);
            }
            finally {
                this.elementLock.unlock();
            }
            return se;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Edge addEdge(String id, int index1, int index2) {
            SynchronizedEdge se;
            this.elementLock.lock();
            try {
                Edge e = ((Graph)this.wrappedElement).addEdge(id, index1, index2);
                se = new SynchronizedEdge(this, e);
                this.synchronizedEdges.put(id, se);
            }
            finally {
                this.elementLock.unlock();
            }
            return se;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Edge addEdge(String id, int fromIndex, int toIndex, boolean directed) {
            SynchronizedEdge se;
            this.elementLock.lock();
            try {
                Edge e = ((Graph)this.wrappedElement).addEdge(id, fromIndex, toIndex, directed);
                se = new SynchronizedEdge(this, e);
                this.synchronizedEdges.put(id, se);
            }
            finally {
                this.elementLock.unlock();
            }
            return se;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Edge addEdge(String id, Node node1, Node node2) {
            SynchronizedEdge se;
            Node unsyncNode1 = (Node)((SynchronizedElement)((Object)node1)).wrappedElement;
            Node unsyncNode2 = (Node)((SynchronizedElement)((Object)node2)).wrappedElement;
            this.elementLock.lock();
            try {
                Edge e = ((Graph)this.wrappedElement).addEdge(id, unsyncNode1, unsyncNode2);
                se = new SynchronizedEdge(this, e);
                this.synchronizedEdges.put(id, se);
            }
            finally {
                this.elementLock.unlock();
            }
            return se;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Edge addEdge(String id, Node from, Node to, boolean directed) {
            SynchronizedEdge se;
            Node unsyncFrom = (Node)((SynchronizedElement)((Object)from)).wrappedElement;
            Node unsyncTo = (Node)((SynchronizedElement)((Object)to)).wrappedElement;
            this.elementLock.lock();
            try {
                Edge e = ((Graph)this.wrappedElement).addEdge(id, unsyncFrom, unsyncTo, directed);
                se = new SynchronizedEdge(this, e);
                this.synchronizedEdges.put(id, se);
            }
            finally {
                this.elementLock.unlock();
            }
            return se;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Node addNode(String id) throws IdAlreadyInUseException {
            SynchronizedNode sn;
            this.elementLock.lock();
            try {
                Node n = ((Graph)this.wrappedElement).addNode(id);
                sn = new SynchronizedNode(this, n);
                this.synchronizedNodes.put(id, sn);
            }
            finally {
                this.elementLock.unlock();
            }
            return sn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Iterable<AttributeSink> attributeSinks() {
            LinkedList<AttributeSink> sinks = new LinkedList<AttributeSink>();
            this.elementLock.lock();
            try {
                for (AttributeSink as : ((Graph)this.wrappedElement).attributeSinks()) {
                    sinks.add(as);
                }
            }
            finally {
                this.elementLock.unlock();
            }
            return sinks;
        }

        @Override
        public void clear() {
            this.elementLock.lock();
            try {
                ((Graph)this.wrappedElement).clear();
            }
            finally {
                this.elementLock.unlock();
            }
        }

        @Override
        public EdgeFactory<? extends Edge> edgeFactory() {
            return ((Graph)this.wrappedElement).edgeFactory();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Iterable<ElementSink> elementSinks() {
            LinkedList<ElementSink> sinks = new LinkedList<ElementSink>();
            this.elementLock.lock();
            try {
                for (ElementSink es : ((Graph)this.wrappedElement).elementSinks()) {
                    sinks.add(es);
                }
            }
            finally {
                this.elementLock.unlock();
            }
            return sinks;
        }

        @Override
        public Edge getEdge(String id) {
            Edge e;
            this.elementLock.lock();
            try {
                e = this.synchronizedEdges.get(id);
            }
            finally {
                this.elementLock.unlock();
            }
            return e;
        }

        @Override
        public Edge getEdge(int index) throws IndexOutOfBoundsException {
            Edge e;
            this.elementLock.lock();
            try {
                e = ((Graph)this.wrappedElement).getEdge(index);
            }
            finally {
                this.elementLock.unlock();
            }
            return e == null ? null : this.getEdge(e.getId());
        }

        @Override
        public int getEdgeCount() {
            int c;
            this.elementLock.lock();
            try {
                c = this.synchronizedEdges.size();
            }
            finally {
                this.elementLock.unlock();
            }
            return c;
        }

        @Override
        public Node getNode(String id) {
            Node n;
            this.elementLock.lock();
            try {
                n = this.synchronizedNodes.get(id);
            }
            finally {
                this.elementLock.unlock();
            }
            return n;
        }

        @Override
        public Node getNode(int index) throws IndexOutOfBoundsException {
            Node n;
            this.elementLock.lock();
            try {
                n = ((Graph)this.wrappedElement).getNode(index);
            }
            finally {
                this.elementLock.unlock();
            }
            return n == null ? null : this.getNode(n.getId());
        }

        @Override
        public int getNodeCount() {
            int c;
            this.elementLock.lock();
            try {
                c = this.synchronizedNodes.size();
            }
            finally {
                this.elementLock.unlock();
            }
            return c;
        }

        @Override
        public double getStep() {
            double s;
            this.elementLock.lock();
            try {
                s = ((Graph)this.wrappedElement).getStep();
            }
            finally {
                this.elementLock.unlock();
            }
            return s;
        }

        @Override
        public boolean isAutoCreationEnabled() {
            return ((Graph)this.wrappedElement).isAutoCreationEnabled();
        }

        @Override
        public Viewer display() {
            return ((Graph)this.wrappedElement).display();
        }

        @Override
        public Viewer display(boolean autoLayout) {
            return ((Graph)this.wrappedElement).display(autoLayout);
        }

        @Override
        public boolean isStrict() {
            return ((Graph)this.wrappedElement).isStrict();
        }

        @Override
        public NodeFactory<? extends Node> nodeFactory() {
            return ((Graph)this.wrappedElement).nodeFactory();
        }

        @Override
        public void read(String filename) throws IOException, GraphParseException, ElementNotFoundException {
            this.elementLock.lock();
            try {
                ((Graph)this.wrappedElement).read(filename);
            }
            finally {
                this.elementLock.unlock();
            }
        }

        @Override
        public void read(FileSource input, String filename) throws IOException, GraphParseException {
            this.elementLock.lock();
            try {
                ((Graph)this.wrappedElement).read(input, filename);
            }
            finally {
                this.elementLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Edge removeEdge(String from, String to) throws ElementNotFoundException {
            Edge se;
            this.elementLock.lock();
            try {
                Edge e = ((Graph)this.wrappedElement).removeEdge(from, to);
                se = this.synchronizedEdges.remove(e.getId());
            }
            finally {
                this.elementLock.unlock();
            }
            return se;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Edge removeEdge(String id) throws ElementNotFoundException {
            Edge se;
            this.elementLock.lock();
            try {
                Edge e = ((Graph)this.wrappedElement).removeEdge(id);
                se = this.synchronizedEdges.remove(e.getId());
            }
            finally {
                this.elementLock.unlock();
            }
            return se;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Edge removeEdge(int index) {
            Edge se;
            this.elementLock.lock();
            try {
                Edge e = ((Graph)this.wrappedElement).removeEdge(index);
                se = this.synchronizedEdges.remove(e.getId());
            }
            finally {
                this.elementLock.unlock();
            }
            return se;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Edge removeEdge(int fromIndex, int toIndex) {
            Edge se;
            this.elementLock.lock();
            try {
                Edge e = ((Graph)this.wrappedElement).removeEdge(fromIndex, toIndex);
                se = this.synchronizedEdges.remove(e.getId());
            }
            finally {
                this.elementLock.unlock();
            }
            return se;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Edge removeEdge(Node node1, Node node2) {
            Edge se;
            if (node1 instanceof SynchronizedNode) {
                node1 = (Node)((SynchronizedNode)node1).wrappedElement;
            }
            if (node2 instanceof SynchronizedNode) {
                node2 = (Node)((SynchronizedNode)node1).wrappedElement;
            }
            this.elementLock.lock();
            try {
                Edge e = ((Graph)this.wrappedElement).removeEdge(node1, node2);
                se = this.synchronizedEdges.remove(e.getId());
            }
            finally {
                this.elementLock.unlock();
            }
            return se;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Edge removeEdge(Edge edge) {
            Edge se;
            if (edge instanceof SynchronizedEdge) {
                edge = (Edge)((SynchronizedEdge)edge).wrappedElement;
            }
            this.elementLock.lock();
            try {
                Edge e = ((Graph)this.wrappedElement).removeEdge(edge);
                se = this.synchronizedEdges.remove(e.getId());
            }
            finally {
                this.elementLock.unlock();
            }
            return se;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Node removeNode(String id) throws ElementNotFoundException {
            Node sn;
            this.elementLock.lock();
            try {
                Node n = ((Graph)this.wrappedElement).removeNode(id);
                sn = this.synchronizedNodes.remove(n.getId());
            }
            finally {
                this.elementLock.unlock();
            }
            return sn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Node removeNode(int index) {
            Node sn;
            this.elementLock.lock();
            try {
                Node n = ((Graph)this.wrappedElement).removeNode(index);
                sn = this.synchronizedNodes.remove(n.getId());
            }
            finally {
                this.elementLock.unlock();
            }
            return sn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Node removeNode(Node node) {
            Node sn;
            if (node instanceof SynchronizedNode) {
                node = (Node)((SynchronizedNode)node).wrappedElement;
            }
            this.elementLock.lock();
            try {
                Node n = ((Graph)this.wrappedElement).removeNode(node);
                sn = this.synchronizedNodes.remove(n.getId());
            }
            finally {
                this.elementLock.unlock();
            }
            return sn;
        }

        @Override
        public void setAutoCreate(boolean on) {
            this.elementLock.lock();
            try {
                ((Graph)this.wrappedElement).setAutoCreate(on);
            }
            finally {
                this.elementLock.unlock();
            }
        }

        @Override
        public void setEdgeFactory(EdgeFactory<? extends Edge> ef) {
            this.elementLock.lock();
            try {
                ((Graph)this.wrappedElement).setEdgeFactory(ef);
            }
            finally {
                this.elementLock.unlock();
            }
        }

        @Override
        public void setNodeFactory(NodeFactory<? extends Node> nf) {
            this.elementLock.lock();
            try {
                ((Graph)this.wrappedElement).setNodeFactory(nf);
            }
            finally {
                this.elementLock.unlock();
            }
        }

        @Override
        public void setStrict(boolean on) {
            this.elementLock.lock();
            try {
                ((Graph)this.wrappedElement).setStrict(on);
            }
            finally {
                this.elementLock.unlock();
            }
        }

        @Override
        public void stepBegins(double time) {
            this.elementLock.lock();
            try {
                ((Graph)this.wrappedElement).stepBegins(time);
            }
            finally {
                this.elementLock.unlock();
            }
        }

        @Override
        public void write(String filename) throws IOException {
            this.elementLock.lock();
            try {
                ((Graph)this.wrappedElement).write(filename);
            }
            finally {
                this.elementLock.unlock();
            }
        }

        @Override
        public void write(FileSink output, String filename) throws IOException {
            this.elementLock.lock();
            try {
                ((Graph)this.wrappedElement).write(output, filename);
            }
            finally {
                this.elementLock.unlock();
            }
        }

        @Override
        public void addAttributeSink(AttributeSink sink) {
            this.elementLock.lock();
            try {
                ((Graph)this.wrappedElement).addAttributeSink(sink);
            }
            finally {
                this.elementLock.unlock();
            }
        }

        @Override
        public void addElementSink(ElementSink sink) {
            this.elementLock.lock();
            try {
                ((Graph)this.wrappedElement).addElementSink(sink);
            }
            finally {
                this.elementLock.unlock();
            }
        }

        @Override
        public void addSink(Sink sink) {
            this.elementLock.lock();
            try {
                ((Graph)this.wrappedElement).addSink(sink);
            }
            finally {
                this.elementLock.unlock();
            }
        }

        @Override
        public void clearAttributeSinks() {
            this.elementLock.lock();
            try {
                ((Graph)this.wrappedElement).clearAttributeSinks();
            }
            finally {
                this.elementLock.unlock();
            }
        }

        @Override
        public void clearElementSinks() {
            this.elementLock.lock();
            try {
                ((Graph)this.wrappedElement).clearElementSinks();
            }
            finally {
                this.elementLock.unlock();
            }
        }

        @Override
        public void clearSinks() {
            this.elementLock.lock();
            try {
                ((Graph)this.wrappedElement).clearSinks();
            }
            finally {
                this.elementLock.unlock();
            }
        }

        @Override
        public void removeAttributeSink(AttributeSink sink) {
            this.elementLock.lock();
            try {
                ((Graph)this.wrappedElement).removeAttributeSink(sink);
            }
            finally {
                this.elementLock.unlock();
            }
        }

        @Override
        public void removeElementSink(ElementSink sink) {
            this.elementLock.lock();
            try {
                ((Graph)this.wrappedElement).removeElementSink(sink);
            }
            finally {
                this.elementLock.unlock();
            }
        }

        @Override
        public void removeSink(Sink sink) {
            this.elementLock.lock();
            try {
                ((Graph)this.wrappedElement).removeSink(sink);
            }
            finally {
                this.elementLock.unlock();
            }
        }

        @Override
        public void edgeAttributeAdded(String sourceId, long timeId, String edgeId, String attribute, Object value) {
            ((Graph)this.wrappedElement).edgeAttributeAdded(sourceId, timeId, edgeId, attribute, value);
        }

        @Override
        public void edgeAttributeChanged(String sourceId, long timeId, String edgeId, String attribute, Object oldValue, Object newValue) {
            ((Graph)this.wrappedElement).edgeAttributeChanged(sourceId, timeId, edgeId, attribute, oldValue, newValue);
        }

        @Override
        public void edgeAttributeRemoved(String sourceId, long timeId, String edgeId, String attribute) {
            ((Graph)this.wrappedElement).edgeAttributeRemoved(sourceId, timeId, edgeId, attribute);
        }

        @Override
        public void graphAttributeAdded(String sourceId, long timeId, String attribute, Object value) {
            ((Graph)this.wrappedElement).graphAttributeAdded(sourceId, timeId, attribute, value);
        }

        @Override
        public void graphAttributeChanged(String sourceId, long timeId, String attribute, Object oldValue, Object newValue) {
            ((Graph)this.wrappedElement).graphAttributeChanged(sourceId, timeId, attribute, oldValue, newValue);
        }

        @Override
        public void graphAttributeRemoved(String sourceId, long timeId, String attribute) {
            ((Graph)this.wrappedElement).graphAttributeRemoved(sourceId, timeId, attribute);
        }

        @Override
        public void nodeAttributeAdded(String sourceId, long timeId, String nodeId, String attribute, Object value) {
            ((Graph)this.wrappedElement).nodeAttributeAdded(sourceId, timeId, nodeId, attribute, value);
        }

        @Override
        public void nodeAttributeChanged(String sourceId, long timeId, String nodeId, String attribute, Object oldValue, Object newValue) {
            ((Graph)this.wrappedElement).nodeAttributeChanged(sourceId, timeId, nodeId, attribute, oldValue, newValue);
        }

        @Override
        public void nodeAttributeRemoved(String sourceId, long timeId, String nodeId, String attribute) {
            ((Graph)this.wrappedElement).nodeAttributeRemoved(sourceId, timeId, nodeId, attribute);
        }

        @Override
        public void edgeAdded(String sourceId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
            ((Graph)this.wrappedElement).edgeAdded(sourceId, timeId, edgeId, fromNodeId, toNodeId, directed);
        }

        @Override
        public void edgeRemoved(String sourceId, long timeId, String edgeId) {
            ((Graph)this.wrappedElement).edgeRemoved(sourceId, timeId, edgeId);
        }

        @Override
        public void graphCleared(String sourceId, long timeId) {
            ((Graph)this.wrappedElement).graphCleared(sourceId, timeId);
        }

        @Override
        public void nodeAdded(String sourceId, long timeId, String nodeId) {
            ((Graph)this.wrappedElement).nodeAdded(sourceId, timeId, nodeId);
        }

        @Override
        public void nodeRemoved(String sourceId, long timeId, String nodeId) {
            ((Graph)this.wrappedElement).nodeRemoved(sourceId, timeId, nodeId);
        }

        @Override
        public void stepBegins(String sourceId, long timeId, double step) {
            ((Graph)this.wrappedElement).stepBegins(sourceId, timeId, step);
        }

        @Override
        public Iterator<Node> iterator() {
            return this.nodes().iterator();
        }
    }

    static class SynchronizedEdge
    extends SynchronizedElement<Edge>
    implements Edge {
        final SynchronizedGraph sg;

        SynchronizedEdge(SynchronizedGraph sg, Edge e) {
            super(e);
            this.sg = sg;
        }

        @Override
        public Node getNode0() {
            Node n;
            this.sg.elementLock.lock();
            try {
                n = this.sg.getNode(((Edge)this.wrappedElement).getNode0().getIndex());
            }
            finally {
                this.sg.elementLock.unlock();
            }
            return n;
        }

        @Override
        public Node getNode1() {
            Node n;
            this.sg.elementLock.lock();
            try {
                n = this.sg.getNode(((Edge)this.wrappedElement).getNode1().getIndex());
            }
            finally {
                this.sg.elementLock.unlock();
            }
            return n;
        }

        @Override
        public Node getOpposite(Node node) {
            Node n;
            if (node instanceof SynchronizedNode) {
                node = (Node)((SynchronizedNode)node).wrappedElement;
            }
            this.sg.elementLock.lock();
            try {
                n = this.sg.getNode(((Edge)this.wrappedElement).getOpposite(node).getIndex());
            }
            finally {
                this.sg.elementLock.unlock();
            }
            return n;
        }

        @Override
        public Node getSourceNode() {
            Node n;
            this.sg.elementLock.lock();
            try {
                n = this.sg.getNode(((Edge)this.wrappedElement).getSourceNode().getIndex());
            }
            finally {
                this.sg.elementLock.unlock();
            }
            return n;
        }

        @Override
        public Node getTargetNode() {
            Node n;
            this.sg.elementLock.lock();
            try {
                n = this.sg.getNode(((Edge)this.wrappedElement).getTargetNode().getIndex());
            }
            finally {
                this.sg.elementLock.unlock();
            }
            return n;
        }

        @Override
        public boolean isDirected() {
            return ((Edge)this.wrappedElement).isDirected();
        }

        @Override
        public boolean isLoop() {
            return ((Edge)this.wrappedElement).isLoop();
        }
    }

    static class SynchronizedNode
    extends SynchronizedElement<Node>
    implements Node {
        private final SynchronizedGraph sg;
        private final ReentrantLock elementLock;

        SynchronizedNode(SynchronizedGraph sg, Node n) {
            super(n);
            this.sg = sg;
            this.elementLock = new ReentrantLock();
        }

        @Override
        public Stream<Node> neighborNodes() {
            List nodes;
            this.elementLock.lock();
            this.sg.elementLock.lock();
            try {
                nodes = ((Node)this.wrappedElement).neighborNodes().map(n -> this.sg.getNode(n.getIndex())).collect(Collectors.toList());
            }
            finally {
                this.sg.elementLock.unlock();
                this.elementLock.unlock();
            }
            return nodes.stream();
        }

        @Override
        public Stream<Edge> edges() {
            List edges;
            this.elementLock.lock();
            this.sg.elementLock.lock();
            try {
                edges = ((Node)this.wrappedElement).edges().map(e -> this.sg.getEdge(e.getIndex())).collect(Collectors.toList());
            }
            finally {
                this.sg.elementLock.unlock();
                this.elementLock.unlock();
            }
            return edges.stream();
        }

        @Override
        public Stream<Edge> leavingEdges() {
            List edges;
            this.elementLock.lock();
            this.sg.elementLock.lock();
            try {
                edges = ((Node)this.wrappedElement).leavingEdges().map(e -> this.sg.getEdge(e.getIndex())).collect(Collectors.toList());
            }
            finally {
                this.sg.elementLock.unlock();
                this.elementLock.unlock();
            }
            return edges.stream();
        }

        @Override
        public Stream<Edge> enteringEdges() {
            List edges;
            this.elementLock.lock();
            this.sg.elementLock.lock();
            try {
                edges = ((Node)this.wrappedElement).enteringEdges().map(e -> this.sg.getEdge(e.getIndex())).collect(Collectors.toList());
            }
            finally {
                this.sg.elementLock.unlock();
                this.elementLock.unlock();
            }
            return edges.stream();
        }

        @Override
        public Iterator<Node> getBreadthFirstIterator() {
            return this.getBreadthFirstIterator(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Iterator<Node> getBreadthFirstIterator(boolean directed) {
            LinkedList<Node> l = new LinkedList<Node>();
            this.elementLock.lock();
            this.sg.elementLock.lock();
            try {
                Iterator<Node> it = ((Node)this.wrappedElement).getBreadthFirstIterator(directed);
                while (it.hasNext()) {
                    l.add(this.sg.getNode(it.next().getIndex()));
                }
            }
            finally {
                this.sg.elementLock.unlock();
                this.elementLock.unlock();
            }
            return l.iterator();
        }

        @Override
        public int getDegree() {
            int d;
            this.elementLock.lock();
            try {
                d = ((Node)this.wrappedElement).getDegree();
            }
            finally {
                this.elementLock.unlock();
            }
            return d;
        }

        @Override
        public Iterator<Node> getDepthFirstIterator() {
            return this.getDepthFirstIterator(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Iterator<Node> getDepthFirstIterator(boolean directed) {
            LinkedList<Node> l = new LinkedList<Node>();
            this.elementLock.lock();
            this.sg.elementLock.lock();
            try {
                Iterator<Node> it = ((Node)this.wrappedElement).getDepthFirstIterator();
                while (it.hasNext()) {
                    l.add(this.sg.getNode(it.next().getIndex()));
                }
            }
            finally {
                this.sg.elementLock.unlock();
                this.elementLock.unlock();
            }
            return l.iterator();
        }

        @Override
        public Edge getEdge(int i) {
            Edge e;
            this.elementLock.lock();
            try {
                e = this.sg.getEdge(((Node)this.wrappedElement).getEdge(i).getIndex());
            }
            finally {
                this.elementLock.unlock();
            }
            return e;
        }

        @Override
        public Edge getEnteringEdge(int i) {
            Edge e;
            this.elementLock.lock();
            try {
                e = this.sg.getEdge(((Node)this.wrappedElement).getEnteringEdge(i).getIndex());
            }
            finally {
                this.elementLock.unlock();
            }
            return e;
        }

        @Override
        public Edge getLeavingEdge(int i) {
            Edge e;
            this.elementLock.lock();
            try {
                e = this.sg.getEdge(((Node)this.wrappedElement).getLeavingEdge(i).getIndex());
            }
            finally {
                this.elementLock.unlock();
            }
            return e;
        }

        @Override
        public Edge getEdgeBetween(String id) {
            Edge e;
            this.elementLock.lock();
            try {
                e = this.sg.getEdge(((Node)this.wrappedElement).getEdgeBetween(id).getIndex());
            }
            finally {
                this.elementLock.unlock();
            }
            return e;
        }

        @Override
        public Edge getEdgeBetween(Node n) {
            Edge e;
            this.elementLock.lock();
            try {
                e = this.sg.getEdge(((Node)this.wrappedElement).getEdgeBetween(n).getIndex());
            }
            finally {
                this.elementLock.unlock();
            }
            return e;
        }

        @Override
        public Edge getEdgeBetween(int index) {
            Edge e;
            this.elementLock.lock();
            try {
                e = this.sg.getEdge(((Node)this.wrappedElement).getEdgeBetween(index).getIndex());
            }
            finally {
                this.elementLock.unlock();
            }
            return e;
        }

        @Override
        public Edge getEdgeFrom(String id) {
            Edge e;
            this.elementLock.lock();
            try {
                e = this.sg.getEdge(((Node)this.wrappedElement).getEdgeFrom(id).getIndex());
            }
            finally {
                this.elementLock.unlock();
            }
            return e;
        }

        @Override
        public Edge getEdgeFrom(Node n) {
            Edge e;
            this.elementLock.lock();
            try {
                e = this.sg.getEdge(((Node)this.wrappedElement).getEdgeFrom(n).getIndex());
            }
            finally {
                this.elementLock.unlock();
            }
            return e;
        }

        @Override
        public Edge getEdgeFrom(int index) {
            Edge e;
            this.elementLock.lock();
            try {
                e = this.sg.getEdge(((Node)this.wrappedElement).getEdgeFrom(index).getIndex());
            }
            finally {
                this.elementLock.unlock();
            }
            return e;
        }

        @Override
        public Edge getEdgeToward(String id) {
            Edge e;
            this.elementLock.lock();
            try {
                e = this.sg.getEdge(((Node)this.wrappedElement).getEdgeToward(id).getIndex());
            }
            finally {
                this.elementLock.unlock();
            }
            return e;
        }

        @Override
        public Edge getEdgeToward(Node n) {
            Edge e;
            this.elementLock.lock();
            try {
                e = this.sg.getEdge(((Node)this.wrappedElement).getEdgeToward(n).getIndex());
            }
            finally {
                this.elementLock.unlock();
            }
            return e;
        }

        @Override
        public Edge getEdgeToward(int index) {
            Edge e;
            this.elementLock.lock();
            try {
                e = this.sg.getEdge(((Node)this.wrappedElement).getEdgeToward(index).getIndex());
            }
            finally {
                this.elementLock.unlock();
            }
            return e;
        }

        @Override
        public Graph getGraph() {
            return this.sg;
        }

        @Override
        public int getInDegree() {
            int d;
            this.elementLock.lock();
            try {
                d = ((Node)this.wrappedElement).getInDegree();
            }
            finally {
                this.elementLock.unlock();
            }
            return d;
        }

        @Override
        public int getOutDegree() {
            int d;
            this.elementLock.lock();
            try {
                d = ((Node)this.wrappedElement).getOutDegree();
            }
            finally {
                this.elementLock.unlock();
            }
            return d;
        }

        @Override
        public Iterator<Edge> iterator() {
            return this.edges().iterator();
        }
    }

    static class SynchronizedElement<U extends Element>
    implements Element {
        private static final ReentrantLock attributeLock = new ReentrantLock();
        protected final U wrappedElement;

        SynchronizedElement(U e) {
            this.wrappedElement = e;
        }

        @Override
        public void setAttribute(String attribute, Object ... values) {
            attributeLock.lock();
            try {
                this.wrappedElement.setAttribute(attribute, values);
            }
            finally {
                attributeLock.unlock();
            }
        }

        @Override
        public void setAttributes(Map<String, Object> attributes) {
            attributeLock.lock();
            try {
                this.wrappedElement.setAttributes(attributes);
            }
            finally {
                attributeLock.unlock();
            }
        }

        @Override
        public void clearAttributes() {
            attributeLock.lock();
            try {
                this.wrappedElement.clearAttributes();
            }
            finally {
                attributeLock.unlock();
            }
        }

        @Override
        public Object[] getArray(String key) {
            Object[] o;
            attributeLock.lock();
            try {
                o = this.wrappedElement.getArray(key);
            }
            finally {
                attributeLock.unlock();
            }
            return o;
        }

        @Override
        public Object getAttribute(String key) {
            Object o;
            attributeLock.lock();
            try {
                o = this.wrappedElement.getAttribute(key);
            }
            finally {
                attributeLock.unlock();
            }
            return o;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T getAttribute(String key, Class<T> clazz) {
            T o;
            attributeLock.lock();
            try {
                o = this.wrappedElement.getAttribute(key, clazz);
            }
            finally {
                attributeLock.unlock();
            }
            return o;
        }

        @Override
        public int getAttributeCount() {
            int c;
            attributeLock.lock();
            try {
                c = this.wrappedElement.getAttributeCount();
            }
            finally {
                attributeLock.unlock();
            }
            return c;
        }

        @Override
        public Stream<String> attributeKeys() {
            Stream<String> s = null;
            attributeLock.lock();
            try {
                s = this.wrappedElement.attributeKeys();
                if (!s.spliterator().hasCharacteristics(4096)) {
                    s = s.collect(Collectors.toList()).stream();
                }
            }
            finally {
                attributeLock.unlock();
            }
            return s;
        }

        @Override
        public Object getFirstAttributeOf(String ... keys) {
            Object o;
            attributeLock.lock();
            try {
                o = this.wrappedElement.getFirstAttributeOf(keys);
            }
            finally {
                attributeLock.unlock();
            }
            return o;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T getFirstAttributeOf(Class<T> clazz, String ... keys) {
            T o;
            attributeLock.lock();
            try {
                o = this.wrappedElement.getFirstAttributeOf(clazz, keys);
            }
            finally {
                attributeLock.unlock();
            }
            return o;
        }

        @Override
        public Map<?, ?> getMap(String key) {
            Map<?, ?> o;
            attributeLock.lock();
            try {
                o = this.wrappedElement.getMap(key);
            }
            finally {
                attributeLock.unlock();
            }
            return o;
        }

        @Override
        public String getId() {
            return this.wrappedElement.getId();
        }

        @Override
        public int getIndex() {
            return this.wrappedElement.getIndex();
        }

        @Override
        public CharSequence getLabel(String key) {
            CharSequence o;
            attributeLock.lock();
            try {
                o = this.wrappedElement.getLabel(key);
            }
            finally {
                attributeLock.unlock();
            }
            return o;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public double getNumber(String key) {
            double o;
            attributeLock.lock();
            try {
                o = this.wrappedElement.getNumber(key);
            }
            finally {
                attributeLock.unlock();
            }
            return o;
        }

        @Override
        public List<? extends Number> getVector(String key) {
            List<? extends Number> o;
            attributeLock.lock();
            try {
                o = this.wrappedElement.getVector(key);
            }
            finally {
                attributeLock.unlock();
            }
            return o;
        }

        @Override
        public boolean hasArray(String key) {
            boolean b;
            attributeLock.lock();
            try {
                b = this.wrappedElement.hasArray(key);
            }
            finally {
                attributeLock.unlock();
            }
            return b;
        }

        @Override
        public boolean hasAttribute(String key) {
            boolean b;
            attributeLock.lock();
            try {
                b = this.wrappedElement.hasAttribute(key);
            }
            finally {
                attributeLock.unlock();
            }
            return b;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasAttribute(String key, Class<?> clazz) {
            boolean b;
            attributeLock.lock();
            try {
                b = this.wrappedElement.hasAttribute(key, clazz);
            }
            finally {
                attributeLock.unlock();
            }
            return b;
        }

        @Override
        public boolean hasMap(String key) {
            boolean b;
            attributeLock.lock();
            try {
                b = this.wrappedElement.hasMap(key);
            }
            finally {
                attributeLock.unlock();
            }
            return b;
        }

        @Override
        public boolean hasLabel(String key) {
            boolean b;
            attributeLock.lock();
            try {
                b = this.wrappedElement.hasLabel(key);
            }
            finally {
                attributeLock.unlock();
            }
            return b;
        }

        @Override
        public boolean hasNumber(String key) {
            boolean b;
            attributeLock.lock();
            try {
                b = this.wrappedElement.hasNumber(key);
            }
            finally {
                attributeLock.unlock();
            }
            return b;
        }

        @Override
        public boolean hasVector(String key) {
            boolean b;
            attributeLock.lock();
            try {
                b = this.wrappedElement.hasVector(key);
            }
            finally {
                attributeLock.unlock();
            }
            return b;
        }

        @Override
        public void removeAttribute(String attribute) {
            attributeLock.lock();
            try {
                this.wrappedElement.removeAttribute(attribute);
            }
            finally {
                attributeLock.unlock();
            }
        }
    }
}

