/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.graphstream.graph.Element;
import org.graphstream.graph.Graph;
import org.graphstream.stream.file.FileSinkBase;
import org.graphstream.util.cumulative.CumulativeAttributes;
import org.graphstream.util.cumulative.CumulativeSpells;
import org.graphstream.util.cumulative.GraphSpells;

public class FileSinkGEXF
extends FileSinkBase {
    XMLStreamWriter stream;
    boolean smart = true;
    int depth = 0;
    int currentAttributeIndex = 0;
    GraphSpells graphSpells = null;
    TimeFormat timeFormat = TimeFormat.DOUBLE;

    public void setTimeFormat(TimeFormat format) {
        this.timeFormat = format;
    }

    protected void putSpellAttributes(CumulativeSpells.Spell s) throws XMLStreamException {
        String date;
        if (s.isStarted()) {
            String start = s.isStartOpen() ? "startopen" : "start";
            date = this.timeFormat.format.format(s.getStartDate());
            this.stream.writeAttribute(start, date);
        }
        if (s.isEnded()) {
            String end = s.isEndOpen() ? "endopen" : "end";
            date = this.timeFormat.format.format(s.getEndDate());
            this.stream.writeAttribute(end, date);
        }
    }

    @Override
    protected void outputEndOfFile() throws IOException {
        try {
            if (this.graphSpells != null) {
                this.exportGraphSpells();
                this.graphSpells = null;
            }
            this.endElement(this.stream, false);
            this.stream.writeEndDocument();
            this.stream.flush();
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected void outputHeader() throws IOException {
        Calendar cal = Calendar.getInstance();
        Date date = cal.getTime();
        DateFormat df = DateFormat.getDateTimeInstance(3, 3);
        try {
            this.stream = XMLOutputFactory.newFactory().createXMLStreamWriter(this.output);
            this.stream.writeStartDocument("UTF-8", "1.0");
            this.startElement(this.stream, "gexf");
            this.stream.writeAttribute("xmlns", "http://www.gexf.net/1.2draft");
            this.stream.writeAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            this.stream.writeAttribute("xsi:schemaLocation", "http://www.gexf.net/1.2draft http://www.gexf.net/1.2draft/gexf.xsd");
            this.stream.writeAttribute("version", "1.2");
            this.startElement(this.stream, "meta");
            this.stream.writeAttribute("lastmodifieddate", df.format(date));
            this.startElement(this.stream, "creator");
            this.stream.writeCharacters("GraphStream - " + this.getClass().getName());
            this.endElement(this.stream, true);
            this.endElement(this.stream, false);
        }
        catch (FactoryConfigurationError | XMLStreamException e) {
            throw new IOException(e);
        }
    }

    protected void startElement(XMLStreamWriter stream, String name) throws XMLStreamException {
        if (this.smart) {
            stream.writeCharacters("\n");
            for (int i = 0; i < this.depth; ++i) {
                stream.writeCharacters(" ");
            }
        }
        stream.writeStartElement(name);
        ++this.depth;
    }

    protected void endElement(XMLStreamWriter stream, boolean leaf) throws XMLStreamException {
        --this.depth;
        if (this.smart && !leaf) {
            stream.writeCharacters("\n");
            for (int i = 0; i < this.depth; ++i) {
                stream.writeCharacters(" ");
            }
        }
        stream.writeEndElement();
    }

    @Override
    protected void exportGraph(Graph g) {
        GEXFAttributeMap nodeAttributes = new GEXFAttributeMap("node", g);
        GEXFAttributeMap edgeAttributes = new GEXFAttributeMap("edge", g);
        Consumer<Exception> onException = Throwable::printStackTrace;
        try {
            this.startElement(this.stream, "graph");
            this.stream.writeAttribute("defaultedgetype", "undirected");
            nodeAttributes.export(this.stream);
            edgeAttributes.export(this.stream);
            this.startElement(this.stream, "nodes");
            g.nodes().forEach(n -> {
                try {
                    this.startElement(this.stream, "node");
                    this.stream.writeAttribute("id", n.getId());
                    if (n.hasAttribute("label")) {
                        this.stream.writeAttribute("label", n.getAttribute("label").toString());
                    }
                    if (n.getAttributeCount() > 0) {
                        this.startElement(this.stream, "attvalues");
                        n.attributeKeys().forEach(key -> {
                            try {
                                nodeAttributes.push(this.stream, (Element)n, (String)key);
                            }
                            catch (XMLStreamException e) {
                                onException.accept(e);
                            }
                        });
                        this.endElement(this.stream, false);
                    }
                    this.endElement(this.stream, n.getAttributeCount() == 0);
                }
                catch (Exception ex) {
                    onException.accept(ex);
                }
            });
            this.endElement(this.stream, false);
            this.startElement(this.stream, "edges");
            g.edges().forEach(e -> {
                try {
                    this.startElement(this.stream, "edge");
                    this.stream.writeAttribute("id", e.getId());
                    this.stream.writeAttribute("source", e.getSourceNode().getId());
                    this.stream.writeAttribute("target", e.getTargetNode().getId());
                    if (e.getAttributeCount() > 0) {
                        this.startElement(this.stream, "attvalues");
                        e.attributeKeys().forEach(key -> {
                            try {
                                edgeAttributes.push(this.stream, (Element)e, (String)key);
                            }
                            catch (XMLStreamException e1) {
                                onException.accept(e1);
                            }
                        });
                        this.endElement(this.stream, false);
                    }
                    this.endElement(this.stream, e.getAttributeCount() == 0);
                }
                catch (Exception ex) {
                    onException.accept(ex);
                }
            });
            this.endElement(this.stream, false);
            this.endElement(this.stream, false);
        }
        catch (XMLStreamException e1) {
            onException.accept(e1);
        }
    }

    protected void exportGraphSpells() {
        GEXFAttributeMap nodeAttributes = new GEXFAttributeMap("node", this.graphSpells);
        GEXFAttributeMap edgeAttributes = new GEXFAttributeMap("edge", this.graphSpells);
        try {
            CumulativeSpells.Spell s;
            int i;
            CumulativeSpells spells;
            this.startElement(this.stream, "graph");
            this.stream.writeAttribute("mode", "dynamic");
            this.stream.writeAttribute("defaultedgetype", "undirected");
            this.stream.writeAttribute("timeformat", this.timeFormat.name().toLowerCase());
            nodeAttributes.export(this.stream);
            edgeAttributes.export(this.stream);
            this.startElement(this.stream, "nodes");
            for (String nodeId : this.graphSpells.getNodes()) {
                this.startElement(this.stream, "node");
                this.stream.writeAttribute("id", nodeId);
                CumulativeAttributes attr = this.graphSpells.getNodeAttributes(nodeId);
                Object label = attr.getAny("label");
                if (label != null) {
                    this.stream.writeAttribute("label", label.toString());
                }
                if (!(spells = this.graphSpells.getNodeSpells(nodeId)).isEternal()) {
                    this.startElement(this.stream, "spells");
                    for (i = 0; i < spells.getSpellCount(); ++i) {
                        s = spells.getSpell(i);
                        this.startElement(this.stream, "spell");
                        this.putSpellAttributes(s);
                        this.endElement(this.stream, true);
                    }
                    this.endElement(this.stream, false);
                }
                if (attr.getAttributesCount() > 0) {
                    this.startElement(this.stream, "attvalues");
                    nodeAttributes.push(this.stream, nodeId, this.graphSpells);
                    this.endElement(this.stream, false);
                }
                this.endElement(this.stream, spells.isEternal() && attr.getAttributesCount() == 0);
            }
            this.endElement(this.stream, false);
            this.startElement(this.stream, "edges");
            for (String edgeId : this.graphSpells.getEdges()) {
                this.startElement(this.stream, "edge");
                GraphSpells.EdgeData data = this.graphSpells.getEdgeData(edgeId);
                this.stream.writeAttribute("id", edgeId);
                this.stream.writeAttribute("source", data.getSource());
                this.stream.writeAttribute("target", data.getTarget());
                CumulativeAttributes attr = this.graphSpells.getEdgeAttributes(edgeId);
                spells = this.graphSpells.getEdgeSpells(edgeId);
                if (!spells.isEternal()) {
                    this.startElement(this.stream, "spells");
                    for (i = 0; i < spells.getSpellCount(); ++i) {
                        s = spells.getSpell(i);
                        this.startElement(this.stream, "spell");
                        this.putSpellAttributes(s);
                        this.endElement(this.stream, true);
                    }
                    this.endElement(this.stream, false);
                }
                if (attr.getAttributesCount() > 0) {
                    this.startElement(this.stream, "attvalues");
                    edgeAttributes.push(this.stream, edgeId, this.graphSpells);
                    this.endElement(this.stream, false);
                }
                this.endElement(this.stream, spells.isEternal() && attr.getAttributesCount() == 0);
            }
            this.endElement(this.stream, false);
            this.endElement(this.stream, false);
        }
        catch (XMLStreamException e1) {
            e1.printStackTrace();
        }
    }

    protected void checkGraphSpells() {
        if (this.graphSpells == null) {
            this.graphSpells = new GraphSpells();
        }
    }

    @Override
    public void edgeAttributeAdded(String sourceId, long timeId, String edgeId, String attribute, Object value) {
        this.checkGraphSpells();
        this.graphSpells.edgeAttributeAdded(sourceId, timeId, edgeId, attribute, value);
    }

    @Override
    public void edgeAttributeChanged(String sourceId, long timeId, String edgeId, String attribute, Object oldValue, Object newValue) {
        this.checkGraphSpells();
        this.graphSpells.edgeAttributeChanged(sourceId, timeId, edgeId, attribute, oldValue, newValue);
    }

    @Override
    public void edgeAttributeRemoved(String sourceId, long timeId, String edgeId, String attribute) {
        this.checkGraphSpells();
        this.graphSpells.edgeAttributeRemoved(sourceId, timeId, edgeId, attribute);
    }

    @Override
    public void graphAttributeAdded(String sourceId, long timeId, String attribute, Object value) {
        this.checkGraphSpells();
        this.graphSpells.graphAttributeAdded(sourceId, timeId, attribute, value);
    }

    @Override
    public void graphAttributeChanged(String sourceId, long timeId, String attribute, Object oldValue, Object newValue) {
        this.checkGraphSpells();
        this.graphSpells.graphAttributeChanged(sourceId, timeId, attribute, oldValue, newValue);
    }

    @Override
    public void graphAttributeRemoved(String sourceId, long timeId, String attribute) {
        this.checkGraphSpells();
        this.graphSpells.graphAttributeRemoved(sourceId, timeId, attribute);
    }

    @Override
    public void nodeAttributeAdded(String sourceId, long timeId, String nodeId, String attribute, Object value) {
        this.checkGraphSpells();
        this.graphSpells.nodeAttributeAdded(sourceId, timeId, nodeId, attribute, value);
    }

    @Override
    public void nodeAttributeChanged(String sourceId, long timeId, String nodeId, String attribute, Object oldValue, Object newValue) {
        this.checkGraphSpells();
        this.graphSpells.nodeAttributeChanged(sourceId, timeId, nodeId, attribute, oldValue, newValue);
    }

    @Override
    public void nodeAttributeRemoved(String sourceId, long timeId, String nodeId, String attribute) {
        this.checkGraphSpells();
        this.graphSpells.nodeAttributeRemoved(sourceId, timeId, nodeId, attribute);
    }

    @Override
    public void edgeAdded(String sourceId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
        this.checkGraphSpells();
        this.graphSpells.edgeAdded(sourceId, timeId, edgeId, fromNodeId, toNodeId, directed);
    }

    @Override
    public void edgeRemoved(String sourceId, long timeId, String edgeId) {
        this.checkGraphSpells();
        this.graphSpells.edgeRemoved(sourceId, timeId, edgeId);
    }

    @Override
    public void graphCleared(String sourceId, long timeId) {
        this.checkGraphSpells();
        this.graphSpells.graphCleared(sourceId, timeId);
    }

    @Override
    public void nodeAdded(String sourceId, long timeId, String nodeId) {
        this.checkGraphSpells();
        this.graphSpells.nodeAdded(sourceId, timeId, nodeId);
    }

    @Override
    public void nodeRemoved(String sourceId, long timeId, String nodeId) {
        this.checkGraphSpells();
        this.graphSpells.nodeRemoved(sourceId, timeId, nodeId);
    }

    @Override
    public void stepBegins(String sourceId, long timeId, double step) {
        this.checkGraphSpells();
        this.graphSpells.stepBegins(sourceId, timeId, step);
    }

    public static enum TimeFormat {
        INTEGER(new DecimalFormat("#", new DecimalFormatSymbols(Locale.ROOT))),
        DOUBLE(new DecimalFormat("#.0###################", new DecimalFormatSymbols(Locale.ROOT))),
        DATE(new SimpleDateFormat("yyyy-MM-dd")),
        DATETIME(new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss.SSSZ"));

        Format format;

        private TimeFormat(Format f) {
            this.format = f;
        }
    }

    class GEXFAttributeMap
    extends HashMap<String, GEXFAttribute> {
        private static final long serialVersionUID = 6176508111522815024L;
        protected String type;

        GEXFAttributeMap(String type, Graph g) {
            this.type = type;
            Stream<Element> stream = type.equals("node") ? g.nodes() : g.edges();
            stream.forEach((? super T e) -> e.attributeKeys().forEach((? super T key) -> {
                Object value = e.getAttribute((String)key);
                this.check((String)key, value);
            }));
        }

        GEXFAttributeMap(String type, GraphSpells spells) {
            this.type = type;
            if (type.equals("node")) {
                for (String nodeId : spells.getNodes()) {
                    CumulativeAttributes attr = spells.getNodeAttributes(nodeId);
                    for (String key : attr.getAttributes()) {
                        for (CumulativeSpells.Spell s : attr.getAttributeSpells(key)) {
                            Object value = s.getAttachedData();
                            this.check(key, value);
                        }
                    }
                }
            } else {
                for (String edgeId : spells.getEdges()) {
                    CumulativeAttributes attr = spells.getEdgeAttributes(edgeId);
                    for (String key : attr.getAttributes()) {
                        for (CumulativeSpells.Spell s : attr.getAttributeSpells(key)) {
                            Object value = s.getAttachedData();
                            this.check(key, value);
                        }
                    }
                }
            }
        }

        void check(String key, Object value) {
            String id = this.getID(key, value);
            String attType = "string";
            if (this.containsKey(id)) {
                return;
            }
            if (value instanceof Integer || value instanceof Short) {
                attType = "integer";
            } else if (value instanceof Long) {
                attType = "long";
            } else if (value instanceof Float) {
                attType = "float";
            } else if (value instanceof Double) {
                attType = "double";
            } else if (value instanceof Boolean) {
                attType = "boolean";
            } else if (value instanceof URL || value instanceof URI) {
                attType = "anyURI";
            } else if (value.getClass().isArray() || value instanceof Collection) {
                attType = "liststring";
            }
            this.put(id, new GEXFAttribute(key, attType));
        }

        String getID(String key, Object value) {
            return String.format("%s@%s", key, value.getClass().getName());
        }

        void export(XMLStreamWriter stream) throws XMLStreamException {
            if (this.size() == 0) {
                return;
            }
            FileSinkGEXF.this.startElement(stream, "attributes");
            stream.writeAttribute("class", this.type);
            for (GEXFAttribute a : this.values()) {
                FileSinkGEXF.this.startElement(stream, "attribute");
                stream.writeAttribute("id", Integer.toString(a.index));
                stream.writeAttribute("title", a.key);
                stream.writeAttribute("type", a.type);
                FileSinkGEXF.this.endElement(stream, true);
            }
            FileSinkGEXF.this.endElement(stream, this.size() == 0);
        }

        void push(XMLStreamWriter stream, Element e, String key) throws XMLStreamException {
            String id = this.getID(key, e.getAttribute(key));
            GEXFAttribute a = (GEXFAttribute)this.get(id);
            if (a == null) {
                return;
            }
            FileSinkGEXF.this.startElement(stream, "attvalue");
            stream.writeAttribute("for", Integer.toString(a.index));
            stream.writeAttribute("value", e.getAttribute(key).toString());
            FileSinkGEXF.this.endElement(stream, true);
        }

        void push(XMLStreamWriter stream, String elementId, GraphSpells spells) throws XMLStreamException {
            CumulativeAttributes attr = this.type.equals("node") ? spells.getNodeAttributes(elementId) : spells.getEdgeAttributes(elementId);
            for (String key : attr.getAttributes()) {
                for (CumulativeSpells.Spell s : attr.getAttributeSpells(key)) {
                    Object value = s.getAttachedData();
                    String id = this.getID(key, value);
                    GEXFAttribute a = (GEXFAttribute)this.get(id);
                    if (a == null) {
                        return;
                    }
                    FileSinkGEXF.this.startElement(stream, "attvalue");
                    stream.writeAttribute("for", Integer.toString(a.index));
                    stream.writeAttribute("value", value.toString());
                    FileSinkGEXF.this.putSpellAttributes(s);
                    FileSinkGEXF.this.endElement(stream, true);
                }
            }
        }
    }

    class GEXFAttribute {
        int index;
        String key;
        String type;

        GEXFAttribute(String key, String type) {
            this.index = FileSinkGEXF.this.currentAttributeIndex++;
            this.key = key;
            this.type = type;
        }
    }
}

