/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.netstream;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.logging.Logger;
import org.graphstream.stream.SourceBase;
import org.graphstream.stream.binary.ByteDecoder;
import org.graphstream.stream.netstream.NetStreamConstants;
import org.graphstream.stream.netstream.NetStreamUtils;

public class NetStreamDecoder
extends SourceBase
implements ByteDecoder {
    private static final Logger LOGGER = Logger.getLogger(NetStreamDecoder.class.getName());

    @Override
    public boolean validate(ByteBuffer buffer) {
        if (buffer.position() >= 4) {
            int size = buffer.getInt(0);
            return buffer.position() >= size;
        }
        return false;
    }

    @Override
    public void decode(ByteBuffer bb) {
        try {
            int size = bb.getInt();
            String streamId = NetStreamUtils.decodeString(bb);
            byte cmd = bb.get();
            if (cmd == NetStreamConstants.EVENT_ADD_NODE) {
                this.serve_EVENT_ADD_NODE(bb);
            } else if ((cmd & 0xFF) == (NetStreamConstants.EVENT_DEL_NODE & 0xFF)) {
                this.serve_DEL_NODE(bb);
            } else if (cmd == NetStreamConstants.EVENT_ADD_EDGE) {
                this.serve_EVENT_ADD_EDGE(bb);
            } else if (cmd == NetStreamConstants.EVENT_DEL_EDGE) {
                this.serve_EVENT_DEL_EDGE(bb);
            } else if (cmd == NetStreamConstants.EVENT_STEP) {
                this.serve_EVENT_STEP(bb);
            } else if (cmd == NetStreamConstants.EVENT_CLEARED) {
                this.serve_EVENT_CLEARED(bb);
            } else if (cmd == NetStreamConstants.EVENT_ADD_GRAPH_ATTR) {
                this.serve_EVENT_ADD_GRAPH_ATTR(bb);
            } else if (cmd == NetStreamConstants.EVENT_CHG_GRAPH_ATTR) {
                this.serve_EVENT_CHG_GRAPH_ATTR(bb);
            } else if (cmd == NetStreamConstants.EVENT_DEL_GRAPH_ATTR) {
                this.serve_EVENT_DEL_GRAPH_ATTR(bb);
            } else if (cmd == NetStreamConstants.EVENT_ADD_NODE_ATTR) {
                this.serve_EVENT_ADD_NODE_ATTR(bb);
            } else if (cmd == NetStreamConstants.EVENT_CHG_NODE_ATTR) {
                this.serve_EVENT_CHG_NODE_ATTR(bb);
            } else if (cmd == NetStreamConstants.EVENT_DEL_NODE_ATTR) {
                this.serve_EVENT_DEL_NODE_ATTR(bb);
            } else if (cmd == NetStreamConstants.EVENT_ADD_EDGE_ATTR) {
                this.serve_EVENT_ADD_EDGE_ATTR(bb);
            } else if (cmd == NetStreamConstants.EVENT_CHG_EDGE_ATTR) {
                this.serve_EVENT_CHG_EDGE_ATTR(bb);
            } else if (cmd == NetStreamConstants.EVENT_DEL_EDGE_ATTR) {
                this.serve_EVENT_DEL_EDGE_ATTR(bb);
            } else if (cmd == NetStreamConstants.EVENT_END) {
                LOGGER.info("NetStreamReceiver : Client properly ended the connection.");
            } else {
                LOGGER.warning("NetStreamReceiver: Don't know this command: " + cmd);
            }
        }
        catch (BufferUnderflowException e) {
            LOGGER.warning("bad buffer");
        }
    }

    protected void serve_EVENT_DEL_EDGE_ATTR(ByteBuffer bb) {
        LOGGER.finest("NetStreamServer: Received DEL_EDGE_ATTR command.");
        String sourceId = NetStreamUtils.decodeString(bb);
        long timeId = NetStreamUtils.decodeUnsignedVarint(bb);
        String edgeId = NetStreamUtils.decodeString(bb);
        String attrId = NetStreamUtils.decodeString(bb);
        this.sendEdgeAttributeRemoved(sourceId, timeId, edgeId, attrId);
    }

    protected void serve_EVENT_CHG_EDGE_ATTR(ByteBuffer bb) {
        LOGGER.finest("NetStreamServer: Received CHG_EDGE_ATTR command.");
        String sourceId = NetStreamUtils.decodeString(bb);
        long timeId = NetStreamUtils.decodeUnsignedVarint(bb);
        String edgeId = NetStreamUtils.decodeString(bb);
        String attrId = NetStreamUtils.decodeString(bb);
        int oldValueType = NetStreamUtils.decodeType(bb);
        Object oldValue = NetStreamUtils.decodeValue(bb, oldValueType);
        int newValueType = NetStreamUtils.decodeType(bb);
        Object newValue = NetStreamUtils.decodeValue(bb, newValueType);
        this.sendEdgeAttributeChanged(sourceId, timeId, edgeId, attrId, oldValue, newValue);
    }

    protected void serve_EVENT_ADD_EDGE_ATTR(ByteBuffer bb) {
        LOGGER.finest("NetStreamServer: Received ADD_EDGE_ATTR command.");
        String sourceId = NetStreamUtils.decodeString(bb);
        long timeId = NetStreamUtils.decodeUnsignedVarint(bb);
        String edgeId = NetStreamUtils.decodeString(bb);
        String attrId = NetStreamUtils.decodeString(bb);
        Object value = NetStreamUtils.decodeValue(bb, NetStreamUtils.decodeType(bb));
        this.sendEdgeAttributeAdded(sourceId, timeId, edgeId, attrId, value);
    }

    protected void serve_EVENT_DEL_NODE_ATTR(ByteBuffer bb) {
        LOGGER.finest("NetStreamServer: Received DEL_NODE_ATTR command.");
        String sourceId = NetStreamUtils.decodeString(bb);
        long timeId = NetStreamUtils.decodeUnsignedVarint(bb);
        String nodeId = NetStreamUtils.decodeString(bb);
        String attrId = NetStreamUtils.decodeString(bb);
        this.sendNodeAttributeRemoved(sourceId, timeId, nodeId, attrId);
    }

    protected void serve_EVENT_CHG_NODE_ATTR(ByteBuffer bb) {
        LOGGER.finest("NetStreamServer: Received EVENT_CHG_NODE_ATTR command.");
        String sourceId = NetStreamUtils.decodeString(bb);
        long timeId = NetStreamUtils.decodeUnsignedVarint(bb);
        String nodeId = NetStreamUtils.decodeString(bb);
        String attrId = NetStreamUtils.decodeString(bb);
        int oldValueType = NetStreamUtils.decodeType(bb);
        Object oldValue = NetStreamUtils.decodeValue(bb, oldValueType);
        int newValueType = NetStreamUtils.decodeType(bb);
        Object newValue = NetStreamUtils.decodeValue(bb, newValueType);
        this.sendNodeAttributeChanged(sourceId, timeId, nodeId, attrId, oldValue, newValue);
    }

    protected void serve_EVENT_ADD_NODE_ATTR(ByteBuffer bb) {
        LOGGER.finest("NetStreamServer: Received EVENT_ADD_NODE_ATTR command.");
        String sourceId = NetStreamUtils.decodeString(bb);
        long timeId = NetStreamUtils.decodeUnsignedVarint(bb);
        String nodeId = NetStreamUtils.decodeString(bb);
        String attrId = NetStreamUtils.decodeString(bb);
        Object value = NetStreamUtils.decodeValue(bb, NetStreamUtils.decodeType(bb));
        this.sendNodeAttributeAdded(sourceId, timeId, nodeId, attrId, value);
    }

    protected void serve_EVENT_DEL_GRAPH_ATTR(ByteBuffer bb) {
        LOGGER.finest("NetStreamServer: Received EVENT_DEL_GRAPH_ATTR command.");
        String sourceId = NetStreamUtils.decodeString(bb);
        long timeId = NetStreamUtils.decodeUnsignedVarint(bb);
        String attrId = NetStreamUtils.decodeString(bb);
        this.sendGraphAttributeRemoved(sourceId, timeId, attrId);
    }

    protected void serve_EVENT_CHG_GRAPH_ATTR(ByteBuffer bb) {
        LOGGER.finest("NetStreamServer: Received EVENT_CHG_GRAPH_ATTR command.");
        String sourceId = NetStreamUtils.decodeString(bb);
        long timeId = NetStreamUtils.decodeUnsignedVarint(bb);
        String attrId = NetStreamUtils.decodeString(bb);
        int oldValueType = NetStreamUtils.decodeType(bb);
        Object oldValue = NetStreamUtils.decodeValue(bb, oldValueType);
        int newValueType = NetStreamUtils.decodeType(bb);
        Object newValue = NetStreamUtils.decodeValue(bb, newValueType);
        this.sendGraphAttributeChanged(sourceId, timeId, attrId, oldValue, newValue);
    }

    protected void serve_EVENT_ADD_GRAPH_ATTR(ByteBuffer bb) {
        LOGGER.finest("NetStreamServer: Received EVENT_ADD_GRAPH_ATTR command.");
        String sourceId = NetStreamUtils.decodeString(bb);
        long timeId = NetStreamUtils.decodeUnsignedVarint(bb);
        String attrId = NetStreamUtils.decodeString(bb);
        Object value = NetStreamUtils.decodeValue(bb, NetStreamUtils.decodeType(bb));
        LOGGER.finest(String.format("NetStreamServer | EVENT_ADD_GRAPH_ATTR | %s=%s", attrId, value.toString()));
        this.sendGraphAttributeAdded(sourceId, timeId, attrId, value);
    }

    protected void serve_EVENT_CLEARED(ByteBuffer bb) {
        LOGGER.finest("NetStreamServer: Received EVENT_CLEARED command.");
        String sourceId = NetStreamUtils.decodeString(bb);
        long timeId = NetStreamUtils.decodeUnsignedVarint(bb);
        this.sendGraphCleared(sourceId, timeId);
    }

    protected void serve_EVENT_STEP(ByteBuffer bb) {
        LOGGER.finest("NetStreamServer: Received EVENT_STEP command.");
        String sourceId = NetStreamUtils.decodeString(bb);
        long timeId = NetStreamUtils.decodeUnsignedVarint(bb);
        double time = NetStreamUtils.decodeDouble(bb);
        this.sendStepBegins(sourceId, timeId, time);
    }

    protected void serve_EVENT_DEL_EDGE(ByteBuffer bb) {
        LOGGER.finest("NetStreamServer: Received EVENT_DEL_EDGE command.");
        String sourceId = NetStreamUtils.decodeString(bb);
        long timeId = NetStreamUtils.decodeUnsignedVarint(bb);
        String edgeId = NetStreamUtils.decodeString(bb);
        this.sendEdgeRemoved(sourceId, timeId, edgeId);
    }

    protected void serve_EVENT_ADD_EDGE(ByteBuffer bb) {
        LOGGER.finest("NetStreamServer: Received ADD_EDGE command.");
        String sourceId = NetStreamUtils.decodeString(bb);
        long timeId = NetStreamUtils.decodeUnsignedVarint(bb);
        String edgeId = NetStreamUtils.decodeString(bb);
        String from = NetStreamUtils.decodeString(bb);
        String to = NetStreamUtils.decodeString(bb);
        boolean directed = NetStreamUtils.decodeBoolean(bb);
        this.sendEdgeAdded(sourceId, timeId, edgeId, from, to, directed);
    }

    protected void serve_DEL_NODE(ByteBuffer bb) {
        LOGGER.finest("NetStreamServer: Received DEL_NODE command.");
        String sourceId = NetStreamUtils.decodeString(bb);
        long timeId = NetStreamUtils.decodeUnsignedVarint(bb);
        String nodeId = NetStreamUtils.decodeString(bb);
        this.sendNodeRemoved(sourceId, timeId, nodeId);
    }

    protected void serve_EVENT_ADD_NODE(ByteBuffer bb) {
        LOGGER.finest("NetStreamServer: Received EVENT_ADD_NODE command");
        String sourceId = NetStreamUtils.decodeString(bb);
        long timeId = NetStreamUtils.decodeUnsignedVarint(bb);
        String nodeId = NetStreamUtils.decodeString(bb);
        this.sendNodeAdded(sourceId, timeId, nodeId);
    }
}

