/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.LinkedList;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Element;
import org.graphstream.graph.ElementNotFoundException;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.graph.implementations.AdjacencyListGraph;
import org.graphstream.stream.Sink;
import org.graphstream.stream.file.FileSinkDGS;
import org.graphstream.stream.file.FileSourceDGS;

public class GraphDiff {
    private Bridge bridge = null;
    private final LinkedList<Event> events = new LinkedList();

    public GraphDiff() {
    }

    public GraphDiff(Graph g1, Graph g2) {
        this();
        if (g2.getNodeCount() == 0 && g2.getEdgeCount() == 0 && g2.getAttributeCount() == 0 && (g1.getNodeCount() > 0 || g1.getEdgeCount() > 0)) {
            this.events.add(new GraphCleared(g1));
        } else {
            int idx;
            this.attributeDiff(ElementType.GRAPH, g1, g2);
            for (idx = 0; idx < g1.getEdgeCount(); ++idx) {
                Edge e1 = g1.getEdge(idx);
                Edge e2 = g2.getEdge(e1.getId());
                if (e2 != null) continue;
                this.attributeDiff(ElementType.EDGE, e1, e2);
                this.events.add(new EdgeRemoved(e1.getId(), e1.getSourceNode().getId(), e1.getTargetNode().getId(), e1.isDirected()));
            }
            for (idx = 0; idx < g1.getNodeCount(); ++idx) {
                Node n1 = g1.getNode(idx);
                Node n2 = g2.getNode(n1.getId());
                if (n2 != null) continue;
                this.attributeDiff(ElementType.NODE, n1, n2);
                this.events.add(new NodeRemoved(n1.getId()));
            }
            for (idx = 0; idx < g2.getNodeCount(); ++idx) {
                Node n2 = g2.getNode(idx);
                Node n1 = g1.getNode(n2.getId());
                if (n1 == null) {
                    this.events.add(new NodeAdded(n2.getId()));
                }
                this.attributeDiff(ElementType.NODE, n1, n2);
            }
            for (idx = 0; idx < g2.getEdgeCount(); ++idx) {
                Edge e2 = g2.getEdge(idx);
                Edge e1 = g1.getEdge(e2.getId());
                if (e1 == null) {
                    this.events.add(new EdgeAdded(e2.getId(), e2.getSourceNode().getId(), e2.getTargetNode().getId(), e2.isDirected()));
                }
                this.attributeDiff(ElementType.EDGE, e1, e2);
            }
        }
    }

    public void start(Graph g) {
        if (this.bridge != null) {
            this.end();
        }
        this.bridge = new Bridge(g);
    }

    public void end() {
        if (this.bridge != null) {
            this.bridge.end();
            this.bridge = null;
        }
    }

    public void reset() {
        this.events.clear();
    }

    public void apply(Sink g1) {
        String sourceId = String.format("GraphDiff@%x", System.nanoTime());
        this.apply(sourceId, g1);
    }

    public void apply(String sourceId, Sink g1) {
        for (int i = 0; i < this.events.size(); ++i) {
            this.events.get(i).apply(sourceId, i, g1);
        }
    }

    public void reverse(Sink g2) {
        String sourceId = String.format("GraphDiff@%x", System.nanoTime());
        this.reverse(sourceId, g2);
    }

    public void reverse(String sourceId, Sink g2) {
        for (int i = this.events.size() - 1; i >= 0; --i) {
            this.events.get(i).reverse(sourceId, this.events.size() + 1 - i, g2);
        }
    }

    private void attributeDiff(ElementType type, Element e1, Element e2) {
        if (e1 == null && e2 == null) {
            return;
        }
        if (e1 == null) {
            e2.attributeKeys().forEach(key -> this.events.add(new AttributeAdded(type, e2.getId(), (String)key, e2.getAttribute((String)key))));
        } else if (e2 == null) {
            e1.attributeKeys().forEach(key -> this.events.add(new AttributeRemoved(type, e1.getId(), (String)key, e1.getAttribute((String)key))));
        } else {
            e2.attributeKeys().forEach(key -> {
                if (e1.hasAttribute((String)key)) {
                    Object o1 = e1.getAttribute((String)key);
                    Object o2 = e2.getAttribute((String)key);
                    if (!(o1 != null ? o1.equals(o2) : o2 == null)) {
                        this.events.add(new AttributeChanged(type, e1.getId(), (String)key, o2, o1));
                    }
                } else {
                    this.events.add(new AttributeAdded(type, e1.getId(), (String)key, e2.getAttribute((String)key)));
                }
            });
            e1.attributeKeys().forEach(key -> {
                if (!e2.hasAttribute((String)key)) {
                    this.events.add(new AttributeRemoved(type, e1.getId(), (String)key, e1.getAttribute((String)key)));
                }
            });
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < this.events.size(); ++i) {
            buffer.append(this.events.get(i).toString()).append("\n");
        }
        return buffer.toString();
    }

    public static void main(String ... args) throws Exception {
        AdjacencyListGraph g1 = new AdjacencyListGraph("g1");
        AdjacencyListGraph g2 = new AdjacencyListGraph("g2");
        Node a1 = g1.addNode("A");
        a1.setAttribute("attr1", "test");
        a1.setAttribute("attr2", 10.0);
        a1.setAttribute("attr3", 12);
        Node a2 = g2.addNode("A");
        a2.setAttribute("attr1", "test1");
        a2.setAttribute("attr2", 10.0);
        g2.addNode("B");
        g2.addNode("C");
        GraphDiff diff = new GraphDiff(g2, g1);
        System.out.println(diff);
    }

    private class Bridge
    implements Sink {
        Graph g;

        Bridge(Graph g) {
            this.g = g;
            g.addSink(this);
        }

        void end() {
            this.g.removeSink(this);
        }

        @Override
        public void graphAttributeAdded(String sourceId, long timeId, String attribute, Object value) {
            AttributeAdded e = new AttributeAdded(ElementType.GRAPH, null, attribute, value);
            GraphDiff.this.events.add(e);
        }

        @Override
        public void graphAttributeChanged(String sourceId, long timeId, String attribute, Object oldValue, Object newValue) {
            AttributeChanged e = new AttributeChanged(ElementType.GRAPH, null, attribute, newValue, this.g.getAttribute(attribute));
            GraphDiff.this.events.add(e);
        }

        @Override
        public void graphAttributeRemoved(String sourceId, long timeId, String attribute) {
            AttributeRemoved e = new AttributeRemoved(ElementType.GRAPH, null, attribute, this.g.getAttribute(attribute));
            GraphDiff.this.events.add(e);
        }

        @Override
        public void nodeAttributeAdded(String sourceId, long timeId, String nodeId, String attribute, Object value) {
            AttributeAdded e = new AttributeAdded(ElementType.NODE, nodeId, attribute, value);
            GraphDiff.this.events.add(e);
        }

        @Override
        public void nodeAttributeChanged(String sourceId, long timeId, String nodeId, String attribute, Object oldValue, Object newValue) {
            AttributeChanged e = new AttributeChanged(ElementType.NODE, nodeId, attribute, newValue, this.g.getNode(nodeId).getAttribute(attribute));
            GraphDiff.this.events.add(e);
        }

        @Override
        public void nodeAttributeRemoved(String sourceId, long timeId, String nodeId, String attribute) {
            AttributeRemoved e = new AttributeRemoved(ElementType.NODE, nodeId, attribute, this.g.getNode(nodeId).getAttribute(attribute));
            GraphDiff.this.events.add(e);
        }

        @Override
        public void edgeAttributeAdded(String sourceId, long timeId, String edgeId, String attribute, Object value) {
            AttributeAdded e = new AttributeAdded(ElementType.EDGE, edgeId, attribute, value);
            GraphDiff.this.events.add(e);
        }

        @Override
        public void edgeAttributeChanged(String sourceId, long timeId, String edgeId, String attribute, Object oldValue, Object newValue) {
            AttributeChanged e = new AttributeChanged(ElementType.EDGE, edgeId, attribute, newValue, this.g.getEdge(edgeId).getAttribute(attribute));
            GraphDiff.this.events.add(e);
        }

        @Override
        public void edgeAttributeRemoved(String sourceId, long timeId, String edgeId, String attribute) {
            AttributeRemoved e = new AttributeRemoved(ElementType.EDGE, edgeId, attribute, this.g.getEdge(edgeId).getAttribute(attribute));
            GraphDiff.this.events.add(e);
        }

        @Override
        public void nodeAdded(String sourceId, long timeId, String nodeId) {
            NodeAdded e = new NodeAdded(nodeId);
            GraphDiff.this.events.add(e);
        }

        @Override
        public void nodeRemoved(String sourceId, long timeId, String nodeId) {
            Node n = this.g.getNode(nodeId);
            n.attributeKeys().forEach(key -> this.nodeAttributeRemoved(sourceId, timeId, nodeId, (String)key));
            NodeRemoved e = new NodeRemoved(nodeId);
            GraphDiff.this.events.add(e);
        }

        @Override
        public void edgeAdded(String sourceId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
            EdgeAdded e = new EdgeAdded(edgeId, fromNodeId, toNodeId, directed);
            GraphDiff.this.events.add(e);
        }

        @Override
        public void edgeRemoved(String sourceId, long timeId, String edgeId) {
            Edge edge = this.g.getEdge(edgeId);
            edge.attributeKeys().forEach(key -> this.edgeAttributeRemoved(sourceId, timeId, edgeId, (String)key));
            EdgeRemoved e = new EdgeRemoved(edgeId, edge.getSourceNode().getId(), edge.getTargetNode().getId(), edge.isDirected());
            GraphDiff.this.events.add(e);
        }

        @Override
        public void graphCleared(String sourceId, long timeId) {
            GraphCleared e = new GraphCleared(this.g);
            GraphDiff.this.events.add(e);
        }

        @Override
        public void stepBegins(String sourceId, long timeId, double step) {
            StepBegins e = new StepBegins(this.g.getStep(), step);
            GraphDiff.this.events.add(e);
        }
    }

    protected class GraphCleared
    extends Event {
        byte[] data;

        public GraphCleared(Graph g) {
            this.data = null;
            try {
                FileSinkDGS sink = new FileSinkDGS();
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                GZIPOutputStream out = new GZIPOutputStream(bytes);
                sink.writeAll(g, out);
                out.flush();
                out.close();
                this.data = bytes.toByteArray();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void apply(String sourceId, long timeId, Sink g) {
            g.graphCleared(sourceId, timeId);
        }

        @Override
        public void reverse(String sourceId, long timeId, Sink g) {
            try {
                ByteArrayInputStream bytes = new ByteArrayInputStream(this.data);
                GZIPInputStream in = new GZIPInputStream(bytes);
                FileSourceDGS dgs = new FileSourceDGS();
                dgs.addSink(g);
                dgs.readAll(in);
                dgs.removeSink(g);
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public String toString() {
            return "cl";
        }
    }

    protected static enum ElementType {
        NODE,
        EDGE,
        GRAPH;

    }

    protected class EdgeRemoved
    extends EdgeAdded {
        public EdgeRemoved(String edgeId, String source, String target, boolean directed) {
            super(edgeId, source, target, directed);
        }

        @Override
        public void apply(String sourceId, long timeId, Sink g) {
            super.reverse(sourceId, timeId, g);
        }

        @Override
        public void reverse(String sourceId, long timeId, Sink g) {
            super.apply(sourceId, timeId, g);
        }

        @Override
        public String toString() {
            return String.format("de \"%s\"", this.edgeId);
        }
    }

    protected class NodeRemoved
    extends NodeAdded {
        public NodeRemoved(String nodeId) {
            super(nodeId);
        }

        @Override
        public void apply(String sourceId, long timeId, Sink g) {
            super.reverse(sourceId, timeId, g);
        }

        @Override
        public void reverse(String sourceId, long timeId, Sink g) {
            super.apply(sourceId, timeId, g);
        }

        @Override
        public String toString() {
            return String.format("dn \"%s\"", this.nodeId);
        }
    }

    protected class NodeAdded
    extends Event {
        String nodeId;

        public NodeAdded(String nodeId) {
            this.nodeId = nodeId;
        }

        @Override
        public void apply(String sourceId, long timeId, Sink g) {
            g.nodeAdded(sourceId, timeId, this.nodeId);
        }

        @Override
        public void reverse(String sourceId, long timeId, Sink g) {
            g.nodeRemoved(sourceId, timeId, this.nodeId);
        }

        public String toString() {
            return String.format("an \"%s\"", this.nodeId);
        }
    }

    protected class EdgeAdded
    extends Event {
        String edgeId;
        String source;
        String target;
        boolean directed;

        public EdgeAdded(String edgeId, String source, String target, boolean directed) {
            this.edgeId = edgeId;
            this.source = source;
            this.target = target;
            this.directed = directed;
        }

        @Override
        public void apply(String sourceId, long timeId, Sink g) {
            g.edgeAdded(sourceId, timeId, this.edgeId, this.source, this.target, this.directed);
        }

        @Override
        public void reverse(String sourceId, long timeId, Sink g) {
            g.edgeRemoved(sourceId, timeId, this.edgeId);
        }

        public String toString() {
            return String.format("ae \"%s\" \"%s\" %s \"%s\"", this.edgeId, this.source, this.directed ? ">" : "--", this.target);
        }
    }

    protected abstract class Event {
        protected Event() {
        }

        abstract void apply(String var1, long var2, Sink var4);

        abstract void reverse(String var1, long var2, Sink var4);
    }

    protected class AttributeRemoved
    extends ElementEvent {
        String attrId;
        Object oldValue;

        public AttributeRemoved(ElementType type, String elementId, String attrId, Object oldValue) {
            super(type, elementId);
            this.attrId = attrId;
            this.oldValue = oldValue;
        }

        @Override
        public void apply(String sourceId, long timeId, Sink g) {
            switch (this.type) {
                case NODE: {
                    g.nodeAttributeRemoved(sourceId, timeId, this.elementId, this.attrId);
                    break;
                }
                case EDGE: {
                    g.edgeAttributeRemoved(sourceId, timeId, this.elementId, this.attrId);
                    break;
                }
                case GRAPH: {
                    g.graphAttributeRemoved(sourceId, timeId, this.attrId);
                }
            }
        }

        @Override
        public void reverse(String sourceId, long timeId, Sink g) {
            switch (this.type) {
                case NODE: {
                    g.nodeAttributeAdded(sourceId, timeId, this.elementId, this.attrId, this.oldValue);
                    break;
                }
                case EDGE: {
                    g.edgeAttributeAdded(sourceId, timeId, this.elementId, this.attrId, this.oldValue);
                    break;
                }
                case GRAPH: {
                    g.graphAttributeAdded(sourceId, timeId, this.attrId, this.oldValue);
                }
            }
        }

        public String toString() {
            return String.format("%s -\"%s\":%s", this.toStringHeader(), this.attrId, this.toStringValue(this.oldValue));
        }
    }

    protected class AttributeChanged
    extends ElementEvent {
        String attrId;
        Object newValue;
        Object oldValue;

        public AttributeChanged(ElementType type, String elementId, String attrId, Object newValue, Object oldValue) {
            int i;
            Object o;
            super(type, elementId);
            this.attrId = attrId;
            this.newValue = newValue;
            this.oldValue = oldValue;
            if (newValue != null && newValue.getClass().isArray() && Array.getLength(newValue) > 0) {
                o = Array.newInstance(Array.get(newValue, 0).getClass(), Array.getLength(newValue));
                for (i = 0; i < Array.getLength(newValue); ++i) {
                    Array.set(o, i, Array.get(newValue, i));
                }
                this.newValue = o;
            }
            if (oldValue != null && oldValue.getClass().isArray() && Array.getLength(oldValue) > 0) {
                o = Array.newInstance(Array.get(oldValue, 0).getClass(), Array.getLength(oldValue));
                for (i = 0; i < Array.getLength(oldValue); ++i) {
                    Array.set(o, i, Array.get(oldValue, i));
                }
                this.oldValue = o;
            }
        }

        @Override
        public void apply(String sourceId, long timeId, Sink g) {
            switch (this.type) {
                case NODE: {
                    g.nodeAttributeChanged(sourceId, timeId, this.elementId, this.attrId, this.oldValue, this.newValue);
                    break;
                }
                case EDGE: {
                    g.edgeAttributeChanged(sourceId, timeId, this.elementId, this.attrId, this.oldValue, this.newValue);
                    break;
                }
                case GRAPH: {
                    g.graphAttributeChanged(sourceId, timeId, this.attrId, this.oldValue, this.newValue);
                }
            }
        }

        @Override
        public void reverse(String sourceId, long timeId, Sink g) {
            switch (this.type) {
                case NODE: {
                    g.nodeAttributeChanged(sourceId, timeId, this.elementId, this.attrId, this.newValue, this.oldValue);
                    break;
                }
                case EDGE: {
                    g.edgeAttributeChanged(sourceId, timeId, this.elementId, this.attrId, this.newValue, this.oldValue);
                    break;
                }
                case GRAPH: {
                    g.graphAttributeChanged(sourceId, timeId, this.attrId, this.newValue, this.oldValue);
                }
            }
        }

        public String toString() {
            return String.format("%s \"%s\":%s", this.toStringHeader(), this.attrId, this.toStringValue(this.newValue));
        }
    }

    protected class AttributeAdded
    extends ElementEvent {
        String attrId;
        Object value;

        public AttributeAdded(ElementType type, String elementId, String attrId, Object value) {
            super(type, elementId);
            this.attrId = attrId;
            this.value = value;
            if (value != null && value.getClass().isArray() && Array.getLength(value) > 0) {
                Object o = Array.newInstance(Array.get(value, 0).getClass(), Array.getLength(value));
                for (int i = 0; i < Array.getLength(value); ++i) {
                    Array.set(o, i, Array.get(value, i));
                }
                this.value = o;
            }
        }

        @Override
        public void apply(String sourceId, long timeId, Sink g) {
            switch (this.type) {
                case NODE: {
                    g.nodeAttributeAdded(sourceId, timeId, this.elementId, this.attrId, this.value);
                    break;
                }
                case EDGE: {
                    g.edgeAttributeAdded(sourceId, timeId, this.elementId, this.attrId, this.value);
                    break;
                }
                case GRAPH: {
                    g.graphAttributeAdded(sourceId, timeId, this.attrId, this.value);
                }
            }
        }

        @Override
        public void reverse(String sourceId, long timeId, Sink g) {
            switch (this.type) {
                case NODE: {
                    g.nodeAttributeRemoved(sourceId, timeId, this.elementId, this.attrId);
                    break;
                }
                case EDGE: {
                    g.edgeAttributeRemoved(sourceId, timeId, this.elementId, this.attrId);
                    break;
                }
                case GRAPH: {
                    g.graphAttributeRemoved(sourceId, timeId, this.attrId);
                }
            }
        }

        public String toString() {
            return String.format("%s +\"%s\":%s", this.toStringHeader(), this.attrId, this.toStringValue(this.value));
        }
    }

    protected class StepBegins
    extends Event {
        double newStep;
        double oldStep;

        public StepBegins(double oldStep, double newStep) {
            this.newStep = newStep;
            this.oldStep = oldStep;
        }

        @Override
        public void apply(String sourceId, long timeId, Sink g) {
            g.stepBegins(sourceId, timeId, this.newStep);
        }

        @Override
        public void reverse(String sourceId, long timeId, Sink g) {
            g.stepBegins(sourceId, timeId, this.oldStep);
        }

        public String toString() {
            return String.format("st %f", this.newStep);
        }
    }

    protected abstract class ElementEvent
    extends Event {
        ElementType type;
        String elementId;

        protected ElementEvent(ElementType type, String elementId) {
            this.type = type;
            this.elementId = elementId;
        }

        protected Element getElement(Graph g) {
            Element e;
            switch (this.type) {
                case NODE: {
                    e = g.getNode(this.elementId);
                    break;
                }
                case EDGE: {
                    e = g.getEdge(this.elementId);
                    break;
                }
                case GRAPH: {
                    e = g;
                    break;
                }
                default: {
                    e = null;
                }
            }
            if (e == null) {
                throw new ElementNotFoundException();
            }
            return e;
        }

        protected String toStringHeader() {
            String header;
            switch (this.type) {
                case NODE: {
                    header = "cn";
                    break;
                }
                case EDGE: {
                    header = "ce";
                    break;
                }
                case GRAPH: {
                    header = "cg";
                    break;
                }
                default: {
                    header = "??";
                }
            }
            return String.format("%s \"%s\"", header, this.elementId);
        }

        protected String toStringValue(Object o) {
            if (o == null) {
                return "null";
            }
            if (o instanceof String) {
                return "\"" + o.toString() + "\"";
            }
            if (o instanceof Number) {
                return o.toString();
            }
            return o.toString();
        }
    }
}

