/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.util.time;

import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Locale;
import java.util.regex.Pattern;

public abstract class ISODateComponent {
    protected final String directive;
    protected final String replace;
    public static final ISODateComponent ABBREVIATED_WEEKDAY_NAME = new NotImplementedComponent("%a", "\\w+[.]");
    public static final ISODateComponent FULL_WEEKDAY_NAME = new NotImplementedComponent("%A", "\\w+");
    public static final ISODateComponent ABBREVIATED_MONTH_NAME = new NotImplementedComponent("%b", "\\w+[.]");
    public static final ISODateComponent FULL_MONTH_NAME = new NotImplementedComponent("%B", "\\w+");
    public static final ISODateComponent LOCALE_DATE_AND_TIME = new NotImplementedComponent("%c", null);
    public static final ISODateComponent CENTURY = new NotImplementedComponent("%C", "\\d\\d");
    public static final ISODateComponent DAY_OF_MONTH_2_DIGITS = new FieldComponent("%d", "[012]\\d|3[01]", 5, "%02d");
    public static final ISODateComponent DATE = new AliasComponent("%D", "%m/%d/%y");
    public static final ISODateComponent DAY_OF_MONTH = new FieldComponent("%e", "\\d|[12]\\d|3[01]", 5, "%2d");
    public static final ISODateComponent DATE_ISO8601 = new AliasComponent("%F", "%Y-%m-%d");
    public static final ISODateComponent WEEK_BASED_YEAR_2_DIGITS = new FieldComponent("%g", "\\d\\d", 1, "%02d");
    public static final ISODateComponent WEEK_BASED_YEAR_4_DIGITS = new FieldComponent("%G", "\\d{4}", 1, "%04d");
    public static final ISODateComponent ABBREVIATED_MONTH_NAME_ALIAS = new AliasComponent("%h", "%b");
    public static final ISODateComponent HOUR_OF_DAY = new FieldComponent("%H", "[01]\\d|2[0123]", 11, "%02d");
    public static final ISODateComponent HOUR = new FieldComponent("%I", "0\\d|1[012]", 10, "%02d");
    public static final ISODateComponent DAY_OF_YEAR = new FieldComponent("%j", "[012]\\d\\d|3[0-5]\\d|36[0-6]", 6, "%03d");
    public static final ISODateComponent MILLISECOND = new FieldComponent("%k", "\\d{3}", 14, "%03d");
    public static final ISODateComponent EPOCH = new EpochComponent();
    public static final ISODateComponent MONTH = new FieldComponent("%m", "0[1-9]|1[012]", 2, -1, "%02d");
    public static final ISODateComponent MINUTE = new FieldComponent("%M", "[0-5]\\d", 12, "%02d");
    public static final ISODateComponent NEW_LINE = new AliasComponent("%n", "\n");
    public static final ISODateComponent AM_PM = new AMPMComponent();
    public static final ISODateComponent LOCALE_CLOCK_TIME_12_HOUR = new NotImplementedComponent("%r", "");
    public static final ISODateComponent HOUR_AND_MINUTE = new AliasComponent("%R", "%H:%M");
    public static final ISODateComponent SECOND = new FieldComponent("%S", "[0-5]\\d|60", 13, "%02d");
    public static final ISODateComponent TABULATION = new AliasComponent("%t", "\t");
    public static final ISODateComponent TIME_ISO8601 = new AliasComponent("%T", "%H:%M:%S");
    public static final ISODateComponent DAY_OF_WEEK_1_7 = new FieldComponent("%u", "[1-7]", 7, -1, "%1d");
    public static final ISODateComponent WEEK_OF_YEAR_FROM_SUNDAY = new FieldComponent("%U", "[0-4]\\d|5[0123]", 3, 1, "%2d");
    public static final ISODateComponent WEEK_NUMBER_ISO8601 = new NotImplementedComponent("%V", "0[1-9]|[2-4]\\d|5[0123]");
    public static final ISODateComponent DAY_OF_WEEK_0_6 = new FieldComponent("%w", "[0-6]", 7, "%01d");
    public static final ISODateComponent WEEK_OF_YEAR_FROM_MONDAY = new FieldComponent("%W", "[0-4]\\d|5[0123]", 3, "%02d");
    public static final ISODateComponent LOCALE_DATE_REPRESENTATION = new NotImplementedComponent("%x", "");
    public static final ISODateComponent LOCALE_TIME_REPRESENTATION = new NotImplementedComponent("%X", "");
    public static final ISODateComponent YEAR_2_DIGITS = new FieldComponent("%y", "\\d\\d", 1, "%02d");
    public static final ISODateComponent YEAR_4_DIGITS = new FieldComponent("%Y", "\\d{4}", 1, "%04d");
    public static final ISODateComponent UTC_OFFSET = new UTCOffsetComponent();
    public static final ISODateComponent LOCALE_TIME_ZONE_NAME = new NotImplementedComponent("%Z", "\\w*");
    public static final ISODateComponent PERCENT = new AliasComponent("%%", "%");

    public ISODateComponent(String directive, String replace) {
        this.directive = directive;
        this.replace = replace;
    }

    public String getDirective() {
        return this.directive;
    }

    public boolean isAlias() {
        return false;
    }

    public String getReplacement() {
        return this.replace;
    }

    public abstract void set(String var1, Calendar var2);

    public abstract String get(Calendar var1);

    public static class NotImplementedComponent
    extends ISODateComponent {
        public NotImplementedComponent(String shortcut, String replace) {
            super(shortcut, replace);
        }

        @Override
        public void set(String value, Calendar cal) {
            throw new Error("not implemented component");
        }

        @Override
        public String get(Calendar calendar) {
            throw new Error("not implemented component");
        }
    }

    public static class FieldComponent
    extends ISODateComponent {
        protected final int field;
        protected final int offset;
        protected final String format;

        public FieldComponent(String shortcut, String replace, int field, String format) {
            this(shortcut, replace, field, 0, format);
        }

        public FieldComponent(String shortcut, String replace, int field, int offset, String format) {
            super(shortcut, replace);
            this.field = field;
            this.offset = offset;
            this.format = format;
        }

        @Override
        public void set(String value, Calendar calendar) {
            while (value.charAt(0) == '0' && value.length() > 1) {
                value = value.substring(1);
            }
            int val = Integer.parseInt(value);
            calendar.set(this.field, val + this.offset);
        }

        @Override
        public String get(Calendar calendar) {
            return String.format(this.format, calendar.get(this.field));
        }
    }

    public static class AliasComponent
    extends ISODateComponent {
        public AliasComponent(String shortcut, String replace) {
            super(shortcut, replace);
        }

        @Override
        public boolean isAlias() {
            return true;
        }

        @Override
        public void set(String value, Calendar calendar) {
        }

        @Override
        public String get(Calendar calendar) {
            return "";
        }
    }

    public static class EpochComponent
    extends ISODateComponent {
        public EpochComponent() {
            super("%K", "\\d+");
        }

        @Override
        public void set(String value, Calendar calendar) {
            long e = Long.parseLong(value);
            calendar.setTimeInMillis(e);
        }

        @Override
        public String get(Calendar calendar) {
            return String.format("%d", calendar.getTimeInMillis());
        }
    }

    public static class AMPMComponent
    extends LocaleDependentComponent {
        public AMPMComponent() {
            super("%p", "AM|PM|am|pm");
        }

        @Override
        public void set(String value, Calendar calendar) {
            if (value.equalsIgnoreCase(this.symbols.getAmPmStrings()[0])) {
                calendar.set(9, 0);
            } else if (value.equalsIgnoreCase(this.symbols.getAmPmStrings()[1])) {
                calendar.set(9, 1);
            }
        }

        @Override
        public String get(Calendar calendar) {
            return this.symbols.getAmPmStrings()[calendar.get(9)];
        }
    }

    public static class UTCOffsetComponent
    extends ISODateComponent {
        public UTCOffsetComponent() {
            super("%z", "(?:[-+]\\d{4}|Z)");
        }

        @Override
        public void set(String value, Calendar calendar) {
            if (value.equals("Z")) {
                calendar.getTimeZone().setRawOffset(0);
            } else {
                String hs = value.substring(1, 3);
                String ms = value.substring(3, 5);
                if (hs.charAt(0) == '0') {
                    hs = hs.substring(1);
                }
                if (ms.charAt(0) == '0') {
                    ms = ms.substring(1);
                }
                int i = value.charAt(0) == '+' ? 1 : -1;
                int h = Integer.parseInt(hs);
                int m = Integer.parseInt(ms);
                calendar.getTimeZone().setRawOffset(i * (h * 60 + m) * 60000);
            }
        }

        @Override
        public String get(Calendar calendar) {
            int offset = calendar.getTimeZone().getRawOffset();
            String sign = "+";
            if (offset < 0) {
                sign = "-";
                offset = -offset;
            }
            int h = (offset /= 60000) / 60;
            int m = offset % 60;
            return String.format("%s%02d%02d", sign, h, m);
        }
    }

    protected static abstract class LocaleDependentComponent
    extends ISODateComponent {
        protected Locale locale;
        protected DateFormatSymbols symbols;

        public LocaleDependentComponent(String shortcut, String replace) {
            this(shortcut, replace, Locale.getDefault());
        }

        public LocaleDependentComponent(String shortcut, String replace, Locale locale) {
            super(shortcut, replace);
            this.locale = locale;
            this.symbols = DateFormatSymbols.getInstance(locale);
        }
    }

    public static class TextComponent
    extends ISODateComponent {
        String unquoted;

        public TextComponent(String value) {
            super(null, Pattern.quote(value));
            this.unquoted = value;
        }

        @Override
        public void set(String value, Calendar calendar) {
        }

        @Override
        public String get(Calendar calendar) {
            return this.unquoted;
        }
    }
}

