/*
 * Decompiled with CFR 0.152.
 */
package org.miv.pherd;

import java.util.ArrayList;
import java.util.Iterator;
import org.miv.mbox.MBoxListener;
import org.miv.mbox.MBoxStandalone;
import org.miv.pherd.Particle;
import org.miv.pherd.ParticleBox;
import org.miv.pherd.ParticleBoxListener;
import org.miv.pherd.geom.Point3;

public class ParticleBoxListenerProxy
implements ParticleBoxListener,
MBoxListener {
    protected MBoxStandalone events;
    protected ArrayList<ParticleBoxListener> listeners = new ArrayList();

    public ParticleBoxListenerProxy(ParticleBox box, boolean replay) {
        this.events = new MBoxStandalone(this);
        this.connect(box, replay);
    }

    public void disconnect(ParticleBox box) {
        box.removeParticleBoxListener(this);
    }

    public void connect(ParticleBox box, boolean replay) {
        box.addParticleBoxListener(this);
        if (replay) {
            this.replayBox(box);
        }
    }

    protected void replayBox(ParticleBox box) {
        Iterator<Object> particles = box.getParticleIdIterator();
        while (particles.hasNext()) {
            Particle p = box.getParticle(particles.next());
            Point3 P = p.getPosition();
            this.particleAdded(p.getId(), P.x, P.y, P.z);
            Iterator<String> i = p.getAttributeKeyIterator();
            if (i == null) continue;
            while (i.hasNext()) {
                String key = i.next();
                Object val = p.getAttribute(key);
                this.particleAttributeChanged(p.getId(), key, val, false);
            }
        }
    }

    public void addParticleBoxListener(ParticleBoxListener listener) {
        this.listeners.add(listener);
    }

    public void removeParticleBoxListener(ParticleBoxListener listener) {
        int index = this.listeners.indexOf(listener);
        if (index >= 0) {
            this.listeners.remove(index);
        }
    }

    public void checkEvents() {
        this.events.processMessages();
    }

    public void processMessage(String from, Object[] data) {
        if (data.length > 0) {
            if (data[0].equals("PA")) {
                double x = ((Number)data[2]).doubleValue();
                double y = ((Number)data[3]).doubleValue();
                double z = ((Number)data[4]).doubleValue();
                for (ParticleBoxListener listener : this.listeners) {
                    listener.particleAdded(data[1], x, y, z);
                }
            } else if (data[0].equals("PAC")) {
                String attribute = (String)data[2];
                boolean removed = (Boolean)data[4];
                for (ParticleBoxListener listener : this.listeners) {
                    listener.particleAttributeChanged(data[1], attribute, data[3], removed);
                }
            } else if (data[0].equals("PM")) {
                double x = ((Number)data[2]).doubleValue();
                double y = ((Number)data[3]).doubleValue();
                double z = ((Number)data[4]).doubleValue();
                for (ParticleBoxListener listener : this.listeners) {
                    listener.particleMoved(data[1], x, y, z);
                }
            } else if (data[0].equals("PR")) {
                for (ParticleBoxListener listener : this.listeners) {
                    listener.particleRemoved(data[1]);
                }
            } else if (data[0].equals("SF")) {
                int time = ((Number)data[1]).intValue();
                for (ParticleBoxListener listener : this.listeners) {
                    listener.stepFinished(time);
                }
            } else {
                if (data.length > 0 && data[0] instanceof String) {
                    throw new RuntimeException("ParticleBoxListenerProxy: uncaught message from " + from + " : " + data[0] + "[" + data.length + "]");
                }
                throw new RuntimeException("ParticleBoxListenerProxy: uncaught message from " + from + " : [" + data.length + "]");
            }
        }
    }

    public void particleAdded(Object id, double x, double y, double z) {
        this.events.post("me", "PA", id, x, y, z);
    }

    public void particleAttributeChanged(Object id, String attribute, Object newValue, boolean removed) {
        this.events.post("me", "PAC", id, attribute, newValue, removed);
    }

    public void particleMoved(Object id, double x, double y, double z) {
        this.events.post("me", "PM", id, x, y, z);
    }

    public void particleRemoved(Object id) {
        this.events.post("me", "PR", id);
    }

    public void stepFinished(int time) {
        this.events.post("me", "SF", time);
    }
}

