/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.service.json.deserialize;

import com.casper.sdk.types.CLByteArrayInfo;
import com.casper.sdk.types.CLOptionTypeInfo;
import com.casper.sdk.types.CLOptionValue;
import com.casper.sdk.types.CLType;
import com.casper.sdk.types.CLTypeInfo;
import com.casper.sdk.types.CLValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;

public class CLValueJsonDeserializer
extends JsonDeserializer<CLValue> {
    public CLValue deserialize(JsonParser p, DeserializationContext context) throws IOException {
        ObjectCodec codec = p.getCodec();
        return this.getClValue(codec.readTree(p));
    }

    private CLValue getClValue(TreeNode treeNode) {
        TreeNode typeNode = treeNode.get("cl_type");
        TextNode bytesNode = (TextNode)treeNode.get("bytes");
        CLTypeInfo clTypeInfo = this.getCLTypeInfo(typeNode);
        Object parsed = this.getParsed(treeNode.get("parsed"), clTypeInfo);
        if (clTypeInfo instanceof CLOptionTypeInfo) {
            return new CLOptionValue(bytesNode.asText(), (CLOptionTypeInfo)clTypeInfo, parsed);
        }
        return new CLValue(bytesNode.asText(), clTypeInfo, parsed);
    }

    private CLTypeInfo getCLTypeInfo(TreeNode typeNode) {
        CLType clType = this.getClType(typeNode);
        if (CLType.BYTE_ARRAY == clType) {
            TreeNode sizeNode = typeNode.get(CLType.BYTE_ARRAY.getJsonName());
            int size = 0;
            if (sizeNode instanceof NumericNode) {
                size = ((NumericNode)sizeNode).asInt();
            }
            return new CLByteArrayInfo(size);
        }
        if (CLType.OPTION == clType) {
            TreeNode optionNode = typeNode.get(CLType.OPTION.getJsonName());
            CLTypeInfo interType = this.getCLTypeInfo(optionNode);
            return new CLOptionTypeInfo(interType);
        }
        return new CLTypeInfo(clType);
    }

    private CLType getClType(TreeNode typeNode) {
        if (typeNode instanceof TextNode) {
            return CLType.fromString(((TextNode)typeNode).asText());
        }
        String typeName = (String)typeNode.fieldNames().next();
        return CLType.fromString(typeName);
    }

    private Object getParsed(TreeNode treeNode, CLTypeInfo clTypeInfo) {
        if (treeNode instanceof TextNode) {
            return ((TextNode)treeNode).asText();
        }
        if (treeNode instanceof NumericNode && CLType.isNumeric(clTypeInfo.getType())) {
            return ((NumericNode)treeNode).bigIntegerValue();
        }
        return null;
    }
}

