/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.service.json.serialize;

import com.casper.sdk.types.CLValue;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;

public class CLValueJsonSerializer
extends JsonSerializer<CLValue> {
    public void serialize(CLValue value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeFieldName("cl_type");
        gen.getCodec().writeValue(gen, (Object)value.getCLTypeInfo());
        gen.writeFieldName("bytes");
        gen.writeString(value.toHex());
        this.writeParsed(value, gen);
        gen.writeEndObject();
    }

    private void writeParsed(CLValue value, JsonGenerator gen) throws IOException {
        if (value.getParsed() != null) {
            gen.writeFieldName("parsed");
            if (value.getParsed() instanceof Number) {
                gen.writeNumber(value.getParsed().toString());
            } else {
                gen.writeString(value.getParsed().toString());
            }
        }
    }
}

