/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.service.serialization.cltypes;

import com.casper.sdk.exceptions.ConversionException;
import com.casper.sdk.service.serialization.cltypes.TypesSerializer;
import com.casper.sdk.service.serialization.util.NumberUtils;
import java.math.BigInteger;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;

abstract class FixedLengthNumberSerializer
implements TypesSerializer {
    private final int maxBytes;
    private final boolean signed;

    public FixedLengthNumberSerializer(int maxBytes, boolean signed) {
        this.maxBytes = maxBytes;
        this.signed = signed;
    }

    @Override
    public byte[] serialize(Object toSerialize) {
        BigInteger bigInt = NumberUtils.toBigInteger(toSerialize);
        byte[] bytes = bigInt.toByteArray();
        if (bytes.length <= this.maxBytes) {
            bytes = this.zeroPad(bytes, this.signed && bigInt.signum() == -1);
        } else if (bytes.length == this.maxBytes + 1 && bytes[0] == 0) {
            bytes = this.trimLeadingZero(bytes);
        } else {
            throw new ConversionException(bigInt + " exceeds " + this.maxBytes + " bytes length");
        }
        ArrayUtils.reverse((byte[])bytes);
        return bytes;
    }

    private byte[] trimLeadingZero(byte[] bytes) {
        byte[] copy = new byte[this.maxBytes];
        System.arraycopy(bytes, bytes.length - this.maxBytes, copy, 0, this.maxBytes);
        return copy;
    }

    private byte[] zeroPad(byte[] bytes, boolean negative) {
        if (bytes.length < this.maxBytes) {
            byte[] copy = new byte[this.maxBytes];
            Arrays.fill(copy, 0, this.maxBytes - bytes.length, (byte)(negative ? 255 : 0));
            System.arraycopy(bytes, 0, copy, this.maxBytes - bytes.length, bytes.length);
            return copy;
        }
        return bytes;
    }
}

