/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.service.serialization.types;

import com.casper.sdk.service.serialization.types.ByteSerializer;
import com.casper.sdk.service.serialization.types.ByteSerializerFactory;
import com.casper.sdk.service.serialization.util.ByteArrayBuilder;
import com.casper.sdk.service.serialization.util.ByteUtils;
import com.casper.sdk.types.Deploy;
import com.casper.sdk.types.DeployExecutable;

class DeployByteSerializer
implements ByteSerializer<Deploy> {
    private final ByteSerializerFactory factory;

    DeployByteSerializer(ByteSerializerFactory factory) {
        this.factory = factory;
    }

    @Override
    public byte[] toBytes(Deploy deploy) {
        ByteArrayBuilder builder = new ByteArrayBuilder();
        builder.append(this._toBytes(deploy.getHeader())).append(this._toBytes(deploy.getHash())).append(this.serializeBody((DeployExecutable)deploy.getPayment(), (DeployExecutable)deploy.getSession())).append(this._toBytes(deploy.getApprovals()));
        return builder.toByteArray();
    }

    @Override
    public Class<Deploy> getType() {
        return Deploy.class;
    }

    byte[] serializeBody(DeployExecutable payment, DeployExecutable session) {
        return ByteUtils.concat(this._toBytes(payment), this._toBytes(session));
    }

    private byte[] _toBytes(Object source) {
        return this.factory.getByteSerializer(source).toBytes(source);
    }
}

