/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.service.serialization.util;

import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

public class ByteUtils {
    public static byte[] concat(byte[] ... arrays) {
        int len = 0;
        for (byte[] array : arrays) {
            len += array != null ? array.length : 0;
        }
        byte[] c = new byte[len];
        int pos = 0;
        for (byte[] array : arrays) {
            if (array == null) continue;
            System.arraycopy(array, 0, c, pos, array.length);
            pos += array.length;
        }
        return c;
    }

    public static byte[] decodeHex(String hex) {
        try {
            return Hex.decodeHex((char[])hex.toCharArray());
        }
        catch (DecoderException e) {
            throw new IllegalArgumentException("Unable to decode: \"" + hex + "\" length " + hex.length(), e);
        }
    }

    public static String encodeHexString(byte[] bytes) {
        return Hex.encodeHexString((byte[])bytes);
    }

    public static byte[] lastNBytes(byte[] toTruncate, int length) {
        byte[] lastNBytes = new byte[length];
        int start = toTruncate.length - length;
        System.arraycopy(toTruncate, start, lastNBytes, 0, length);
        return lastNBytes;
    }

    public static byte[] toByteArray(Number toByteInArray) {
        return new byte[]{toByteInArray.byteValue()};
    }
}

