/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.service.signing;

import com.casper.sdk.exceptions.SignatureException;
import com.casper.sdk.service.signing.AbstractKeyPairBuilder;
import com.casper.sdk.types.Algorithm;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.spec.KeySpec;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECPoint;

public class Secp256k1KeyPairBuilder
extends AbstractKeyPairBuilder {
    public static final String CURVE_NAME = "secp256k1";
    public static final String ALGORITHM = "ECDSA";

    Secp256k1KeyPairBuilder() {
        super(Algorithm.SECP256K1);
    }

    @Override
    public KeyPair generateKeyPair() {
        return this.generateKeyPair(ALGORITHM, CURVE_NAME);
    }

    @Override
    public boolean isSupportedPublicKey(PublicKey publicKey) {
        return publicKey instanceof BCECPublicKey && ALGORITHM.equalsIgnoreCase(publicKey.getAlgorithm());
    }

    @Override
    public PublicKey createPublicKey(byte[] publicKey) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM, "BC");
            ECNamedCurveParameterSpec ecSpec = ECNamedCurveTable.getParameterSpec((String)CURVE_NAME);
            ECPoint point = ecSpec.getCurve().decodePoint(publicKey);
            ECPublicKeySpec pubSpec = new ECPublicKeySpec(point, (ECParameterSpec)ecSpec);
            return keyFactory.generatePublic((KeySpec)pubSpec);
        }
        catch (Exception e) {
            throw new SignatureException(e);
        }
    }
}

