/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.types;

import com.casper.sdk.service.serialization.util.ByteUtils;
import com.casper.sdk.types.CLType;
import com.casper.sdk.types.CLTypeInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

abstract class AbstractCLType {
    @JsonProperty(value="cl_type")
    private final CLTypeInfo typeInfo;

    protected AbstractCLType(CLTypeInfo typeInfo) {
        Objects.requireNonNull(typeInfo, "type cannot be null");
        this.typeInfo = typeInfo;
    }

    public static byte[] fromString(String hex) {
        return ByteUtils.decodeHex(hex);
    }

    public static String toHex(byte[] bytes) {
        return ByteUtils.encodeHexString(bytes);
    }

    @JsonProperty(value="cl_type")
    public CLTypeInfo getCLTypeInfo() {
        return this.typeInfo;
    }

    @JsonIgnore
    public CLType getCLType() {
        return this.typeInfo.getType();
    }

    public String toHex() {
        return AbstractCLType.toHex(this.getBytes());
    }

    public abstract byte[] getBytes();
}

