/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.types;

import com.casper.sdk.service.serialization.util.ByteUtils;
import com.casper.sdk.types.AccessRights;
import com.casper.sdk.types.HasTag;
import java.util.regex.Pattern;

public class URef
implements HasTag {
    private final byte[] bytes;
    private final AccessRights accessRights;

    public URef(byte[] bytes, AccessRights accessRights) {
        this.bytes = bytes;
        this.accessRights = accessRights;
    }

    public URef(String uRef) {
        this(URef.getBytes(uRef), URef.getAccessRights(uRef));
    }

    public URef(String hex, AccessRights accessRights) {
        this(ByteUtils.decodeHex(hex), accessRights);
    }

    private static byte[] getBytes(String uRef) {
        String[] split = uRef.split(Pattern.quote("-"));
        if ("uref".equals(split[0])) {
            return ByteUtils.decodeHex(split[1]);
        }
        throw new IllegalArgumentException("invalid URef " + uRef);
    }

    private static AccessRights getAccessRights(String uRef) {
        return AccessRights.valueOf(Character.getNumericValue(uRef.charAt(uRef.length() - 1)));
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public AccessRights getAccessRights() {
        return this.accessRights != null ? this.accessRights : AccessRights.NONE;
    }

    @Override
    public int getTag() {
        return 2;
    }

    public String toString() {
        return String.format("uref-%s-%03d", ByteUtils.encodeHexString(this.getBytes()), (int)this.getAccessRights().getBits());
    }
}

