/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk;

import com.casper.sdk.Constants;
import com.casper.sdk.exceptions.CasperException;
import com.casper.sdk.exceptions.ConversionException;
import com.casper.sdk.exceptions.ValueNotFoundException;
import com.casper.sdk.service.hash.HashService;
import com.casper.sdk.service.http.rpc.HttpMethods;
import com.casper.sdk.service.http.rpc.NodeClient;
import com.casper.sdk.service.json.JsonConversionService;
import com.casper.sdk.service.metrics.MetricsService;
import com.casper.sdk.service.serialization.cltypes.CLValueBuilder;
import com.casper.sdk.service.serialization.cltypes.TypesFactory;
import com.casper.sdk.service.serialization.types.ByteSerializerFactory;
import com.casper.sdk.service.serialization.util.ByteUtils;
import com.casper.sdk.service.signing.SigningService;
import com.casper.sdk.types.CLPublicKey;
import com.casper.sdk.types.ContractHash;
import com.casper.sdk.types.Deploy;
import com.casper.sdk.types.DeployExecutable;
import com.casper.sdk.types.DeployNamedArgBuilder;
import com.casper.sdk.types.DeployParams;
import com.casper.sdk.types.DeployService;
import com.casper.sdk.types.Digest;
import com.casper.sdk.types.ModuleBytes;
import com.casper.sdk.types.StoredContractByHash;
import com.casper.sdk.types.Transfer;
import com.casper.sdk.types.URef;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.Map;
import java.util.Random;
import org.apache.commons.io.IOUtils;

public class CasperSdk {
    private final JsonConversionService jsonConversionService = new JsonConversionService();
    private final HashService hashService = new HashService();
    private final SigningService signingService = new SigningService();
    private final DeployService deployService = new DeployService(new ByteSerializerFactory(), this.hashService, this.jsonConversionService, this.signingService, new TypesFactory());
    private final NodeClient nodeClient;
    private final MetricsService metricsService;

    public CasperSdk(String url, int port) {
        HttpMethods httpMethods = new HttpMethods(this.jsonConversionService, url, port);
        this.nodeClient = new NodeClient(this.deployService, this.hashService, httpMethods);
        this.metricsService = new MetricsService(httpMethods);
    }

    public String getAccountInfo(PublicKey accountKey) {
        return this.nodeClient.getAccountInfo(this.signingService.toClPublicKey(accountKey).toAccountHex());
    }

    public ContractHash getContractHash(PublicKey accountKey) {
        String erc20;
        Map map;
        String accountInfo = this.getAccountInfo(accountKey);
        try {
            map = this.jsonConversionService.fromJson(accountInfo, Map.class);
        }
        catch (IOException e) {
            throw new ConversionException(e);
        }
        Object namedKeys = map.get("named_keys");
        if (namedKeys instanceof Map && (erc20 = (String)((Map)namedKeys).get("ERC20")) != null && erc20.length() > 5) {
            return new ContractHash(ByteUtils.decodeHex(erc20.substring(5)));
        }
        throw new ValueNotFoundException("'ERC20' not found in account info 'named_keys'");
    }

    public BigInteger getAccountBalance(PublicKey accountKey) {
        return this.nodeClient.getAccountBalance(this.signingService.toClPublicKey(accountKey).toAccountHex());
    }

    public URef getAccountMainPurseURef(PublicKey accountKey) {
        return this.nodeClient.getAccountMainPurseURef(this.signingService.toClPublicKey(accountKey).toAccountHex());
    }

    public String getStateRootHash() {
        return this.nodeClient.getStateRootHash();
    }

    public String getAccountHash(PublicKey accountKey) {
        return ByteUtils.encodeHexString(this.hashService.getAccountHash(this.getPublicKeyBytes(accountKey)));
    }

    public String getAuctionInfo() {
        return this.nodeClient.getAuctionInfo();
    }

    public String getNodeStatus() {
        return this.nodeClient.getNodeStatus();
    }

    public String getNodePeers() {
        return this.nodeClient.getNodePeers();
    }

    public Deploy deployFromJson(InputStream jsonStream) throws IOException {
        return this.jsonConversionService.fromJson(jsonStream, Deploy.class);
    }

    public Deploy deployFromJson(String json) throws IOException {
        return this.jsonConversionService.fromJson(json, Deploy.class);
    }

    public Deploy makeValidatorDelegation(DeployParams deployParams, Number amount, PublicKey delegatorPublicKey, PublicKey validatorPublicKey, InputStream wasmIn) {
        return this.makeDeploy(deployParams, new ModuleBytes(this.readWasm(wasmIn), new DeployNamedArgBuilder().add("amount", CLValueBuilder.u512(amount)).add("delegator", CLValueBuilder.publicKey(delegatorPublicKey)).add("validator", CLValueBuilder.publicKey(validatorPublicKey)).build()), this.standardPayment(Integer.MAX_VALUE));
    }

    public Deploy makeValidatorDelegationWithdrawal(DeployParams deployParams, Number amount, PublicKey delegatorPublicKey, PublicKey validatorPublicKey, InputStream wasmIn) {
        return this.makeDeploy(deployParams, new ModuleBytes(this.readWasm(wasmIn), new DeployNamedArgBuilder().add("amount", CLValueBuilder.u512(amount)).add("delegator", CLValueBuilder.publicKey(delegatorPublicKey)).add("validator", CLValueBuilder.publicKey(validatorPublicKey)).build()), this.standardPayment(Integer.MAX_VALUE));
    }

    public Deploy makeTransferDeploy(DeployParams deployParams, DeployExecutable session, DeployExecutable payment) {
        if (session instanceof Transfer) {
            return this.makeDeploy(deployParams, session, payment);
        }
        throw new IllegalArgumentException("The session is not a Transfer ExecutableDeployItem");
    }

    public Deploy makeDeploy(DeployParams deployParams, DeployExecutable session, DeployExecutable payment) {
        return this.deployService.makeDeploy(deployParams, session, payment);
    }

    public Deploy signDeploy(Deploy deploy, KeyPair signKeyPair) {
        return this.deployService.signDeploy(deploy, signKeyPair);
    }

    public Deploy getDeploy(Digest deployHash) {
        return this.nodeClient.getDeploy(deployHash);
    }

    public Digest putDeploy(Deploy signedDeploy) {
        return new Digest(this.nodeClient.putDeploy(signedDeploy));
    }

    public KeyPair loadKeyPair(InputStream publicKeyIn, InputStream privateKeyIn) {
        return this.signingService.loadKeyPair(publicKeyIn, privateKeyIn);
    }

    public <T extends Key> T loadKey(InputStream in) {
        return this.signingService.loadKey(in);
    }

    public byte[] getPublicKeyBytes(PublicKey publicKey) {
        return this.signingService.toClPublicKey(publicKey).toAccount();
    }

    public ModuleBytes standardPayment(Number paymentAmount) {
        return this.deployService.standardPayment(paymentAmount);
    }

    public Transfer newTransfer(Number amount, PublicKey target, Number id) {
        return this.deployService.newTransfer(amount, this.toCLPublicKey(target), id);
    }

    public String deployToJson(Deploy deploy) throws IOException {
        return this.jsonConversionService.toJson(deploy);
    }

    public String getNodeMetrics() {
        return this.metricsService.getMetrics();
    }

    public PublicKey createPublicKey(String publicKeyHex) {
        return this.signingService.fromClPublicKey(new CLPublicKey(publicKeyHex));
    }

    public CLPublicKey toCLPublicKey(PublicKey publicKey) {
        return this.signingService.toClPublicKey(publicKey);
    }

    public String getLatestBlockInfo() {
        return this.nodeClient.getLatestBlockInfo();
    }

    public String getBlockInfo(Digest hash) {
        return this.nodeClient.getBlockInfo(hash);
    }

    public String getBlockInfoByHeight(Number height) {
        return this.nodeClient.getBlockInfoByHeight(height);
    }

    public String getBlockTransfers() {
        return this.nodeClient.getBlockTransfers();
    }

    public String getEraInfoBySwitchBlock() {
        return this.nodeClient.getEraInfoBySwitchBlock();
    }

    public String getRpcSchema() {
        return this.nodeClient.getRpcSchema();
    }

    public Deploy makeValidatorAuctionBid(DeployParams deployParams, Number amount, int delegationRate, PublicKey validatorPublicKey, InputStream wasmIn) {
        return this.makeDeploy(deployParams, new ModuleBytes(this.readWasm(wasmIn), new DeployNamedArgBuilder().add("amount", CLValueBuilder.u512(amount)).add("delegation_rate", CLValueBuilder.u8(delegationRate)).add("public_key", CLValueBuilder.publicKey(validatorPublicKey)).build()), this.standardPayment(Integer.MAX_VALUE));
    }

    public Deploy makeNativeTransfer(DeployParams deployParams, Number amount, PublicKey target, Number correlationId) {
        return this.makeDeploy(deployParams, this.newTransfer(amount, target, correlationId != null ? (Number)correlationId : (Number)this.getRandomCorrelationId()), this.standardPayment(100000000));
    }

    public Deploy makeValidatorAuctionBidWithdrawal(DeployParams deployParams, Number amount, PublicKey validatorPublicKey, InputStream wasmIn, URef unbondPurse) {
        return this.makeDeploy(deployParams, new ModuleBytes(this.readWasm(wasmIn), new DeployNamedArgBuilder().add("amount", CLValueBuilder.u32(amount)).add("public_key", CLValueBuilder.publicKey(validatorPublicKey)).add("unbond_purse", CLValueBuilder.uRefKey(unbondPurse.getBytes())).build()), this.standardPayment(Integer.MAX_VALUE));
    }

    public Deploy makeInstallContract(DeployParams deployParams, Number payment, InputStream wasmIn, int tokenDecimals, String tokenName, String tokenSymbol, Number tokenTotalSupply) {
        return this.makeDeploy(deployParams, new ModuleBytes(this.readWasm(wasmIn), new DeployNamedArgBuilder().add("token_decimals", CLValueBuilder.u8(tokenDecimals)).add("token_name", CLValueBuilder.string(tokenName)).add("token_symbol", CLValueBuilder.string(tokenSymbol)).add("create_deploy_arg", CLValueBuilder.u256(tokenTotalSupply)).build()), this.standardPayment(payment));
    }

    public Deploy makeInvokeContract(DeployParams deployParams, Number payment, Number amount, PublicKey operatorKey, PublicKey recipient) {
        return this.makeDeploy(deployParams, new StoredContractByHash(this.getContractHash(operatorKey), "transfer", new DeployNamedArgBuilder().add("amount", CLValueBuilder.u256(amount)).add("recipient", CLValueBuilder.publicKey(recipient)).build()), this.standardPayment(payment));
    }

    private int getRandomCorrelationId() {
        return new Random().nextInt(Constants.MAX_TRANSFER_ID - 1) + 1;
    }

    private byte[] readWasm(InputStream wasmIn) {
        try {
            return IOUtils.toByteArray((InputStream)wasmIn);
        }
        catch (IOException e) {
            throw new CasperException("Error loading wasm", e);
        }
    }
}

