/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.service.json.deserialize;

import com.casper.sdk.exceptions.ConversionException;
import com.casper.sdk.types.CLValue;
import com.casper.sdk.types.ContractHash;
import com.casper.sdk.types.DeployExecutable;
import com.casper.sdk.types.DeployNamedArg;
import com.casper.sdk.types.ModuleBytes;
import com.casper.sdk.types.StoredContractByHash;
import com.casper.sdk.types.StoredContractByName;
import com.casper.sdk.types.Transfer;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

class DeployExecutableFactory {
    private static final Map<String, AbstractDeployExecutableJsonFactory<?>> argsFactoryMap = new HashMap();

    DeployExecutableFactory() {
    }

    <T extends DeployExecutable> T create(String fieldName, String entryPoint, TreeNode treeNode, ObjectCodec codec) {
        AbstractDeployExecutableJsonFactory<?> jsonDeserializer = argsFactoryMap.get(entryPoint);
        if (jsonDeserializer != null) {
            return (T)jsonDeserializer.create(fieldName, entryPoint, treeNode, codec);
        }
        throw new IllegalArgumentException(fieldName + " is not a valid DeployExecutable field");
    }

    static {
        argsFactoryMap.put("ModuleBytes", new ModuleBytesFactory());
        argsFactoryMap.put("StoredContractByName", new StoredContractByNameFactory());
        argsFactoryMap.put("StoredContractByHash", new StoredContractByHashFactory());
        argsFactoryMap.put("Transfer", new TransferJsonFactory());
        argsFactoryMap.put("args", new DefaultDeployExecutableJsonFactory());
    }

    private static class StoredContractByHashFactory
    extends AbstractDeployExecutableJsonFactory<StoredContractByHash> {
        private StoredContractByHashFactory() {
        }

        @Override
        StoredContractByHash create(String fieldName, String entryPoint, TreeNode treeNode, ObjectCodec codec) {
            try {
                List<DeployNamedArg> args = this.convertArgs(this.getArgsNode(entryPoint, treeNode), codec);
                return new StoredContractByHash(this.getFieldValue(entryPoint, treeNode, "hash").map(ContractHash::new).orElse(null), this.getFieldValue(entryPoint, treeNode, "entry_point").orElse(null), args);
            }
            catch (Exception e) {
                throw new ConversionException(e);
            }
        }

        @Override
        protected TreeNode getArgsNode(String entryPoint, TreeNode treeNode) {
            return this.getFieldNode(entryPoint, treeNode, "args");
        }

        @Override
        protected Class<StoredContractByHash> getType() {
            return StoredContractByHash.class;
        }
    }

    private static class StoredContractByNameFactory
    extends AbstractDeployExecutableJsonFactory<StoredContractByName> {
        private StoredContractByNameFactory() {
        }

        @Override
        StoredContractByName create(String fieldName, String entryPoint, TreeNode treeNode, ObjectCodec codec) {
            try {
                List<DeployNamedArg> args = this.convertArgs(this.getArgsNode(entryPoint, treeNode), codec);
                return new StoredContractByName(fieldName, entryPoint, this.convertModuleBytes(treeNode), args);
            }
            catch (Exception e) {
                throw new ConversionException(e);
            }
        }

        @Override
        protected TreeNode getArgsNode(String entryPoint, TreeNode treeNode) {
            return this.getFieldNode(entryPoint, treeNode, "args");
        }

        @Override
        protected Class<StoredContractByName> getType() {
            return StoredContractByName.class;
        }
    }

    private static class ModuleBytesFactory
    extends AbstractDeployExecutableJsonFactory<ModuleBytes> {
        private ModuleBytesFactory() {
        }

        @Override
        ModuleBytes create(String fieldName, String entryPoint, TreeNode treeNode, ObjectCodec codec) {
            try {
                List<DeployNamedArg> args = this.convertArgs(this.getArgsNode(entryPoint, treeNode), codec);
                return new ModuleBytes(this.convertModuleBytes(treeNode), args);
            }
            catch (Exception e) {
                throw new ConversionException(e);
            }
        }

        @Override
        protected TreeNode getArgsNode(String entryPoint, TreeNode treeNode) {
            return this.getFieldNode(entryPoint, treeNode, "args");
        }

        @Override
        protected Class<ModuleBytes> getType() {
            return ModuleBytes.class;
        }
    }

    private static class DefaultDeployExecutableJsonFactory
    extends AbstractDeployExecutableJsonFactory<DeployExecutable> {
        private DefaultDeployExecutableJsonFactory() {
        }

        @Override
        protected TreeNode getArgsNode(String fieldName, TreeNode treeNode) {
            return treeNode.get(fieldName);
        }

        @Override
        protected Class<DeployExecutable> getType() {
            return DeployExecutable.class;
        }
    }

    private static class TransferJsonFactory
    extends AbstractDeployExecutableJsonFactory<Transfer> {
        private TransferJsonFactory() {
        }

        @Override
        protected TreeNode getArgsNode(String fieldName, TreeNode treeNode) {
            return treeNode.get(fieldName).get("args");
        }

        @Override
        protected Class<Transfer> getType() {
            return Transfer.class;
        }
    }

    private static abstract class AbstractDeployExecutableJsonFactory<T extends DeployExecutable> {
        private AbstractDeployExecutableJsonFactory() {
        }

        T create(String fieldName, String entryPoint, TreeNode treeNode, ObjectCodec codec) {
            try {
                List<DeployNamedArg> args = this.convertArgs(this.getArgsNode(entryPoint, treeNode), codec);
                return (T)((DeployExecutable)this.getType().getConstructor(List.class).newInstance(args));
            }
            catch (Exception e) {
                throw new ConversionException(e);
            }
        }

        protected abstract TreeNode getArgsNode(String var1, TreeNode var2);

        protected abstract Class<T> getType();

        protected List<DeployNamedArg> convertArgs(TreeNode argsNode, ObjectCodec codec) throws IOException {
            ArrayList<DeployNamedArg> args = new ArrayList<DeployNamedArg>();
            if (argsNode != null && argsNode.isArray()) {
                for (int i = 0; i < argsNode.size(); ++i) {
                    JsonParser p = argsNode.get(i).traverse();
                    if (p.getCodec() == null) {
                        p.setCodec(codec);
                    }
                    DeployNamedArg deployNamedArg = (DeployNamedArg)p.readValueAs(DeployNamedArg.class);
                    args.add(deployNamedArg);
                }
            }
            return args;
        }

        protected TreeNode getFieldNode(String entryPoint, TreeNode treeNode, String fieldName) {
            TreeNode childNode = treeNode.get(entryPoint);
            if (childNode == null) {
                childNode = treeNode;
            }
            return childNode.get(fieldName);
        }

        protected Optional<String> getFieldValue(String entryPoint, TreeNode treeNode, String fieldName) {
            TreeNode fieldNode = this.getFieldNode(entryPoint, treeNode, fieldName);
            if (fieldNode instanceof TextNode) {
                return Optional.of(((TextNode)fieldNode).textValue());
            }
            return Optional.empty();
        }

        protected byte[] convertModuleBytes(TreeNode treeNode) {
            TreeNode textNode;
            TreeNode moduleBytes = treeNode.get(ModuleBytes.class.getSimpleName());
            if (moduleBytes instanceof ObjectNode && (textNode = moduleBytes.get("module_bytes")) instanceof TextNode) {
                return CLValue.fromString(((TextNode)textNode).textValue());
            }
            return null;
        }
    }
}

