/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.service.json.serialize;

import com.casper.sdk.types.CLValue;
import com.casper.sdk.types.DeployExecutable;
import com.casper.sdk.types.ModuleBytes;
import com.casper.sdk.types.StoredContractByHash;
import com.casper.sdk.types.Transfer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;

public class DeployExecutableJsonSerializer
extends JsonSerializer<DeployExecutable> {
    public void serialize(DeployExecutable value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (value instanceof Transfer) {
            this.writeTransfer((Transfer)value, gen);
        } else if (value instanceof StoredContractByHash) {
            this.writeStoredContractByHash((StoredContractByHash)value, gen);
        } else if (value instanceof ModuleBytes) {
            this.writePayment((ModuleBytes)value, gen);
        } else {
            this.writeArgs(value, gen);
        }
    }

    private void writePayment(ModuleBytes payment, JsonGenerator gen) throws IOException {
        gen.writeStartObject();
        gen.writeFieldName("ModuleBytes");
        gen.writeStartObject();
        gen.writeFieldName("module_bytes");
        gen.writeString(CLValue.toHex(payment.getModuleBytes()));
        this.writeArgs(payment, gen);
        gen.writeEndObject();
        gen.writeEndObject();
    }

    private void writeStoredContractByHash(StoredContractByHash storedContractByHash, JsonGenerator gen) throws IOException {
        gen.writeStartObject();
        gen.writeFieldName("StoredContractByHash");
        gen.writeStartObject();
        gen.writeFieldName("hash");
        gen.writeString(storedContractByHash.getHash().toString());
        gen.writeFieldName("entry_point");
        gen.writeString(storedContractByHash.getEntryPoint());
        this.writeArgs(storedContractByHash, gen);
        gen.writeEndObject();
        gen.writeEndObject();
    }

    private void writeTransfer(Transfer transfer, JsonGenerator gen) throws IOException {
        gen.writeStartObject();
        gen.writeFieldName("Transfer");
        gen.writeStartObject();
        this.writeArgs(transfer, gen);
        gen.writeEndObject();
        gen.writeEndObject();
    }

    private void writeArgs(DeployExecutable value, JsonGenerator gen) throws IOException {
        gen.writeFieldName("args");
        gen.getCodec().writeValue(gen, value.getArgs());
    }
}

