/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.service.serialization.cltypes;

import com.casper.sdk.service.serialization.cltypes.BoolSerializer;
import com.casper.sdk.service.serialization.cltypes.ByteArraySerializer;
import com.casper.sdk.service.serialization.cltypes.I32Serializer;
import com.casper.sdk.service.serialization.cltypes.I64Serializer;
import com.casper.sdk.service.serialization.cltypes.KeySerializer;
import com.casper.sdk.service.serialization.cltypes.MapSerializer;
import com.casper.sdk.service.serialization.cltypes.PublicKeySerializer;
import com.casper.sdk.service.serialization.cltypes.StringSerializer;
import com.casper.sdk.service.serialization.cltypes.TypesSerializer;
import com.casper.sdk.service.serialization.cltypes.U128Serializer;
import com.casper.sdk.service.serialization.cltypes.U256Serializer;
import com.casper.sdk.service.serialization.cltypes.U32Serializer;
import com.casper.sdk.service.serialization.cltypes.U512Serializer;
import com.casper.sdk.service.serialization.cltypes.U64Serializer;
import com.casper.sdk.service.serialization.cltypes.URefSerializer;
import com.casper.sdk.service.serialization.cltypes.UnitSerializer;
import com.casper.sdk.types.CLType;
import java.util.HashMap;
import java.util.Map;

public class TypesFactory {
    private final Map<CLType, TypesSerializer> instances = new HashMap<CLType, TypesSerializer>();

    public TypesFactory() {
        this.instances.put(CLType.BOOL, new BoolSerializer());
        this.instances.put(CLType.BYTE_ARRAY, new ByteArraySerializer(this));
        this.instances.put(CLType.KEY, new KeySerializer());
        this.instances.put(CLType.I32, new I32Serializer());
        this.instances.put(CLType.I64, new I64Serializer());
        this.instances.put(CLType.PUBLIC_KEY, new PublicKeySerializer());
        this.instances.put(CLType.MAP, new MapSerializer(this));
        this.instances.put(CLType.STRING, new StringSerializer(this));
        this.instances.put(CLType.U32, new U32Serializer());
        this.instances.put(CLType.U64, new U64Serializer());
        this.instances.put(CLType.U128, new U128Serializer());
        this.instances.put(CLType.U256, new U256Serializer());
        this.instances.put(CLType.U512, new U512Serializer());
        this.instances.put(CLType.UNIT, new UnitSerializer());
        this.instances.put(CLType.UREF, new URefSerializer());
    }

    public <T extends TypesSerializer> T getInstance(CLType inputType) {
        return (T)this.instances.get((Object)inputType);
    }
}

