/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.service.serialization.types;

import com.casper.sdk.service.serialization.cltypes.TypesFactory;
import com.casper.sdk.service.serialization.types.ByteSerializer;
import com.casper.sdk.service.serialization.types.CLValueByteSerializer;
import com.casper.sdk.service.serialization.types.CollectionByteSerializer;
import com.casper.sdk.service.serialization.types.DeployApprovalByteSerializer;
import com.casper.sdk.service.serialization.types.DeployByteSerializer;
import com.casper.sdk.service.serialization.types.DeployExecutableByteSerializer;
import com.casper.sdk.service.serialization.types.DeployHeaderByteSerializer;
import com.casper.sdk.service.serialization.types.DeployNamedArgByteSerializer;
import com.casper.sdk.service.serialization.types.DigestByteSerializer;
import com.casper.sdk.service.serialization.types.PublicKeyByteSerializer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ByteSerializerFactory {
    private final Map<Class<?>, ByteSerializer<?>> serializerMap = new HashMap();

    public ByteSerializerFactory() {
        TypesFactory typesFactory = new TypesFactory();
        this.register(new CLValueByteSerializer(typesFactory));
        this.register(new CollectionByteSerializer(this, typesFactory));
        this.register(new DeployApprovalByteSerializer());
        this.register(new DeployByteSerializer(this));
        this.register(new DeployExecutableByteSerializer(this, typesFactory));
        this.register(new DeployHeaderByteSerializer(this, typesFactory));
        this.register(new DeployNamedArgByteSerializer(typesFactory));
        this.register(new DigestByteSerializer());
        this.register(new PublicKeyByteSerializer());
    }

    public <T> ByteSerializer<T> getByteSerializer(T source) {
        return this.getByteSerializerByType(source.getClass());
    }

    public <T> ByteSerializer<T> getByteSerializerByType(Class<T> type) {
        Class<T> superclass;
        ByteSerializer<Object> byteSerializer = this.serializerMap.get(type);
        if (byteSerializer == null && (superclass = type.getSuperclass()) != null && !superclass.equals(Object.class)) {
            byteSerializer = this.getByteSerializerByType(superclass);
        }
        if (byteSerializer == null && Collection.class.isAssignableFrom(type)) {
            byteSerializer = this.getByteSerializerByType(Collection.class);
        }
        return byteSerializer;
    }

    protected void register(ByteSerializer<?> byteSerializer) {
        this.serializerMap.put(byteSerializer.getType(), byteSerializer);
    }
}

