/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.service.signing;

import com.casper.sdk.exceptions.SignatureException;
import com.casper.sdk.service.signing.AbstractKeyPairBuilder;
import com.casper.sdk.types.Algorithm;
import java.lang.reflect.Constructor;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import org.bouncycastle.jcajce.provider.asymmetric.edec.BCEdDSAPublicKey;

class Ed25519KeyPariBuilder
extends AbstractKeyPairBuilder {
    public static final String ALGORITHM = "Ed25519";

    Ed25519KeyPariBuilder() {
        super(Algorithm.ED25519);
    }

    @Override
    public KeyPair generateKeyPair(byte[] seed) {
        return this.generateKeyPair(ALGORITHM, ALGORITHM, seed);
    }

    @Override
    public boolean isSupportedPublicKey(PublicKey publicKey) {
        return publicKey instanceof BCEdDSAPublicKey && ALGORITHM.equalsIgnoreCase(publicKey.getAlgorithm());
    }

    @Override
    public PublicKey createPublicKey(byte[] publicKey) {
        try {
            Constructor constructor = BCEdDSAPublicKey.class.getDeclaredConstructor(AsymmetricKeyParameter.class);
            constructor.setAccessible(true);
            return (PublicKey)constructor.newInstance(new Ed25519PublicKeyParameters(publicKey));
        }
        catch (Exception e) {
            throw new SignatureException(e);
        }
    }

    @Override
    public byte[] signWithPrivateKey(PrivateKey privateKey, byte[] message) {
        try {
            Signature sig = Signature.getInstance(privateKey.getAlgorithm(), "BC");
            sig.initSign(privateKey);
            sig.update(message);
            return sig.sign();
        }
        catch (Exception e) {
            throw new SignatureException(e);
        }
    }

    @Override
    public boolean verifySignature(PublicKey publicKey, byte[] message, byte[] signature) {
        try {
            Signature sig = Signature.getInstance(publicKey.getAlgorithm(), "BC");
            sig.initVerify(publicKey);
            sig.update(message);
            return sig.verify(signature);
        }
        catch (Exception e) {
            return false;
        }
    }
}

