/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.service.signing;

import com.casper.sdk.exceptions.SignatureException;
import com.casper.sdk.service.serialization.util.ByteUtils;
import com.casper.sdk.service.signing.AbstractKeyPairBuilder;
import com.casper.sdk.types.Algorithm;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.KeySpec;
import java.util.Arrays;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.encoders.Hex;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Hash;
import org.web3j.crypto.Sign;

public class Secp256k1KeyPairBuilder
extends AbstractKeyPairBuilder {
    public static final String CURVE_NAME = "secp256k1";
    public static final String ALGORITHM = "ECDSA";

    Secp256k1KeyPairBuilder() {
        super(Algorithm.SECP256K1);
    }

    @Override
    public KeyPair generateKeyPair(byte[] seed) {
        return this.generateKeyPair(ALGORITHM, CURVE_NAME, seed);
    }

    @Override
    KeyPair generateKeyPair(String algorithm, String curve, byte[] seed) {
        throw new SignatureException("secp256k1 KeyPair generation is not yet supported.");
    }

    @Override
    public boolean isSupportedPublicKey(PublicKey publicKey) {
        return publicKey instanceof BCECPublicKey && ALGORITHM.equalsIgnoreCase(publicKey.getAlgorithm());
    }

    @Override
    public PublicKey createPublicKey(byte[] publicKey) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM, "BC");
            ECNamedCurveParameterSpec ecSpec = ECNamedCurveTable.getParameterSpec((String)CURVE_NAME);
            ECPoint point = ecSpec.getCurve().decodePoint(publicKey);
            ECPublicKeySpec pubSpec = new ECPublicKeySpec(point, (ECParameterSpec)ecSpec);
            return keyFactory.generatePublic((KeySpec)pubSpec);
        }
        catch (Exception e) {
            throw new SignatureException(e);
        }
    }

    @Override
    public byte[] signWithPrivateKey(PrivateKey privateKey, byte[] message) {
        BCECPrivateKey bcecPrivateKey = (BCECPrivateKey)privateKey;
        BigInteger d = bcecPrivateKey.getD();
        ECKeyPair keyPair = ECKeyPair.create((BigInteger)d);
        Sign.SignatureData signature = Sign.signMessage((byte[])Hash.sha256((byte[])message), (ECKeyPair)keyPair, (boolean)false);
        ByteBuffer bb = ByteBuffer.allocate(signature.getR().length + signature.getS().length);
        bb.put(signature.getR());
        bb.put(signature.getS());
        return bb.array();
    }

    @Override
    public boolean verifySignature(PublicKey publicKey, byte[] message, byte[] signature) {
        try {
            byte[] x = ((BCECPublicKey)publicKey).getQ().getXCoord().getEncoded();
            byte[] y = ((BCECPublicKey)publicKey).getQ().getYCoord().getEncoded();
            byte[] shortPublicKey = this.getShortKey(new BigInteger(ByteUtils.concat(x, y)));
            Sign.SignatureData signatureData = new Sign.SignatureData(27, Arrays.copyOfRange(signature, 0, 32), Arrays.copyOfRange(signature, 32, 64));
            BigInteger derivedKey = Sign.signedMessageHashToKey((byte[])Hash.sha256((byte[])message), (Sign.SignatureData)signatureData);
            byte[] shortDerivedKey = this.getShortKey(derivedKey);
            return Arrays.equals(shortDerivedKey, shortPublicKey);
        }
        catch (Exception e) {
            throw new SignatureException(e);
        }
    }

    private byte[] getShortKey(BigInteger key) {
        String pubKeyPrefix = key.testBit(0) ? "03" : "02";
        byte[] pubKeyBytes = Arrays.copyOf(key.toByteArray(), 32);
        return Hex.decode((String)(pubKeyPrefix + Hex.toHexString((byte[])pubKeyBytes)));
    }
}

