/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.service.http.rpc;

import com.casper.sdk.exceptions.HttpException;
import com.casper.sdk.service.http.rpc.Method;
import com.casper.sdk.service.json.JsonConversionService;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class HttpMethods {
    public static final String APPLICATION_JSON = "application/json";
    public static final String ACCEPT = "Accept";
    public static final String CONTENT_TYPE = "Content-type";
    public static final String RPC = "rpc";
    private static final MediaType JSON = MediaType.get((String)"application/json");
    private final OkHttpClient client = new OkHttpClient();
    private final JsonConversionService jsonConversionService;
    private final String url;
    private final int port;

    public HttpMethods(JsonConversionService jsonConversionService, String url, int port) {
        this.jsonConversionService = jsonConversionService;
        this.url = url;
        this.port = port;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Optional<String> rpcCallMethod(Method method) throws HttpException {
        String content;
        try {
            content = this.jsonConversionService.writeValueAsString(method);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        byte[] bytes = content.getBytes(StandardCharsets.UTF_8);
        RequestBody body = RequestBody.create((MediaType)JSON, (byte[])bytes);
        Request request = new Request.Builder().url(this.buildRpcUrl()).header(ACCEPT, APPLICATION_JSON).header(CONTENT_TYPE, APPLICATION_JSON).post(body).build();
        try (Response response = this.client.newCall(request).execute();){
            Optional<String> optional = Optional.ofNullable(response.body().string());
            return optional;
        }
        catch (IOException e) {
            throw new HttpException(e.getMessage());
        }
    }

    public Optional<String> callGetMethod(String urlPath) {
        try {
            Request request = new Request.Builder().url(this.buildUrl(urlPath)).header(ACCEPT, APPLICATION_JSON).get().build();
            Response response = this.client.newCall(request).execute();
            return Optional.ofNullable(response.body().string());
        }
        catch (Exception e) {
            throw new HttpException(e.getMessage());
        }
    }

    private String buildUrl(String urlPath) {
        return this.url + ':' + this.port + '/' + urlPath;
    }

    private String buildRpcUrl() {
        return this.buildUrl(RPC);
    }
}

