/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.service.serialization.types;

import com.casper.sdk.service.serialization.cltypes.TypesFactory;
import com.casper.sdk.service.serialization.cltypes.TypesSerializer;
import com.casper.sdk.service.serialization.types.ByteSerializer;
import com.casper.sdk.service.serialization.util.ByteArrayBuilder;
import com.casper.sdk.types.CLByteArrayInfo;
import com.casper.sdk.types.CLMapTypeInfo;
import com.casper.sdk.types.CLOptionTypeInfo;
import com.casper.sdk.types.CLType;
import com.casper.sdk.types.CLTypeInfo;

abstract class AbstractByteSerializer<T>
implements ByteSerializer<T> {
    private final TypesSerializer u32Serializer;

    AbstractByteSerializer(TypesFactory typesFactory) {
        this.u32Serializer = typesFactory.getInstance(CLType.U32);
    }

    byte[] toBytesForCLTypeInfo(CLTypeInfo typeInfo) {
        switch (typeInfo.getType()) {
            case BOOL: 
            case I32: 
            case I64: 
            case U8: 
            case U32: 
            case U64: 
            case U128: 
            case U256: 
            case U512: 
            case UNIT: 
            case STRING: 
            case KEY: 
            case UREF: 
            case PUBLIC_KEY: {
                return this.getTypeBytes(typeInfo);
            }
            case BYTE_ARRAY: {
                return this.getByteArrayType((CLByteArrayInfo)typeInfo);
            }
            case OPTION: {
                return this.getOptionType(typeInfo);
            }
            case MAP: {
                return this.getMapType((CLMapTypeInfo)typeInfo);
            }
        }
        throw new IllegalArgumentException("Wrong type " + (Object)((Object)typeInfo.getType()));
    }

    private byte[] getMapType(CLMapTypeInfo typeInfo) {
        return new ByteArrayBuilder().append(this.getTypeBytes(typeInfo)).append(this.toBytesForCLTypeInfo(typeInfo.getKeyType())).append(this.toBytesForCLTypeInfo(typeInfo.getValueType())).toByteArray();
    }

    public TypesSerializer getU32Serializer() {
        return this.u32Serializer;
    }

    private byte[] getByteArrayType(CLByteArrayInfo typeInfo) {
        return new ByteArrayBuilder().append(this.getTypeBytes(typeInfo)).append(this.u32Serializer.serialize(typeInfo.getSize())).toByteArray();
    }

    private byte[] getOptionType(CLTypeInfo typeInfo) {
        return new ByteArrayBuilder().append(this.getTypeBytes(typeInfo)).append(this.toBytesForCLTypeInfo(((CLOptionTypeInfo)typeInfo).getInnerType())).toByteArray();
    }

    private byte[] getTypeBytes(CLTypeInfo typeInfo) {
        return new byte[]{typeInfo.getType().getClType()};
    }
}

