/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.service.serialization.types;

import com.casper.sdk.service.serialization.cltypes.TypesFactory;
import com.casper.sdk.service.serialization.types.AbstractByteSerializer;
import com.casper.sdk.service.serialization.util.ByteUtils;
import com.casper.sdk.types.CLByteArrayInfo;
import com.casper.sdk.types.CLValue;
import java.math.BigInteger;
import org.apache.commons.lang3.ArrayUtils;

class CLValueByteSerializer
extends AbstractByteSerializer<CLValue> {
    public CLValueByteSerializer(TypesFactory typesFactory) {
        super(typesFactory);
    }

    @Override
    public byte[] toBytes(CLValue source) {
        byte[] lengthBytes = this.getLengthBytes(source);
        byte[] sourceBytes = source.getBytes();
        byte[] typeInfoBytes = this.toBytesForCLTypeInfo(source.getCLTypeInfo());
        return ByteUtils.concat(lengthBytes, sourceBytes, typeInfoBytes);
    }

    @Override
    public Class<CLValue> getType() {
        return CLValue.class;
    }

    private byte[] getLengthBytes(CLValue source) {
        if (this.containsLengthBytes(source)) {
            return new byte[0];
        }
        return this.getU32Serializer().serialize(source.getBytes().length);
    }

    private boolean containsLengthBytes(CLValue source) {
        int size;
        if (source.getCLTypeInfo() instanceof CLByteArrayInfo && (size = ((CLByteArrayInfo)source.getCLTypeInfo()).getSize()) >= 4) {
            byte[] lb = new byte[4];
            System.arraycopy(source.getBytes(), 0, lb, 0, 4);
            ArrayUtils.reverse((byte[])lb);
            int biLen = new BigInteger(lb).intValue();
            return biLen == size && source.getBytes().length - 4 == biLen;
        }
        return false;
    }
}

